/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyFieldElement
extends AbstractGroovyElement
implements FieldElement {
    private final Variable variable;
    private final SourceUnit sourceUnit;

    GroovyFieldElement(SourceUnit sourceUnit, CompilationUnit compilationUnit, Variable variable, AnnotatedNode annotatedNode, AnnotationMetadata annotationMetadata) {
        super(sourceUnit, compilationUnit, annotatedNode, annotationMetadata);
        this.variable = variable;
        this.sourceUnit = sourceUnit;
    }

    public String getName() {
        return this.variable.getName();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.variable.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.variable.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.variable.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.variable.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.variable.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.variable.getModifiers());
    }

    public Object getNativeType() {
        return this.variable;
    }

    @Nonnull
    public ClassElement getType() {
        return new GroovyClassElement(this.sourceUnit, this.compilationUnit, this.variable.getType(), AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)this.variable.getType()));
    }

    public ClassElement getDeclaringType() {
        ClassNode declaringClass = null;
        if (this.variable instanceof FieldNode) {
            FieldNode fn = (FieldNode)this.variable;
            declaringClass = fn.getDeclaringClass();
        } else if (this.variable instanceof PropertyNode) {
            PropertyNode pn = (PropertyNode)this.variable;
            declaringClass = pn.getDeclaringClass();
        }
        if (declaringClass == null) {
            throw new IllegalStateException("Declaring class could not be established");
        }
        return new GroovyClassElement(this.sourceUnit, this.compilationUnit, declaringClass, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)declaringClass));
    }
}

