/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.utils;

import groovy.lang.GroovyClassLoader;
import io.micronaut.core.annotation.Internal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilerConfiguration;

@Internal
public class InMemoryByteCodeGroovyClassLoader
extends GroovyClassLoader {
    private Map<String, byte[]> generatedClasses = new ConcurrentHashMap<String, byte[]>();
    private Map<String, Class> loadedClasses = new ConcurrentHashMap<String, Class>();

    public InMemoryByteCodeGroovyClassLoader() {
        this.clearCache();
    }

    public InMemoryByteCodeGroovyClassLoader(ClassLoader loader) {
        super(loader);
        this.clearCache();
    }

    public InMemoryByteCodeGroovyClassLoader(GroovyClassLoader parent) {
        super(parent);
        this.clearCache();
    }

    public InMemoryByteCodeGroovyClassLoader(ClassLoader parent, CompilerConfiguration config, boolean useConfigurationClasspath) {
        super(parent, config, useConfigurationClasspath);
        this.clearCache();
    }

    public InMemoryByteCodeGroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        super(loader, config);
        this.clearCache();
    }

    public void addClass(String name, byte[] code) {
        if (name != null && code != null) {
            this.generatedClasses.put(name, code);
        }
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.loadedClasses.containsKey(name)) {
            return this.loadedClasses.get(name);
        }
        if (this.generatedClasses.containsKey(name)) {
            return this.loadedClasses.computeIfAbsent(name, className -> this.defineClass((String)className, this.generatedClasses.get(className)));
        }
        return super.loadClass(name);
    }
}

