/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.mail;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.jakarta9.instrument.mail.MailObservationDocumentation;
import io.micrometer.jakarta9.instrument.mail.MailSendObservationContext;
import io.micrometer.jakarta9.instrument.mail.MailSendObservationConvention;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class DefaultMailSendObservationConvention
implements MailSendObservationConvention {
    private static final String UNKNOWN = "unknown";

    public String getName() {
        return "mail.send";
    }

    public String getContextualName(MailSendObservationContext context) {
        return "mail send";
    }

    public KeyValues getLowCardinalityKeyValues(MailSendObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.serverAddress(context), this.serverPort(context), this.networkProtocolName(context)});
    }

    public KeyValues getHighCardinalityKeyValues(MailSendObservationContext context) {
        Message message = (Message)context.getCarrier();
        ArrayList values = new ArrayList();
        this.smtpMessageSubject(message).ifPresent(values::add);
        this.smtpMessageFrom(message).ifPresent(values::add);
        this.smtpMessageRecipients(message, Message.RecipientType.TO).ifPresent(values::add);
        this.smtpMessageRecipients(message, Message.RecipientType.CC).ifPresent(values::add);
        this.smtpMessageRecipients(message, Message.RecipientType.BCC).ifPresent(values::add);
        return KeyValues.of(values);
    }

    private KeyValue serverAddress(MailSendObservationContext context) {
        String host = context.getHost();
        if (host == null || host.isEmpty()) {
            return MailObservationDocumentation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue(UNKNOWN);
        }
        return MailObservationDocumentation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue(host);
    }

    private KeyValue serverPort(MailSendObservationContext context) {
        int port = context.getPort();
        if (port <= 0) {
            return MailObservationDocumentation.LowCardinalityKeyNames.SERVER_PORT.withValue(UNKNOWN);
        }
        return MailObservationDocumentation.LowCardinalityKeyNames.SERVER_PORT.withValue(String.valueOf(port));
    }

    private KeyValue networkProtocolName(MailSendObservationContext context) {
        String protocol = context.getProtocol();
        if (protocol == null || protocol.isEmpty()) {
            return MailObservationDocumentation.LowCardinalityKeyNames.NETWORK_PROTOCOL_NAME.withValue(UNKNOWN);
        }
        return MailObservationDocumentation.LowCardinalityKeyNames.NETWORK_PROTOCOL_NAME.withValue(protocol);
    }

    private Optional<KeyValue> smtpMessageSubject(@Nullable Message message) {
        if (message == null) {
            return Optional.empty();
        }
        return this.safeExtractValue(MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_SUBJECT, () -> Optional.ofNullable(message.getSubject()));
    }

    private Optional<KeyValue> smtpMessageFrom(@Nullable Message message) {
        if (message == null) {
            return Optional.empty();
        }
        return this.safeExtractValue(MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_FROM, () -> this.addressesToValue(message.getFrom()));
    }

    private Optional<KeyValue> smtpMessageRecipients(@Nullable Message message, Message.RecipientType recipientType) {
        if (message == null) {
            return Optional.empty();
        }
        MailObservationDocumentation.HighCardinalityKeyNames key = MailObservationDocumentation.HighCardinalityKeyNames.valueOf("SMTP_MESSAGE_" + recipientType.toString().toUpperCase(Locale.ROOT));
        return this.safeExtractValue(key, () -> this.addressesToValue(message.getRecipients(recipientType)));
    }

    Optional<KeyValue> smtpMessageId(@Nullable Message message) {
        if (message == null) {
            return Optional.empty();
        }
        return this.safeExtractValue(MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_ID, () -> this.extractHeaderValue(message, "Message-ID"));
    }

    private Optional<String> extractHeaderValue(Message message, String headerName) throws MessagingException {
        CharSequence[] header = message.getHeader(headerName);
        if (header == null || header.length == 0) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)", ", header));
    }

    private Optional<KeyValue> safeExtractValue(KeyName key, ValueExtractor extractor) {
        try {
            return extractor.extract().map(arg_0 -> ((KeyName)key).withValue(arg_0));
        }
        catch (MessagingException ex) {
            return Optional.of(key.withValue(UNKNOWN));
        }
    }

    private Optional<String> addressesToValue(Address @Nullable [] addresses) {
        if (addresses == null || addresses.length == 0) {
            return Optional.empty();
        }
        String value = Arrays.stream(addresses).map(Address::toString).collect(Collectors.joining(", "));
        return Optional.of(value);
    }

    private static interface ValueExtractor {
        public Optional<String> extract() throws MessagingException;
    }
}

