/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.TokenBindingInfo;
import java.util.Optional;

final class TokenBindingValidator {
    TokenBindingValidator() {
    }

    static boolean validate(Optional<TokenBindingInfo> clientTokenBinding, Optional<ByteArray> rpTokenBindingId) {
        return rpTokenBindingId.map(rpToken -> clientTokenBinding.map(tbi -> {
            switch (tbi.getStatus()) {
                case SUPPORTED: 
                case PRESENT: {
                    return tbi.getId().map(id -> {
                        if (id.equals(rpToken)) {
                            return true;
                        }
                        throw new IllegalArgumentException("Incorrect token binding ID.");
                    }).orElseThrow(() -> new IllegalArgumentException("Property \"id\" missing from \"tokenBinding\" object."));
                }
            }
            throw new RuntimeException("Unknown token binding status: " + (Object)((Object)tbi.getStatus()));
        }).orElseThrow(() -> new IllegalArgumentException("Token binding ID set by RP but not by client."))).orElseGet(() -> clientTokenBinding.map(tbi -> {
            switch (tbi.getStatus()) {
                case SUPPORTED: {
                    return true;
                }
                case PRESENT: {
                    throw new IllegalArgumentException("Token binding ID set by client but not by RP.");
                }
            }
            throw new RuntimeException("Unknown token binding status: " + (Object)((Object)tbi.getStatus()));
        }).orElse(true));
    }
}

