/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.CredentialRecord;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.ByteArray;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public final class RegisteredCredential
implements CredentialRecord {
    @NonNull
    private final ByteArray credentialId;
    @NonNull
    private final ByteArray userHandle;
    @NonNull
    private final ByteArray publicKeyCose;
    private final long signatureCount;
    @Deprecated
    private final Set<AuthenticatorTransport> transports;
    @Deprecated
    private final Boolean backupEligible;
    @Deprecated
    private final Boolean backupState;

    @JsonIgnore
    @NonNull
    public PublicKey getParsedPublicKey() throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        return WebAuthnCodecs.importCosePublicKey(this.getPublicKeyCose());
    }

    @JsonCreator
    private RegisteredCredential(@JsonProperty(value="credentialId") @NonNull ByteArray credentialId, @JsonProperty(value="userHandle") @NonNull ByteArray userHandle, @JsonProperty(value="publicKeyCose") @NonNull ByteArray publicKeyCose, @JsonProperty(value="signatureCount") long signatureCount, @JsonProperty(value="transports") Set<AuthenticatorTransport> transports, @JsonProperty(value="backupEligible") Boolean backupEligible, @JsonProperty(value="backupState") @JsonAlias(value={"backedUp"}) Boolean backupState) {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        if (userHandle == null) {
            throw new NullPointerException("userHandle is marked non-null but is null");
        }
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        this.credentialId = credentialId;
        this.userHandle = userHandle;
        this.publicKeyCose = publicKeyCose;
        this.signatureCount = signatureCount;
        this.transports = transports;
        this.backupEligible = backupEligible;
        this.backupState = backupState;
    }

    @Override
    @Deprecated
    public Optional<Set<AuthenticatorTransport>> getTransports() {
        return Optional.ofNullable(this.transports);
    }

    @Override
    @Deprecated
    @JsonProperty(value="backupEligible")
    public Optional<Boolean> isBackupEligible() {
        return Optional.ofNullable(this.backupEligible);
    }

    @Override
    @Deprecated
    @JsonProperty(value="backupState")
    public Optional<Boolean> isBackedUp() {
        return Optional.ofNullable(this.backupState);
    }

    public static RegisteredCredentialBuilder.MandatoryStages builder() {
        return new RegisteredCredentialBuilder.MandatoryStages();
    }

    @Generated
    private static long $default$signatureCount() {
        return 0L;
    }

    @Generated
    private static Set<AuthenticatorTransport> $default$transports() {
        return null;
    }

    @Generated
    private static Boolean $default$backupEligible() {
        return null;
    }

    @Generated
    private static Boolean $default$backupState() {
        return null;
    }

    @Generated
    public RegisteredCredentialBuilder toBuilder() {
        return new RegisteredCredentialBuilder().credentialId(this.credentialId).userHandle(this.userHandle).publicKeyCose(this.publicKeyCose).signatureCount(this.signatureCount).transports(this.transports).backupEligible(this.backupEligible).backupState(this.backupState);
    }

    @Override
    @NonNull
    @Generated
    public ByteArray getCredentialId() {
        return this.credentialId;
    }

    @Override
    @NonNull
    @Generated
    public ByteArray getUserHandle() {
        return this.userHandle;
    }

    @Override
    @NonNull
    @Generated
    public ByteArray getPublicKeyCose() {
        return this.publicKeyCose;
    }

    @Override
    @Generated
    public long getSignatureCount() {
        return this.signatureCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredCredential)) {
            return false;
        }
        RegisteredCredential other = (RegisteredCredential)o;
        if (this.getSignatureCount() != other.getSignatureCount()) {
            return false;
        }
        Boolean this$backupEligible = this.backupEligible;
        Boolean other$backupEligible = other.backupEligible;
        if (this$backupEligible == null ? other$backupEligible != null : !((Object)this$backupEligible).equals(other$backupEligible)) {
            return false;
        }
        Boolean this$backupState = this.backupState;
        Boolean other$backupState = other.backupState;
        if (this$backupState == null ? other$backupState != null : !((Object)this$backupState).equals(other$backupState)) {
            return false;
        }
        ByteArray this$credentialId = this.getCredentialId();
        ByteArray other$credentialId = other.getCredentialId();
        if (this$credentialId == null ? other$credentialId != null : !((Object)this$credentialId).equals(other$credentialId)) {
            return false;
        }
        ByteArray this$userHandle = this.getUserHandle();
        ByteArray other$userHandle = other.getUserHandle();
        if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
            return false;
        }
        ByteArray this$publicKeyCose = this.getPublicKeyCose();
        ByteArray other$publicKeyCose = other.getPublicKeyCose();
        if (this$publicKeyCose == null ? other$publicKeyCose != null : !((Object)this$publicKeyCose).equals(other$publicKeyCose)) {
            return false;
        }
        Optional<Set<AuthenticatorTransport>> this$transports = this.getTransports();
        Optional<Set<AuthenticatorTransport>> other$transports = other.getTransports();
        return !(this$transports == null ? other$transports != null : !((Object)this$transports).equals(other$transports));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        Boolean $backupEligible = this.backupEligible;
        result = result * 59 + ($backupEligible == null ? 43 : ((Object)$backupEligible).hashCode());
        Boolean $backupState = this.backupState;
        result = result * 59 + ($backupState == null ? 43 : ((Object)$backupState).hashCode());
        ByteArray $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : ((Object)$credentialId).hashCode());
        ByteArray $userHandle = this.getUserHandle();
        result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
        ByteArray $publicKeyCose = this.getPublicKeyCose();
        result = result * 59 + ($publicKeyCose == null ? 43 : ((Object)$publicKeyCose).hashCode());
        Optional<Set<AuthenticatorTransport>> $transports = this.getTransports();
        result = result * 59 + ($transports == null ? 43 : ((Object)$transports).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegisteredCredential(credentialId=" + this.getCredentialId() + ", userHandle=" + this.getUserHandle() + ", publicKeyCose=" + this.getPublicKeyCose() + ", signatureCount=" + this.getSignatureCount() + ", transports=" + this.getTransports() + ", backupEligible=" + this.backupEligible + ", backupState=" + this.backupState + ")";
    }

    public static class RegisteredCredentialBuilder {
        @Generated
        private ByteArray credentialId;
        @Generated
        private ByteArray userHandle;
        @Generated
        private ByteArray publicKeyCose;
        @Generated
        private boolean signatureCount$set;
        @Generated
        private long signatureCount$value;
        @Generated
        private boolean transports$set;
        @Generated
        private Set<AuthenticatorTransport> transports$value;
        @Generated
        private boolean backupEligible$set;
        @Generated
        private Boolean backupEligible$value;
        @Generated
        private boolean backupState$set;
        @Generated
        private Boolean backupState$value;

        public RegisteredCredentialBuilder publicKeyCose(@NonNull ByteArray publicKeyCose) {
            if (publicKeyCose == null) {
                throw new NullPointerException("publicKeyCose is marked non-null but is null");
            }
            this.publicKeyCose = publicKeyCose;
            return this;
        }

        public RegisteredCredentialBuilder publicKeyEs256Raw(ByteArray publicKeyEs256Raw) {
            return this.publicKeyCose(WebAuthnCodecs.rawEcKeyToCose(publicKeyEs256Raw));
        }

        @Generated
        RegisteredCredentialBuilder() {
        }

        @Generated
        public RegisteredCredentialBuilder credentialId(@NonNull ByteArray credentialId) {
            if (credentialId == null) {
                throw new NullPointerException("credentialId is marked non-null but is null");
            }
            this.credentialId = credentialId;
            return this;
        }

        @Generated
        public RegisteredCredentialBuilder userHandle(@NonNull ByteArray userHandle) {
            if (userHandle == null) {
                throw new NullPointerException("userHandle is marked non-null but is null");
            }
            this.userHandle = userHandle;
            return this;
        }

        @Generated
        public RegisteredCredentialBuilder signatureCount(long signatureCount) {
            this.signatureCount$value = signatureCount;
            this.signatureCount$set = true;
            return this;
        }

        @Deprecated
        @Generated
        public RegisteredCredentialBuilder transports(Set<AuthenticatorTransport> transports) {
            this.transports$value = transports;
            this.transports$set = true;
            return this;
        }

        @Deprecated
        @Generated
        public RegisteredCredentialBuilder backupEligible(Boolean backupEligible) {
            this.backupEligible$value = backupEligible;
            this.backupEligible$set = true;
            return this;
        }

        @Deprecated
        @Generated
        public RegisteredCredentialBuilder backupState(Boolean backupState) {
            this.backupState$value = backupState;
            this.backupState$set = true;
            return this;
        }

        @Generated
        public RegisteredCredential build() {
            long signatureCount$value = this.signatureCount$value;
            if (!this.signatureCount$set) {
                signatureCount$value = RegisteredCredential.$default$signatureCount();
            }
            Set transports$value = this.transports$value;
            if (!this.transports$set) {
                transports$value = RegisteredCredential.$default$transports();
            }
            Boolean backupEligible$value = this.backupEligible$value;
            if (!this.backupEligible$set) {
                backupEligible$value = RegisteredCredential.$default$backupEligible();
            }
            Boolean backupState$value = this.backupState$value;
            if (!this.backupState$set) {
                backupState$value = RegisteredCredential.$default$backupState();
            }
            return new RegisteredCredential(this.credentialId, this.userHandle, this.publicKeyCose, signatureCount$value, transports$value, backupEligible$value, backupState$value);
        }

        @Generated
        public String toString() {
            return "RegisteredCredential.RegisteredCredentialBuilder(credentialId=" + this.credentialId + ", userHandle=" + this.userHandle + ", publicKeyCose=" + this.publicKeyCose + ", signatureCount$value=" + this.signatureCount$value + ", transports$value=" + this.transports$value + ", backupEligible$value=" + this.backupEligible$value + ", backupState$value=" + this.backupState$value + ")";
        }

        public static class MandatoryStages {
            private final RegisteredCredentialBuilder builder = new RegisteredCredentialBuilder();

            public Step2 credentialId(ByteArray credentialId) {
                this.builder.credentialId(credentialId);
                return new Step2();
            }

            public class Step2 {
                public Step3 userHandle(ByteArray userHandle) {
                    MandatoryStages.this.builder.userHandle(userHandle);
                    return new Step3();
                }
            }

            public class Step3 {
                public RegisteredCredentialBuilder publicKeyCose(ByteArray publicKeyCose) {
                    return MandatoryStages.this.builder.publicKeyCose(publicKeyCose);
                }

                public RegisteredCredentialBuilder publicKeyEs256Raw(ByteArray publicKeyEs256Raw) {
                    return MandatoryStages.this.builder.publicKeyCose(WebAuthnCodecs.rawEcKeyToCose(publicKeyEs256Raw));
                }
            }
        }
    }
}

