/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.codegen.languages;

import com.wordnik.swagger.codegen.CodegenConfig;
import com.wordnik.swagger.codegen.CodegenType;
import com.wordnik.swagger.codegen.DefaultCodegen;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.util.Json;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class SwaggerGenerator
extends DefaultCodegen
implements CodegenConfig {
    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "swagger";
    }

    @Override
    public String getHelp() {
        return "Creates a static swagger.json file.";
    }

    public SwaggerGenerator() {
        this.outputFolder = "generated-code/swagger";
    }

    @Override
    public void processSwagger(Swagger swagger) {
        String swaggerString = Json.pretty((Object)swagger);
        try {
            String outputFile = this.outputFolder + File.separator + "swagger.json";
            FileUtils.writeStringToFile((File)new File(outputFile), (String)swaggerString);
            System.out.println("wrote file to " + outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

