/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.codegen.languages;

import com.wordnik.swagger.codegen.CodegenConfig;
import com.wordnik.swagger.codegen.CodegenType;
import com.wordnik.swagger.codegen.DefaultCodegen;
import com.wordnik.swagger.codegen.SupportingFile;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import java.io.File;

public class PythonClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    String module = "client";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public String getHelp() {
        return "Generates a Python client library.";
    }

    public PythonClientCodegen() {
        this.outputFolder = "generated-code/python";
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTemplateFiles.put("api.mustache", ".py");
        this.templateDir = "python";
        this.apiPackage = this.module;
        this.modelPackage = this.module + ".models";
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("long");
        this.languageSpecificPrimitives.add("list");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "datetime");
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("swagger.mustache", this.module, "swagger.py"));
        this.supportingFiles.add(new SupportingFile("__init__.mustache", this.module, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__.mustache", this.modelPackage.replace('.', File.separatorChar), "__init__.py"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "(String, " + this.getTypeDeclaration(inner) + ")";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return type;
    }

    @Override
    public String toDefaultValue(Property p) {
        return "null";
    }
}

