/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.codegen.languages;

import com.wordnik.swagger.codegen.CodegenConfig;
import com.wordnik.swagger.codegen.CodegenType;
import com.wordnik.swagger.codegen.DefaultCodegen;
import com.wordnik.swagger.codegen.SupportingFile;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;

public class PhpClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "com.wordnik.client";
    protected String groupId = "com.wordnik";
    protected String artifactId = "swagger-client";
    protected String artifactVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "php";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP client library.";
    }

    public PhpClientCodegen() {
        this.modelPackage = "models";
        this.outputFolder = "generated-code/php";
        this.modelTemplateFiles.put("model.mustache", ".php");
        this.apiTemplateFiles.put("api.mustache", ".php");
        this.templateDir = "php";
        this.typeMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.reservedWords = new HashSet<String>(Arrays.asList("int"));
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("DateTime");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Array", "array");
        this.typeMapping.put("String", "string");
        this.typeMapping.put("List", "array");
        this.typeMapping.put("map", "map");
        this.supportingFiles.add(new SupportingFile("Swagger.mustache", "", "Swagger.php"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    public String toDefaultValue(Property p) {
        return "null";
    }
}

