/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.codegen.languages;

import com.wordnik.swagger.codegen.CodegenConfig;
import com.wordnik.swagger.codegen.CodegenType;
import com.wordnik.swagger.codegen.DefaultCodegen;
import com.wordnik.swagger.codegen.SupportingFile;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ObjcClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String sourceFolder = "client";
    protected static String PREFIX = "SWG";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "objc";
    }

    @Override
    public String getHelp() {
        return "Generates an Objective-C client library.";
    }

    public ObjcClientCodegen() {
        this.outputFolder = "generated-code/objc";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".m");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".m");
        this.templateDir = "objc";
        this.modelPackage = "";
        this.additionalProperties.put("projectName", "swaggerClient");
        this.defaultIncludes = new HashSet<String>(Arrays.asList("bool", "int", "NSString", "NSObject", "NSArray", "NSNumber", "NSDictionary", "NSMutableArray", "NSMutableDictionary"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("NSNumber", "NSString", "NSObject", "bool"));
        this.reservedWords = new HashSet<String>(Arrays.asList("void", "char", "short", "int", "void", "char", "short", "int", "long", "float", "double", "signed", "unsigned", "id", "const", "volatile", "in", "out", "inout", "bycopy", "byref", "oneway", "self", "super", "description"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("Date", "SWGDate");
        this.typeMapping.put("DateTime", "SWGDate");
        this.typeMapping.put("boolean", "NSNumber");
        this.typeMapping.put("string", "NSString");
        this.typeMapping.put("integer", "NSNumber");
        this.typeMapping.put("int", "NSNumber");
        this.typeMapping.put("float", "NSNumber");
        this.typeMapping.put("long", "NSNumber");
        this.typeMapping.put("double", "NSNumber");
        this.typeMapping.put("array", "NSArray");
        this.typeMapping.put("map", "NSDictionary");
        this.typeMapping.put("number", "NSNumber");
        this.typeMapping.put("List", "NSArray");
        this.typeMapping.put("object", "NSObject");
        this.importMapping = new HashMap();
        this.importMapping.put("Date", "SWGDate");
        this.foundationClasses = new HashSet<String>(Arrays.asList("NSNumber", "NSObject", "NSString", "NSDictionary"));
        this.instantiationTypes.put("array", "NSMutableArray");
        this.instantiationTypes.put("map", "NSMutableDictionary");
        this.supportingFiles.add(new SupportingFile("SWGObject.h", this.sourceFolder, "SWGObject.h"));
        this.supportingFiles.add(new SupportingFile("SWGObject.m", this.sourceFolder, "SWGObject.m"));
        this.supportingFiles.add(new SupportingFile("SWGApiClient.h", this.sourceFolder, "SWGApiClient.h"));
        this.supportingFiles.add(new SupportingFile("SWGApiClient.m", this.sourceFolder, "SWGApiClient.m"));
        this.supportingFiles.add(new SupportingFile("SWGFile.h", this.sourceFolder, "SWGFile.h"));
        this.supportingFiles.add(new SupportingFile("SWGFile.m", this.sourceFolder, "SWGFile.m"));
        this.supportingFiles.add(new SupportingFile("SWGDate.h", this.sourceFolder, "SWGDate.h"));
        this.supportingFiles.add(new SupportingFile("SWGDate.m", this.sourceFolder, "SWGDate.m"));
        this.supportingFiles.add(new SupportingFile("Podfile.mustache", "", "Podfile"));
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return (String)this.instantiationTypes.get("map");
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return (String)this.instantiationTypes.get("array");
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (this.languageSpecificPrimitives.contains(name) && !this.foundationClasses.contains(name)) {
            return name;
        }
        return name + "*";
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type) && !this.foundationClasses.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (this.languageSpecificPrimitives.contains(swaggerType) && !this.foundationClasses.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return swaggerType + "*";
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.foundationClasses.contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return Character.toUpperCase(type.charAt(0)) + type.substring(1);
        }
        return PREFIX + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    @Override
    public String toDefaultValue(Property p) {
        return null;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder;
    }

    @Override
    public String toModelFilename(String name) {
        return PREFIX + this.initialCaps(name);
    }

    @Override
    public String toApiName(String name) {
        return PREFIX + this.initialCaps(name) + "Api";
    }

    @Override
    public String toApiFilename(String name) {
        return PREFIX + this.initialCaps(name) + "Api";
    }

    @Override
    public String toVarName(String name) {
        String paramName = name.replaceAll("[^a-zA-Z0-9_]", "");
        if (paramName.startsWith("new") || this.reservedWords.contains(paramName)) {
            return this.escapeReservedWord(paramName);
        }
        return paramName;
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }
}

