/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.codegen.languages;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.wordnik.swagger.codegen.CodegenConfig;
import com.wordnik.swagger.codegen.CodegenModel;
import com.wordnik.swagger.codegen.CodegenType;
import com.wordnik.swagger.codegen.DefaultCodegen;
import com.wordnik.swagger.codegen.SupportingFile;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.util.Json;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class NodeJSServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "com.wordnik.client";
    protected String groupId = "com.wordnik";
    protected String artifactId = "swagger-client";
    protected String artifactVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "nodejs";
    }

    @Override
    public String getHelp() {
        return "Generates a node.js server application compatible with the 1.2 swagger specification.";
    }

    public NodeJSServerCodegen() {
        this.outputFolder = "generated-code/nodejs";
        this.apiTemplateFiles.put("api.mustache", ".js");
        this.templateDir = "nodejs";
        this.apiPackage = "app.apis";
        this.modelPackage = "app";
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage, "models.js"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.js"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float"));
        this.typeMapping.put("array", "array");
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        List o = (List)objs.get("models");
        for (Map modelMap : o) {
            try {
                CodegenModel m = (CodegenModel)modelMap.get("model");
                ObjectNode on = (ObjectNode)Json.mapper().readTree(m.modelJson);
                on.put("id", m.name);
                m.modelJson = Json.pretty((Object)on).replaceAll("\"#/definitions/", "\"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objs;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        type = swaggerType;
        return this.toModelName(type);
    }
}

