/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.codegen;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import com.wordnik.swagger.codegen.ClientOptInput;
import com.wordnik.swagger.codegen.ClientOpts;
import com.wordnik.swagger.codegen.CodegenConfig;
import com.wordnik.swagger.codegen.CodegenModel;
import com.wordnik.swagger.codegen.CodegenOperation;
import com.wordnik.swagger.codegen.Generator;
import com.wordnik.swagger.codegen.SupportingFile;
import com.wordnik.swagger.models.Contact;
import com.wordnik.swagger.models.Info;
import com.wordnik.swagger.models.License;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.Operation;
import com.wordnik.swagger.models.Path;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.util.Json;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class DefaultGenerator
implements Generator {
    protected CodegenConfig config;
    protected ClientOptInput opts = null;
    protected Swagger swagger = null;

    @Override
    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.swagger = opts.getSwagger();
        ClientOpts clientOpts = opts.getOpts();
        this.config = opts.getConfig();
        this.config.additionalProperties().putAll(clientOpts.getProperties());
        return this;
    }

    @Override
    public List<File> generate() {
        if (this.swagger == null || this.config == null) {
            throw new RuntimeException("missing swagger input or config!");
        }
        if (System.getProperty("debugSwagger") != null) {
            Json.prettyPrint((Object)this.swagger);
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            Template tmpl;
            String template;
            String filename;
            String suffix;
            this.config.processOpts();
            if (this.swagger.getInfo() != null) {
                Info info = this.swagger.getInfo();
                if (info.getTitle() != null) {
                    this.config.additionalProperties().put("appName", info.getTitle());
                }
                if (info.getDescription() != null) {
                    this.config.additionalProperties().put("appDescription", info.getDescription());
                }
                if (info.getContact() != null) {
                    Contact contact = info.getContact();
                    this.config.additionalProperties().put("infoUrl", contact.getUrl());
                    if (contact.getEmail() != null) {
                        this.config.additionalProperties().put("infoEmail", contact.getEmail());
                    }
                }
                if (info.getLicense() != null) {
                    License license = info.getLicense();
                    if (license.getName() != null) {
                        this.config.additionalProperties().put("licenseInfo", license.getName());
                    }
                    if (license.getUrl() != null) {
                        this.config.additionalProperties().put("licenseUrl", license.getUrl());
                    }
                }
            }
            StringBuilder hostBuilder = new StringBuilder();
            if (this.swagger.getSchemes() != null && this.swagger.getSchemes().size() > 0) {
                hostBuilder.append(((Scheme)this.swagger.getSchemes().get(0)).toValue());
                hostBuilder.append("://");
            } else {
                hostBuilder.append("https://");
            }
            hostBuilder.append(this.swagger.getHost()).append(this.swagger.getBasePath());
            String basePath = hostBuilder.toString();
            ArrayList<Map<String, Object>> allOperations = new ArrayList<Map<String, Object>>();
            ArrayList allModels = new ArrayList();
            Map definitions = this.swagger.getDefinitions();
            if (definitions != null) {
                for (String name : definitions.keySet()) {
                    Model model = (Model)definitions.get(name);
                    HashMap<String, Model> modelMap = new HashMap<String, Model>();
                    modelMap.put(name, model);
                    Map<String, Object> models = this.processModels(this.config, modelMap);
                    models.putAll(this.config.additionalProperties());
                    allModels.add(((List)models.get("models")).get(0));
                    for (String templateName : this.config.modelTemplateFiles().keySet()) {
                        suffix = this.config.modelTemplateFiles().get(templateName);
                        filename = this.config.modelFileFolder() + File.separator + this.config.toModelFilename(name) + suffix;
                        template = this.readTemplate(this.config.templateDir() + File.separator + templateName);
                        tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                            public Reader getTemplate(String name) {
                                return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.config.templateDir() + File.separator + name + ".mustache");
                            }
                        }).defaultValue("").compile(template);
                        this.writeToFile(filename, tmpl.execute(models));
                        files.add(new File(filename));
                    }
                }
            }
            if (System.getProperty("debugModels") != null) {
                System.out.println("############ Model info ############");
                Json.prettyPrint(allModels);
            }
            Map<String, List<CodegenOperation>> paths = this.processPaths(this.swagger.getPaths());
            for (String tag : paths.keySet()) {
                List<CodegenOperation> ops = paths.get(tag);
                Map<String, Object> operation = this.processOperations(this.config, tag, ops);
                operation.put("basePath", basePath);
                operation.put("baseName", tag);
                operation.put("modelPackage", this.config.modelPackage());
                operation.putAll(this.config.additionalProperties());
                operation.put("classname", this.config.toApiName(tag));
                operation.put("classVarName", this.config.toApiVarName(tag));
                allOperations.add(operation);
                for (String templateName : this.config.apiTemplateFiles().keySet()) {
                    suffix = this.config.apiTemplateFiles().get(templateName);
                    filename = this.config.apiFileFolder() + File.separator + this.config.toApiFilename(tag) + suffix;
                    template = this.readTemplate(this.config.templateDir() + File.separator + templateName);
                    tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                        public Reader getTemplate(String name) {
                            return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.config.templateDir() + File.separator + name + ".mustache");
                        }
                    }).defaultValue("").compile(template);
                    this.writeToFile(filename, tmpl.execute(operation));
                    files.add(new File(filename));
                }
            }
            if (System.getProperty("debugOperations") != null) {
                System.out.println("############ Operation info ############");
                Json.prettyPrint(allOperations);
            }
            HashMap<String, Object> bundle = new HashMap<String, Object>();
            bundle.putAll(this.config.additionalProperties());
            bundle.put("apiPackage", this.config.apiPackage());
            HashMap<String, ArrayList<Map<String, Object>>> apis = new HashMap<String, ArrayList<Map<String, Object>>>();
            apis.put("apis", allOperations);
            if (this.swagger.getBasePath() != null) {
                bundle.put("basePath", this.swagger.getBasePath());
            }
            bundle.put("apiInfo", apis);
            bundle.put("models", allModels);
            bundle.put("apiFolder", this.config.apiPackage().replace('.', File.separatorChar));
            bundle.put("modelPackage", this.config.modelPackage());
            if (this.swagger.getExternalDocs() != null) {
                bundle.put("externalDocs", this.swagger.getExternalDocs());
            }
            for (int i = 0; i < allModels.size() - 1; ++i) {
                HashMap cm = (HashMap)allModels.get(i);
                CodegenModel m = (CodegenModel)cm.get("model");
                m.hasMoreModels = true;
            }
            this.config.postProcessSupportingFileData(bundle);
            if (System.getProperty("debugSupportingFiles") != null) {
                System.out.println("############ Supporting file info ############");
                Json.prettyPrint(bundle);
            }
            for (SupportingFile support : this.config.supportingFiles()) {
                String template2;
                File of;
                String outputFolder = this.config.outputFolder();
                if (support.folder != null && !"".equals(support.folder)) {
                    outputFolder = outputFolder + File.separator + support.folder;
                }
                if (!(of = new File(outputFolder)).isDirectory()) {
                    of.mkdirs();
                }
                String outputFilename = outputFolder + File.separator + support.destinationFilename;
                if (support.templateFile.endsWith("mustache")) {
                    template2 = this.readTemplate(this.config.templateDir() + File.separator + support.templateFile);
                    Template tmpl2 = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                        public Reader getTemplate(String name) {
                            return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.config.templateDir() + File.separator + name + ".mustache");
                        }
                    }).defaultValue("").compile(template2);
                    this.writeToFile(outputFilename, tmpl2.execute(bundle));
                    files.add(new File(outputFilename));
                    continue;
                }
                template2 = this.readTemplate(this.config.templateDir() + File.separator + support.templateFile);
                FileUtils.writeStringToFile((File)new File(outputFilename), (String)template2);
                System.out.println("copying file to " + outputFilename);
                files.add(new File(outputFilename));
            }
            this.config.processSwagger(this.swagger);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    public Map<String, List<CodegenOperation>> processPaths(Map<String, Path> paths) {
        HashMap<String, List<CodegenOperation>> ops = new HashMap<String, List<CodegenOperation>>();
        Object tags = null;
        for (String resourcePath : paths.keySet()) {
            Path path = paths.get(resourcePath);
            this.processOperation(resourcePath, "get", path.getGet(), ops);
            this.processOperation(resourcePath, "put", path.getPut(), ops);
            this.processOperation(resourcePath, "post", path.getPost(), ops);
            this.processOperation(resourcePath, "delete", path.getDelete(), ops);
            this.processOperation(resourcePath, "patch", path.getPatch(), ops);
            this.processOperation(resourcePath, "options", path.getOptions(), ops);
        }
        return ops;
    }

    public void processOperation(String resourcePath, String httpMethod, Operation operation, Map<String, List<CodegenOperation>> operations) {
        if (operation != null) {
            ArrayList<String> tags = operation.getTags();
            if (tags == null) {
                tags = new ArrayList<String>();
                tags.add("default");
            }
            for (String tag : tags) {
                CodegenOperation co = this.config.fromOperation(resourcePath, httpMethod, operation);
                co.tags = new ArrayList<String>();
                co.tags.add(this.sanitizeTag(tag));
                this.config.addOperationToGroup(this.sanitizeTag(tag), resourcePath, operation, co, operations);
            }
        }
    }

    protected String sanitizeTag(String tag) {
        String[] parts = tag.split(" ");
        StringBuffer buf = new StringBuffer();
        for (String part : parts) {
            if ("".equals(part)) continue;
            buf.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            buf.append(part.substring(1));
        }
        return buf.toString().replaceAll("[^a-zA-Z ]", "");
    }

    public File writeToFile(String filename, String contents) throws IOException {
        System.out.println("writing file " + filename);
        File output = new File(filename);
        if (output.getParent() != null && !new File(output.getParent()).exists()) {
            File parent = new File(output.getParent());
            parent.mkdirs();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        out.write(contents);
        ((Writer)out).close();
        return output;
    }

    public String readTemplate(String name) {
        try {
            Reader reader = this.getTemplateReader(name);
            if (reader == null) {
                throw new RuntimeException("no file found");
            }
            Scanner s = new Scanner(reader).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("can't load template " + name);
        }
    }

    public Reader getTemplateReader(String name) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(name));
            if (is == null) {
                is = new FileInputStream(new File(name));
            }
            if (is == null) {
                throw new RuntimeException("no file found");
            }
            return new InputStreamReader(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("can't load template " + name);
        }
    }

    private String getCPResourcePath(String name) {
        if (!"/".equals(File.separator)) {
            return name.replaceAll(Pattern.quote(File.separator), "/");
        }
        return name;
    }

    public Map<String, Object> processOperations(CodegenConfig config, String tag, List<CodegenOperation> ops) {
        HashMap<String, Object> operations = new HashMap<String, Object>();
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("classname", config.toApiName(tag));
        objs.put("operation", ops);
        operations.put("operations", objs);
        operations.put("package", config.apiPackage());
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (CodegenOperation op : ops) {
            allImports.addAll(op.imports);
        }
        ArrayList imports = new ArrayList();
        for (String i : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String m = config.importMapping().get(i);
            if (m == null) {
                m = config.toModelImport(i);
            }
            if (m == null) continue;
            im.put("import", m);
            imports.add(im);
        }
        operations.put("imports", imports);
        config.postProcessOperations(operations);
        return operations;
    }

    public Map<String, Object> processModels(CodegenConfig config, Map<String, Model> definitions) {
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("package", config.modelPackage());
        ArrayList models = new ArrayList();
        ArrayList model = new ArrayList();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (String key : definitions.keySet()) {
            Model mm = definitions.get(key);
            CodegenModel cm = config.fromModel(key, mm);
            HashMap<String, CodegenModel> mo = new HashMap<String, CodegenModel>();
            mo.put("model", cm);
            models.add(mo);
            allImports.addAll(cm.imports);
        }
        objs.put("models", models);
        ArrayList imports = new ArrayList();
        for (String i : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String m = config.importMapping().get(i);
            if (m == null) {
                m = config.toModelImport(i);
            }
            if (m != null && !config.defaultIncludes().contains(m)) {
                im.put("import", m);
                imports.add(im);
            }
            if ((m = config.instantiationTypes().get(i)) == null || config.defaultIncludes().contains(m)) continue;
            im.put("import", m);
            imports.add(im);
        }
        objs.put("imports", imports);
        config.postProcessModels(objs);
        return objs;
    }
}

