/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.codegen;

import com.wordnik.swagger.codegen.CodegenModel;
import com.wordnik.swagger.codegen.CodegenModelFactory;
import com.wordnik.swagger.codegen.CodegenModelType;
import com.wordnik.swagger.codegen.CodegenOperation;
import com.wordnik.swagger.codegen.CodegenParameter;
import com.wordnik.swagger.codegen.CodegenProperty;
import com.wordnik.swagger.codegen.CodegenResponse;
import com.wordnik.swagger.codegen.SupportingFile;
import com.wordnik.swagger.models.ArrayModel;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.ModelImpl;
import com.wordnik.swagger.models.Operation;
import com.wordnik.swagger.models.RefModel;
import com.wordnik.swagger.models.Response;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.parameters.BodyParameter;
import com.wordnik.swagger.models.parameters.CookieParameter;
import com.wordnik.swagger.models.parameters.FormParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.parameters.SerializableParameter;
import com.wordnik.swagger.models.properties.AbstractNumericProperty;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.BooleanProperty;
import com.wordnik.swagger.models.properties.DateProperty;
import com.wordnik.swagger.models.properties.DateTimeProperty;
import com.wordnik.swagger.models.properties.DecimalProperty;
import com.wordnik.swagger.models.properties.DoubleProperty;
import com.wordnik.swagger.models.properties.FloatProperty;
import com.wordnik.swagger.models.properties.IntegerProperty;
import com.wordnik.swagger.models.properties.LongProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.PropertyBuilder;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.models.properties.StringProperty;
import com.wordnik.swagger.util.Json;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCodegen {
    Logger LOGGER = LoggerFactory.getLogger(DefaultCodegen.class);
    protected String outputFolder = "";
    protected Set<String> defaultIncludes = new HashSet<String>();
    protected Map<String, String> typeMapping = new HashMap<String, String>();
    protected Map<String, String> instantiationTypes = new HashMap<String, String>();
    protected Set<String> reservedWords = new HashSet<String>();
    protected Set<String> languageSpecificPrimitives = new HashSet<String>();
    protected Map<String, String> importMapping = new HashMap<String, String>();
    protected String modelPackage = "";
    protected String apiPackage = "";
    protected String fileSuffix;
    protected Map<String, String> apiTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTemplateFiles = new HashMap<String, String>();
    protected String templateDir;
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected List<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();

    public void processOpts() {
        if (this.additionalProperties.containsKey("templateDir")) {
            this.setTemplateDir((String)this.additionalProperties.get("templateDir"));
        }
    }

    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        return objs;
    }

    public void processSwagger(Swagger swagger) {
    }

    public String escapeText(String input) {
        if (input != null) {
            String output = input.replaceAll("\n", " ");
            output = output.replace("\"", "\\\"");
            return output;
        }
        return input;
    }

    public Set<String> defaultIncludes() {
        return this.defaultIncludes;
    }

    public Map<String, String> typeMapping() {
        return this.typeMapping;
    }

    public Map<String, String> instantiationTypes() {
        return this.instantiationTypes;
    }

    public Set<String> reservedWords() {
        return this.reservedWords;
    }

    public Set<String> languageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    public Map<String, String> importMapping() {
        return this.importMapping;
    }

    public String modelPackage() {
        return this.modelPackage;
    }

    public String apiPackage() {
        return this.apiPackage;
    }

    public String fileSuffix() {
        return this.fileSuffix;
    }

    public String templateDir() {
        return this.templateDir;
    }

    public Map<String, String> apiTemplateFiles() {
        return this.apiTemplateFiles;
    }

    public Map<String, String> modelTemplateFiles() {
        return this.modelTemplateFiles;
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public List<SupportingFile> supportingFiles() {
        return this.supportingFiles;
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public void setOutputDir(String dir) {
        this.outputFolder = dir;
    }

    public String getOutputDir() {
        return this.outputFolder();
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String toApiFilename(String name) {
        return this.initialCaps(name) + "Api";
    }

    public String toApiVarName(String name) {
        return this.snakeCase(name);
    }

    public String toModelFilename(String name) {
        return name;
    }

    public String toVarName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String toParamName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String escapeReservedWord(String name) {
        throw new RuntimeException("reserved word " + name + " not allowed");
    }

    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    public String toApiImport(String name) {
        return this.apiPackage() + "." + name;
    }

    public DefaultCodegen() {
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "int", "long", "short", "char", "float", "String", "boolean", "Boolean", "Double", "Void", "Integer", "Long", "Float"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.instantiationTypes = new HashMap<String, String>();
        this.reservedWords = new HashSet<String>();
        this.importMapping = new HashMap<String, String>();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("List", "java.util.*");
        this.importMapping.put("Set", "java.util.*");
        this.importMapping.put("DateTime", "org.joda.time.*");
        this.importMapping.put("LocalDateTime", "org.joda.time.*");
        this.importMapping.put("LocalDate", "org.joda.time.*");
        this.importMapping.put("LocalTime", "org.joda.time.*");
    }

    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "null";
        }
        if (p instanceof BooleanProperty) {
            return "null";
        }
        if (p instanceof DateProperty) {
            return "null";
        }
        if (p instanceof DateTimeProperty) {
            return "null";
        }
        if (p instanceof DoubleProperty) {
            return "null";
        }
        if (p instanceof FloatProperty) {
            return "null";
        }
        if (p instanceof IntegerProperty) {
            return "null";
        }
        if (p instanceof LongProperty) {
            return "null";
        }
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "new HashMap<String, " + inner + ">() ";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return "new ArrayList<" + inner + ">() ";
        }
        return "null";
    }

    public String getSwaggerType(Property p) {
        String datatype = null;
        if (p instanceof StringProperty) {
            datatype = "string";
        } else if (p instanceof BooleanProperty) {
            datatype = "boolean";
        } else if (p instanceof DateProperty) {
            datatype = "date";
        } else if (p instanceof DateTimeProperty) {
            datatype = "DateTime";
        } else if (p instanceof DoubleProperty) {
            datatype = "double";
        } else if (p instanceof FloatProperty) {
            datatype = "float";
        } else if (p instanceof IntegerProperty) {
            datatype = "integer";
        } else if (p instanceof LongProperty) {
            datatype = "long";
        } else if (p instanceof MapProperty) {
            datatype = "map";
        } else if (p instanceof DecimalProperty) {
            datatype = "number";
        } else if (p instanceof RefProperty) {
            RefProperty r = (RefProperty)p;
            datatype = r.get$ref();
            if (datatype.indexOf("#/definitions/") == 0) {
                datatype = datatype.substring("#/definitions/".length());
            }
        } else if (p != null) {
            datatype = p.getType();
        }
        return datatype;
    }

    public String snakeCase(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public String initialCaps(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public String getTypeDeclaration(String name) {
        return name;
    }

    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return this.typeMapping.get(swaggerType);
        }
        return swaggerType;
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return this.initialCaps(name) + "Api";
    }

    public String toModelName(String name) {
        return this.initialCaps(name);
    }

    public CodegenModel fromModel(String name, Model model) {
        CodegenModel m = (CodegenModel)CodegenModelFactory.newInstance(CodegenModelType.MODEL);
        m.name = this.reservedWords.contains(name) ? this.escapeReservedWord(name) : name;
        m.description = model.getDescription();
        m.classname = this.toModelName(name);
        m.classVarName = this.toVarName(name);
        m.modelJson = Json.pretty((Object)model);
        m.externalDocs = model.getExternalDocs();
        int count = 0;
        if (model instanceof ArrayModel) {
            ArrayModel am = (ArrayModel)model;
            ArrayProperty arrayProperty = new ArrayProperty(am.getItems());
            CodegenProperty cp = this.fromProperty(name, (Property)arrayProperty);
            if (cp.complexType != null && !this.defaultIncludes.contains(cp.complexType)) {
                m.imports.add(cp.complexType);
            }
            m.parent = this.toInstantiationType((Property)arrayProperty);
            String containerType = cp.containerType;
            if (this.instantiationTypes.containsKey(containerType)) {
                m.imports.add(this.instantiationTypes.get(containerType));
            }
            if (this.typeMapping.containsKey(containerType)) {
                cp.containerType = containerType = this.typeMapping.get(containerType);
                m.imports.add(containerType);
            }
        } else if (!(model instanceof RefModel)) {
            ModelImpl impl = (ModelImpl)model;
            if (impl.getAdditionalProperties() != null) {
                MapProperty mapProperty = new MapProperty(impl.getAdditionalProperties());
                CodegenProperty cp = this.fromProperty(name, (Property)mapProperty);
                if (cp.complexType != null && !this.defaultIncludes.contains(cp.complexType)) {
                    m.imports.add(cp.complexType);
                }
                m.parent = this.toInstantiationType((Property)mapProperty);
                String containerType = cp.containerType;
                if (this.instantiationTypes.containsKey(containerType)) {
                    m.imports.add(this.instantiationTypes.get(containerType));
                }
                if (this.typeMapping.containsKey(containerType)) {
                    cp.containerType = containerType = this.typeMapping.get(containerType);
                    m.imports.add(containerType);
                }
            }
            if (impl.getProperties() != null && impl.getProperties().size() > 0) {
                m.hasVars = true;
                for (String key : impl.getProperties().keySet()) {
                    String arrayImport;
                    Property prop = (Property)impl.getProperties().get(key);
                    if (prop == null) {
                        this.LOGGER.warn("null property for " + key);
                        continue;
                    }
                    CodegenProperty cp = this.fromProperty(key, prop);
                    cp.required = false;
                    if (impl.getRequired() != null) {
                        for (String req : impl.getRequired()) {
                            if (!key.equals(req)) continue;
                            cp.required = true;
                        }
                    }
                    if (cp.complexType != null && !this.defaultIncludes.contains(cp.complexType)) {
                        m.imports.add(cp.complexType);
                    }
                    m.vars.add(cp);
                    if (++count != impl.getProperties().keySet().size()) {
                        cp.hasMore = new Boolean(true);
                    }
                    if (cp.isContainer != null && (arrayImport = this.typeMapping.get("array")) != null && !this.languageSpecificPrimitives.contains(arrayImport) && !this.defaultIncludes.contains(arrayImport)) {
                        m.imports.add(arrayImport);
                    }
                    if (cp.complexType != null && !this.languageSpecificPrimitives.contains(cp.complexType) && !this.defaultIncludes.contains(cp.complexType)) {
                        m.imports.add(cp.complexType);
                    }
                    if (cp.baseType == null || this.languageSpecificPrimitives.contains(cp.baseType) || this.defaultIncludes.contains(cp.baseType)) continue;
                    m.imports.add(cp.baseType);
                }
            } else {
                m.emptyVars = true;
            }
        }
        return m;
    }

    public CodegenProperty fromProperty(String name, Property p) {
        CodegenProperty cp;
        ArrayProperty ap;
        if (p == null) {
            this.LOGGER.error("unexpected missing property for name " + null);
            return null;
        }
        CodegenProperty property = (CodegenProperty)CodegenModelFactory.newInstance(CodegenModelType.PROPERTY);
        property.name = this.toVarName(name);
        property.baseName = name;
        property.description = this.escapeText(p.getDescription());
        property.getter = "get" + this.initialCaps(name);
        property.setter = "set" + this.initialCaps(name);
        property.example = p.getExample();
        property.defaultValue = this.toDefaultValue(p);
        String type = this.getSwaggerType(p);
        if (p instanceof AbstractNumericProperty) {
            AbstractNumericProperty np = (AbstractNumericProperty)p;
            property.minimum = np.getMinimum();
            property.maximum = np.getMaximum();
            property.exclusiveMinimum = np.getExclusiveMinimum();
            property.exclusiveMaximum = np.getExclusiveMaximum();
            HashMap<String, Object> allowableValues = new HashMap<String, Object>();
            if (np.getMinimum() != null) {
                allowableValues.put("min", np.getMinimum());
            }
            if (np.getMaximum() != null) {
                allowableValues.put("max", np.getMaximum());
            }
            property.allowableValues = allowableValues;
        }
        if (p instanceof StringProperty) {
            StringProperty sp = (StringProperty)p;
            property.maxLength = sp.getMaxLength();
            property.minLength = sp.getMinLength();
            property.pattern = sp.getPattern();
            if (sp.getEnum() != null) {
                List _enum;
                property._enum = _enum = sp.getEnum();
                property.isEnum = true;
                HashMap<String, Object> allowableValues = new HashMap<String, Object>();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        property.datatype = this.getTypeDeclaration(p);
        property.datatypeWithEnum = property.isEnum ? StringUtils.capitalize((String)property.name) + "Enum" : property.datatype;
        property.baseType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            property.isContainer = true;
            property.containerType = "array";
            ap = (ArrayProperty)p;
            cp = this.fromProperty("inner", ap.getItems());
            if (cp == null) {
                this.LOGGER.warn("skipping invalid property " + Json.pretty((Object)p));
            } else {
                property.baseType = this.getSwaggerType(p);
                if (!this.languageSpecificPrimitives.contains(cp.baseType)) {
                    property.complexType = cp.baseType;
                } else {
                    property.isPrimitiveType = true;
                }
            }
        } else if (p instanceof MapProperty) {
            property.isContainer = true;
            property.containerType = "map";
            ap = (MapProperty)p;
            cp = this.fromProperty("inner", ap.getAdditionalProperties());
            property.baseType = this.getSwaggerType(p);
            if (!this.languageSpecificPrimitives.contains(cp.baseType)) {
                property.complexType = cp.baseType;
            } else {
                property.isPrimitiveType = true;
            }
        } else {
            property.isNotContainer = true;
            if (this.languageSpecificPrimitives().contains(type)) {
                property.isPrimitiveType = true;
            } else {
                property.complexType = property.baseType;
            }
        }
        return property;
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation) {
        HashMap<String, String> mediaType;
        ArrayList<Map<String, String>> c;
        CodegenOperation op = (CodegenOperation)CodegenModelFactory.newInstance(CodegenModelType.OPERATION);
        HashSet<String> imports = new HashSet<String>();
        String operationId = operation.getOperationId();
        if (operationId == null) {
            String tmpPath = path;
            tmpPath = tmpPath.replaceAll("\\{", "");
            tmpPath = tmpPath.replaceAll("\\}", "");
            String[] parts = (tmpPath + "/" + httpMethod).split("/");
            StringBuilder builder = new StringBuilder();
            if ("/".equals(tmpPath)) {
                builder.append("root");
            }
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.length() <= 0) continue;
                part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : this.initialCaps(part);
                builder.append(part);
            }
            operationId = builder.toString();
            this.LOGGER.warn("generated operationId " + operationId);
        }
        op.path = path;
        op.operationId = operationId;
        op.summary = this.escapeText(operation.getSummary());
        op.notes = this.escapeText(operation.getDescription());
        op.tags = operation.getTags();
        Response methodResponse = null;
        if (operation.getConsumes() != null && operation.getConsumes().size() > 0) {
            c = new ArrayList<Map<String, String>>();
            int count = 0;
            for (String key : operation.getConsumes()) {
                mediaType = new HashMap<String, String>();
                mediaType.put("mediaType", key);
                if (++count < operation.getConsumes().size()) {
                    mediaType.put("hasMore", "true");
                }
                c.add(mediaType);
            }
            op.consumes = c;
            op.hasConsumes = true;
        }
        if (operation.getProduces() != null && operation.getProduces().size() > 0) {
            c = new ArrayList();
            int count = 0;
            for (String key : operation.getProduces()) {
                mediaType = new HashMap();
                mediaType.put("mediaType", key);
                if (++count < operation.getProduces().size()) {
                    mediaType.put("hasMore", "true");
                }
                c.add(mediaType);
            }
            op.produces = c;
            op.hasProduces = true;
        }
        if (operation.getResponses() != null) {
            for (String responseCode : new TreeSet(operation.getResponses().keySet())) {
                Response response = (Response)operation.getResponses().get(responseCode);
                if (!responseCode.startsWith("2")) continue;
                methodResponse = response;
                break;
            }
            if (methodResponse == null && operation.getResponses().keySet().contains("default")) {
                methodResponse = (Response)operation.getResponses().get("default");
            }
            for (String responseCode : operation.getResponses().keySet()) {
                Response response = (Response)operation.getResponses().get(responseCode);
                if (response != methodResponse) {
                    CodegenResponse r = this.fromResponse(responseCode, response);
                    op.responses.add(r);
                }
                for (int i = 0; i < op.responses.size() - 1; ++i) {
                    CodegenResponse r = op.responses.get(i);
                    r.hasMore = new Boolean(true);
                }
            }
        }
        if (methodResponse != null) {
            if (methodResponse.getSchema() != null) {
                CodegenProperty cm = this.fromProperty("response", methodResponse.getSchema());
                Property responseProperty = methodResponse.getSchema();
                if (responseProperty instanceof ArrayProperty) {
                    ArrayProperty ap = (ArrayProperty)responseProperty;
                    CodegenProperty innerProperty = this.fromProperty("response", ap.getItems());
                    op.returnBaseType = innerProperty.baseType;
                } else {
                    op.returnBaseType = cm.complexType != null ? cm.complexType : cm.baseType;
                }
                op.examples = this.toExamples(methodResponse.getExamples());
                op.defaultResponse = this.toDefaultValue(responseProperty);
                op.returnType = cm.datatype;
                if (cm.isContainer != null) {
                    op.returnContainer = cm.containerType;
                    if ("map".equals(cm.containerType)) {
                        op.isMapContainer = Boolean.TRUE;
                    } else if ("list".equalsIgnoreCase(cm.containerType)) {
                        op.isListContainer = Boolean.TRUE;
                    }
                } else {
                    op.returnSimpleType = true;
                }
                if (this.languageSpecificPrimitives().contains(op.returnBaseType) || op.returnBaseType == null) {
                    op.returnTypeIsPrimitive = true;
                }
            }
            this.addHeaders(methodResponse, op.responseHeaders);
        }
        if (op.returnBaseType == null) {
            op.returnTypeIsPrimitive = true;
            op.returnSimpleType = true;
        }
        if (op.returnBaseType != null && !this.defaultIncludes.contains(op.returnBaseType) && !this.languageSpecificPrimitives.contains(op.returnBaseType)) {
            imports.add(op.returnBaseType);
        }
        List parameters = operation.getParameters();
        CodegenParameter bodyParam = null;
        ArrayList<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> formParams = new ArrayList<CodegenParameter>();
        if (parameters != null) {
            for (Parameter param : parameters) {
                CodegenParameter p = this.fromParameter(param, imports);
                allParams.add(p);
                if (param instanceof QueryParameter) {
                    p.isQueryParam = new Boolean(true);
                    queryParams.add(p.copy());
                    continue;
                }
                if (param instanceof PathParameter) {
                    p.required = true;
                    p.isPathParam = new Boolean(true);
                    pathParams.add(p.copy());
                    continue;
                }
                if (param instanceof HeaderParameter) {
                    p.isHeaderParam = new Boolean(true);
                    headerParams.add(p.copy());
                    continue;
                }
                if (param instanceof CookieParameter) {
                    p.isCookieParam = new Boolean(true);
                    cookieParams.add(p.copy());
                    continue;
                }
                if (param instanceof BodyParameter) {
                    p.isBodyParam = new Boolean(true);
                    bodyParam = p;
                    bodyParams.add(p.copy());
                    continue;
                }
                if (!(param instanceof FormParameter)) continue;
                if ("file".equalsIgnoreCase(((FormParameter)param).getType())) {
                    p.isFile = true;
                } else {
                    p.notFile = true;
                }
                p.isFormParam = new Boolean(true);
                formParams.add(p.copy());
            }
        }
        for (String i : imports) {
            if (this.defaultIncludes.contains(i) || this.languageSpecificPrimitives.contains(i)) continue;
            op.imports.add(i);
        }
        op.bodyParam = bodyParam;
        op.httpMethod = httpMethod.toUpperCase();
        op.allParams = this.addHasMore(allParams);
        op.bodyParams = this.addHasMore(bodyParams);
        op.pathParams = this.addHasMore(pathParams);
        op.queryParams = this.addHasMore(queryParams);
        op.headerParams = this.addHasMore(headerParams);
        op.formParams = this.addHasMore(formParams);
        op.nickname = operationId;
        if (op.allParams.size() > 0) {
            op.hasParams = true;
        }
        op.externalDocs = operation.getExternalDocs();
        return op;
    }

    public CodegenResponse fromResponse(String responseCode, Response response) {
        CodegenResponse r = (CodegenResponse)CodegenModelFactory.newInstance(CodegenModelType.RESPONSE);
        r.code = "default".equals(responseCode) ? "0" : responseCode;
        r.message = response.getDescription();
        r.schema = response.getSchema();
        r.examples = this.toExamples(response.getExamples());
        return r;
    }

    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        CodegenParameter p = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        p.baseName = param.getName();
        p.description = param.getDescription();
        p.required = param.getRequired();
        if (param instanceof SerializableParameter) {
            SerializableParameter qp = (SerializableParameter)param;
            Property property = null;
            String collectionFormat = null;
            if ("array".equals(qp.getType())) {
                Property inner = qp.getItems();
                if (inner == null) {
                    this.LOGGER.warn("warning!  No inner type supplied for array parameter \"" + qp.getName() + "\", using String");
                    inner = new StringProperty().description("//TODO automatically added by swagger-codegen");
                }
                property = new ArrayProperty(inner);
                collectionFormat = qp.getCollectionFormat();
                CodegenProperty pr = this.fromProperty("inner", inner);
                p.baseType = pr.datatype;
                imports.add(pr.baseType);
            } else {
                property = PropertyBuilder.build((String)qp.getType(), (String)qp.getFormat(), null);
            }
            if (property == null) {
                this.LOGGER.warn("warning!  Property type \"" + qp.getType() + "\" not found for parameter \"" + param.getName() + "\", using String");
                property = new StringProperty().description("//TODO automatically added by swagger-codegen.  Type was " + qp.getType() + " but not supported");
            }
            CodegenProperty model = this.fromProperty(qp.getName(), property);
            p.collectionFormat = collectionFormat;
            p.dataType = model.datatype;
            p.paramName = this.toParamName(qp.getName());
            if (model.complexType != null) {
                imports.add(model.complexType);
            }
        } else {
            BodyParameter bp = (BodyParameter)param;
            Model model = bp.getSchema();
            if (model instanceof ModelImpl) {
                ModelImpl impl = (ModelImpl)model;
                CodegenModel cm = this.fromModel(bp.getName(), (Model)impl);
                if (cm.emptyVars != null && !cm.emptyVars.booleanValue()) {
                    p.dataType = this.getTypeDeclaration(cm.classname);
                    imports.add(p.dataType);
                } else {
                    Property prop = PropertyBuilder.build((String)impl.getType(), null, null);
                    CodegenProperty cp = this.fromProperty("property", prop);
                    if (cp != null) {
                        p.dataType = cp.datatype;
                    }
                }
            } else if (model instanceof ArrayModel) {
                ArrayModel impl = (ArrayModel)model;
                CodegenModel cm = this.fromModel(bp.getName(), (Model)impl);
                ArrayProperty ap = new ArrayProperty().items(impl.getItems());
                CodegenProperty cp = this.fromProperty("inner", (Property)ap);
                if (cp.complexType != null) {
                    imports.add(cp.complexType);
                }
                imports.add(cp.baseType);
                p.dataType = cp.datatype;
                p.isContainer = true;
            } else {
                Model sub = bp.getSchema();
                if (sub instanceof RefModel) {
                    String name = ((RefModel)sub).getSimpleRef();
                    if (this.typeMapping.containsKey(name)) {
                        name = this.typeMapping.get(name);
                    } else {
                        if (this.defaultIncludes.contains(name = this.toModelName(name))) {
                            imports.add(name);
                        }
                        imports.add(name);
                        name = this.getTypeDeclaration(name);
                    }
                    p.dataType = name;
                }
            }
            p.paramName = this.toParamName(bp.getName());
        }
        return p;
    }

    protected List<Map<String, String>> toExamples(Map<String, String> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        for (String key : examples.keySet()) {
            String value = examples.get(key);
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put("contentType", key);
            kv.put("example", value);
            output.add(kv);
        }
        return output;
    }

    private void addHeaders(Response response, List<CodegenProperty> target) {
        if (response.getHeaders() != null) {
            for (Map.Entry headers : response.getHeaders().entrySet()) {
                target.add(this.fromProperty((String)headers.getKey(), (Property)headers.getValue()));
            }
        }
    }

    private List<CodegenParameter> addHasMore(List<CodegenParameter> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                if (i > 0) {
                    objs.get((int)i).secondaryParam = new Boolean(true);
                }
                if (i >= objs.size() - 1) continue;
                objs.get((int)i).hasMore = new Boolean(true);
            }
        }
        return objs;
    }

    private Map<String, Object> addHasMore(Map<String, Object> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size() - 1; ++i) {
                if (i > 0) {
                    objs.put("secondaryParam", new Boolean(true));
                }
                if (i >= objs.size() - 1) continue;
                objs.put("hasMore", true);
            }
        }
        return objs;
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        opList.add(co);
        co.baseName = tag;
    }
}

