/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.codegen;

import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.codegen.ClientOpts;
import com.wordnik.swagger.codegen.CodegenConfig;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.auth.AuthorizationValue;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class ClientOptInput {
    private ClientOpts opts;
    private Swagger swagger;
    private List<AuthorizationValue> auths;
    protected CodegenConfig config;

    public ClientOptInput swagger(Swagger swagger) {
        this.setSwagger(swagger);
        return this;
    }

    public ClientOptInput opts(ClientOpts opts) {
        this.setOpts(opts);
        return this;
    }

    public void setAuth(String urlEncodedAuthString) {
        ArrayList<AuthorizationValue> auths = new ArrayList<AuthorizationValue>();
        if (urlEncodedAuthString != null && !"".equals(urlEncodedAuthString)) {
            String[] parts;
            for (String part : parts = urlEncodedAuthString.split(",")) {
                String[] kvPair = part.split(":");
                if (kvPair.length != 2) continue;
                auths.add(new AuthorizationValue(URLDecoder.decode(kvPair[0]), URLDecoder.decode(kvPair[1]), "header"));
            }
        }
        this.auths = auths;
    }

    public String getAuth() {
        if (this.auths != null) {
            StringBuilder b = new StringBuilder();
            for (AuthorizationValue v : this.auths) {
                try {
                    if (b.toString().length() > 0) {
                        b.append(",");
                    }
                    b.append(URLEncoder.encode(v.getKeyName(), "UTF-8")).append(":").append(URLEncoder.encode(v.getValue(), "UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return b.toString();
        }
        return null;
    }

    public List<AuthorizationValue> getAuthorizationValues() {
        return this.auths;
    }

    public CodegenConfig getConfig() {
        return this.config;
    }

    public void setConfig(CodegenConfig config) {
        this.config = config;
    }

    public void setOpts(ClientOpts opts) {
        this.opts = opts;
    }

    public ClientOpts getOpts() {
        return this.opts;
    }

    public void setSwagger(Swagger swagger) {
        this.swagger = swagger;
    }

    @ApiModelProperty(dataType="Object")
    public Swagger getSwagger() {
        return this.swagger;
    }
}

