/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class IntervalEmitter<E, R> {
    private volatile long lastEmit = -1L;
    private long maxInterval;
    private Timer timer;
    private volatile List<R> events = new ArrayList<R>();
    private final EventMapper<E, R> eventMapper;
    private final IntervalAppender<R> appender;

    IntervalEmitter(long maxInterval, EventMapper<E, R> eventMapper, IntervalAppender<R> appender) {
        this.maxInterval = maxInterval;
        this.eventMapper = eventMapper;
        this.appender = appender;
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                IntervalEmitter.this.append(null);
            }
        }, this.maxInterval, this.maxInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(E event) {
        long now = System.currentTimeMillis();
        if (now > this.lastEmit + this.maxInterval) {
            IntervalEmitter intervalEmitter = this;
            synchronized (intervalEmitter) {
                ArrayList<R> copiedEvents = new ArrayList<R>(this.events);
                this.events = new ArrayList<R>(copiedEvents.size() + 3);
                if (event != null) {
                    copiedEvents.add(this.eventMapper.map(event));
                }
                if (this.emit(copiedEvents)) {
                    this.lastEmit = now;
                }
            }
        } else if (event != null) {
            this.events.add(this.eventMapper.map(event));
        }
    }

    public boolean emit(List<R> copiedEvents) {
        if (!copiedEvents.isEmpty()) {
            if (this.appender.append(copiedEvents)) {
                return true;
            }
            this.events.addAll(0, copiedEvents);
            return false;
        }
        return true;
    }

    public void emitForShutdown(long waitMillis, int retry) {
        try {
            for (int i = 0; i < retry; ++i) {
                if (this.emit(this.events)) {
                    return;
                }
                Thread.sleep(waitMillis);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.println("Could not write the log: " + this.events);
    }

    public static interface IntervalAppender<R> {
        public boolean append(List<R> var1);
    }

    public static interface EventMapper<E, R> {
        public R map(E var1);
    }
}

