/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.more.appenders.FluentdAppenderBase;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.komamitsu.fluency.EventTime;
import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.fluentd.FluencyBuilderForFluentd;

public class FluencyLogbackAppender<E>
extends FluentdAppenderBase<E> {
    private Fluency fluency;
    private RemoteServers remoteServers;
    private boolean ackResponseMode;
    private String fileBackupDir;
    private Integer bufferChunkInitialSize;
    private Integer bufferChunkRetentionSize;
    private Integer bufferChunkRetentionTimeMillis;
    private Long maxBufferSize;
    private Integer connectionTimeoutMilli;
    private Integer readTimeoutMilli;
    private Integer waitUntilBufferFlushed;
    private Integer waitUntilFlusherTerminated;
    private Integer flushAttemptIntervalMillis;
    private Integer senderMaxRetryCount;
    private boolean sslEnabled;
    private Boolean jvmHeapBufferMode;

    public void start() {
        try {
            FluencyBuilderForFluentd builder = this.configureFluency();
            this.fluency = this.getRemoteHost() != null && this.getPort() > 0 && (this.remoteServers == null || this.remoteServers.getRemoteServers().size() == 0) ? builder.build(this.getRemoteHost(), this.getPort()) : builder.build(this.configureServers());
            super.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void append(E event) {
        Map<String, Object> data = this.createData(event);
        try {
            String tag;
            String string = tag = this.getTag() == null ? "" : this.getTag();
            if (this.isUseEventTime()) {
                EventTime eventTime;
                if (event instanceof ILoggingEvent) {
                    long timeStampInMs = ((ILoggingEvent)event).getTimeStamp();
                    eventTime = EventTime.fromEpochMilli((long)timeStampInMs);
                } else if (event instanceof IAccessEvent) {
                    long timeStampInMs = ((IAccessEvent)event).getTimeStamp();
                    eventTime = EventTime.fromEpochMilli((long)timeStampInMs);
                } else {
                    eventTime = EventTime.fromEpochMilli((long)System.currentTimeMillis());
                }
                this.fluency.emit(tag, eventTime, data);
            } else {
                this.fluency.emit(tag, data);
            }
        }
        catch (IOException e) {
            this.addError("Fluency throws the error and the message has been omitted. " + data, e);
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        catch (Throwable throwable) {
            try {
                this.fluency.flush();
                long maxWaitMillis = Math.min((this.waitUntilBufferFlushed != null ? this.waitUntilBufferFlushed : 1) + (this.waitUntilFlusherTerminated != null ? this.waitUntilFlusherTerminated : 1), 5) * 1000;
                Thread.sleep(maxWaitMillis);
                this.fluency.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.fluency.flush();
            long maxWaitMillis = Math.min((this.waitUntilBufferFlushed != null ? this.waitUntilBufferFlushed : 1) + (this.waitUntilFlusherTerminated != null ? this.waitUntilFlusherTerminated : 1), 5) * 1000;
            Thread.sleep(maxWaitMillis);
            this.fluency.close();
        }
        catch (Exception exception) {}
    }

    public RemoteServers getRemoteServers() {
        return this.remoteServers;
    }

    public void setRemoteServers(RemoteServers remoteServers) {
        this.remoteServers = remoteServers;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean useSsl) {
        this.sslEnabled = useSsl;
    }

    public boolean isAckResponseMode() {
        return this.ackResponseMode;
    }

    public void setAckResponseMode(boolean ackResponseMode) {
        this.ackResponseMode = ackResponseMode;
    }

    public String getFileBackupDir() {
        return this.fileBackupDir;
    }

    public void setFileBackupDir(String fileBackupDir) {
        this.fileBackupDir = fileBackupDir;
    }

    public Integer getBufferChunkInitialSize() {
        return this.bufferChunkInitialSize;
    }

    public void setBufferChunkInitialSize(Integer bufferChunkInitialSize) {
        this.bufferChunkInitialSize = bufferChunkInitialSize;
    }

    public Integer getBufferChunkRetentionSize() {
        return this.bufferChunkRetentionSize;
    }

    public void setBufferChunkRetentionSize(Integer bufferChunkRetentionSize) {
        this.bufferChunkRetentionSize = bufferChunkRetentionSize;
    }

    public Integer getBufferChunkRetentionTimeMillis() {
        return this.bufferChunkRetentionTimeMillis;
    }

    public void setBufferChunkRetentionTimeMillis(Integer bufferChunkRetentionTimeMillis) {
        this.bufferChunkRetentionTimeMillis = bufferChunkRetentionTimeMillis;
    }

    public Long getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(Long maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public Integer getConnectionTimeoutMilli() {
        return this.connectionTimeoutMilli;
    }

    public void setConnectionTimeoutMilli(Integer connectionTimeoutMilli) {
        this.connectionTimeoutMilli = connectionTimeoutMilli;
    }

    public Integer getReadTimeoutMilli() {
        return this.readTimeoutMilli;
    }

    public void setReadTimeoutMilli(Integer readTimeoutMilli) {
        this.readTimeoutMilli = readTimeoutMilli;
    }

    public Integer getWaitUntilBufferFlushed() {
        return this.waitUntilBufferFlushed;
    }

    public void setWaitUntilBufferFlushed(Integer waitUntilBufferFlushed) {
        this.waitUntilBufferFlushed = waitUntilBufferFlushed;
    }

    public Integer getWaitUntilFlusherTerminated() {
        return this.waitUntilFlusherTerminated;
    }

    public void setWaitUntilFlusherTerminated(Integer waitUntilFlusherTerminated) {
        this.waitUntilFlusherTerminated = waitUntilFlusherTerminated;
    }

    public Integer getFlushAttemptIntervalMillis() {
        return this.flushAttemptIntervalMillis;
    }

    public void setFlushAttemptIntervalMillis(Integer flushAttemptIntervalMillis) {
        this.flushAttemptIntervalMillis = flushAttemptIntervalMillis;
    }

    public Integer getSenderMaxRetryCount() {
        return this.senderMaxRetryCount;
    }

    public void setSenderMaxRetryCount(Integer senderMaxRetryCount) {
        this.senderMaxRetryCount = senderMaxRetryCount;
    }

    public Boolean getJvmHeapBufferMode() {
        return this.jvmHeapBufferMode;
    }

    public void setJvmHeapBufferMode(Boolean jvmHeapBufferMode) {
        this.jvmHeapBufferMode = jvmHeapBufferMode;
    }

    protected FluencyBuilderForFluentd configureFluency() {
        FluencyBuilderForFluentd builder = new FluencyBuilderForFluentd();
        builder.setAckResponseMode(this.ackResponseMode);
        if (this.fileBackupDir != null) {
            builder.setFileBackupDir(this.fileBackupDir);
        }
        if (this.bufferChunkInitialSize != null) {
            builder.setBufferChunkInitialSize(this.bufferChunkInitialSize);
        }
        if (this.bufferChunkRetentionSize != null) {
            builder.setBufferChunkRetentionSize(this.bufferChunkRetentionSize);
        }
        if (this.bufferChunkRetentionTimeMillis != null) {
            builder.setBufferChunkRetentionTimeMillis(this.bufferChunkRetentionTimeMillis);
        }
        if (this.maxBufferSize != null) {
            builder.setMaxBufferSize(this.maxBufferSize);
        }
        if (this.connectionTimeoutMilli != null) {
            builder.setConnectionTimeoutMilli(this.connectionTimeoutMilli);
        }
        if (this.readTimeoutMilli != null) {
            builder.setReadTimeoutMilli(this.readTimeoutMilli);
        }
        if (this.waitUntilBufferFlushed != null) {
            builder.setWaitUntilBufferFlushed(this.waitUntilBufferFlushed);
        }
        if (this.waitUntilFlusherTerminated != null) {
            builder.setWaitUntilFlusherTerminated(this.waitUntilFlusherTerminated);
        }
        if (this.flushAttemptIntervalMillis != null) {
            builder.setFlushAttemptIntervalMillis(this.flushAttemptIntervalMillis);
        }
        if (this.senderMaxRetryCount != null) {
            builder.setSenderMaxRetryCount(this.senderMaxRetryCount);
        }
        builder.setSslEnabled(this.sslEnabled);
        if (this.jvmHeapBufferMode != null) {
            builder.setJvmHeapBufferMode(this.jvmHeapBufferMode);
        }
        return builder;
    }

    protected List<InetSocketAddress> configureServers() {
        ArrayList<InetSocketAddress> dest = new ArrayList<InetSocketAddress>();
        if (this.getRemoteHost() != null && this.getPort() > 0) {
            dest.add(new InetSocketAddress(this.getRemoteHost(), this.getPort()));
        }
        if (this.remoteServers != null) {
            for (RemoteServer server : this.remoteServers.getRemoteServers()) {
                dest.add(new InetSocketAddress(server.getHost(), server.getPort()));
            }
        }
        return dest;
    }

    public static class RemoteServer {
        private String host;
        private int port;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    public static class RemoteServers {
        private List<RemoteServer> remoteServers = new ArrayList<RemoteServer>();

        public List<RemoteServer> getRemoteServers() {
            return this.remoteServers;
        }

        public void addRemoteServer(RemoteServer remoteServer) {
            this.remoteServers.add(remoteServer);
        }
    }
}

