/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.more.appenders.AwsAppenderV2;
import ch.qos.logback.more.appenders.IntervalEmitter;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;

public class CloudWatchLogbackAppenderV2<E>
extends AwsAppenderV2<E> {
    private IntervalEmitter<E, InputLogEvent> emitter;
    private CloudWatchLogsClient awsLogs;
    private String logGroupName;
    private StreamName logStreamName;
    private boolean createLogDestination;
    private long emitInterval = 10000L;
    private Encoder<E> encoder = new EchoEncoder();

    public void setAwsConfig(AwsAppenderV2.AwsConfig config) {
        this.config = config;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public void setLogStreamName(String logStreamName) {
        this.logStreamName = new StaticStreamName(logStreamName);
    }

    public void setLogStreamRolling(StreamName streamName) {
        this.logStreamName = streamName;
    }

    public void setCreateLogDestination(boolean createLogDestination) {
        this.createLogDestination = createLogDestination;
    }

    public void setEmitInterval(long emitInterval) {
        this.emitInterval = emitInterval;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    @Override
    public void start() {
        if (this.logGroupName == null || this.logGroupName.length() == 0 || this.logStreamName == null) {
            throw new IllegalArgumentException("logGroupName and logStreamName must be defined.");
        }
        this.emitter = new IntervalEmitter(this.emitInterval, new CloudWatchEventMapper(), new CloudWatchIntervalAppender());
        super.start();
    }

    public void stop() {
        try {
            this.emitter.emitForShutdown(10000L, 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.stop();
        }
        finally {
            try {
                this.awsLogs.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void append(E eventObject) {
        this.emitter.append(eventObject);
    }

    private void ensureLogGroup() {
        DescribeLogGroupsRequest request;
        DescribeLogGroupsResponse result;
        if (this.awsLogs == null) {
            CloudWatchLogsClientBuilder builder = (CloudWatchLogsClientBuilder)CloudWatchLogsClient.builder().region(Region.of((String)this.config.getRegion()));
            if (this.credentials != null) {
                builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)this.credentials));
            } else if (this.credentialsProvider != null) {
                builder.credentialsProvider(this.credentialsProvider);
            }
            this.awsLogs = (CloudWatchLogsClient)builder.build();
        }
        if ((result = this.awsLogs.describeLogGroups(request = (DescribeLogGroupsRequest)DescribeLogGroupsRequest.builder().logGroupNamePrefix(this.logGroupName).limit(Integer.valueOf(1)).build())).logGroups().size() == 1 && ((LogGroup)result.logGroups().get(0)).logGroupName().equals(this.logGroupName)) {
            return;
        }
        if (!this.createLogDestination) {
            throw new IllegalStateException("The specified log group does not exist: " + this.logGroupName);
        }
        this.awsLogs.createLogGroup((CreateLogGroupRequest)CreateLogGroupRequest.builder().logGroupName(this.logGroupName).build());
    }

    private String ensureLogStream(String name) {
        DescribeLogStreamsRequest request = (DescribeLogStreamsRequest)DescribeLogStreamsRequest.builder().logGroupName(this.logGroupName).logStreamNamePrefix(name).limit(Integer.valueOf(1)).build();
        DescribeLogStreamsResponse result = this.awsLogs.describeLogStreams(request);
        if (result.logStreams().size() == 1 && ((LogStream)result.logStreams().get(0)).logStreamName().equals(name)) {
            return ((LogStream)result.logStreams().get(0)).uploadSequenceToken();
        }
        if (this.createLogDestination) {
            this.awsLogs.createLogStream((CreateLogStreamRequest)CreateLogStreamRequest.builder().logGroupName(this.logGroupName).logStreamName(name).build());
            return null;
        }
        throw new IllegalStateException("The specified log stream does not exist: " + this.logStreamName);
    }

    public static class CountBasedStreamName
    implements StreamName {
        private long count = 0L;
        private long limit = 1000L;
        private String baseName = "";
        private String currentName;

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public void setLimit(long limit) {
            this.limit = limit;
            this.count = limit + 1L;
        }

        @Override
        public String get(List<InputLogEvent> events) {
            if (this.currentName == null) {
                this.currentName = this.baseName + UUID.randomUUID();
                return this.currentName;
            }
            this.count += (long)events.size();
            if (this.count > this.limit) {
                this.currentName = this.baseName + UUID.randomUUID();
                this.count = events.size();
            }
            return this.currentName;
        }
    }

    public static class StaticStreamName
    implements StreamName {
        private String name;

        public StaticStreamName(String name) {
            this.name = name;
        }

        @Override
        public String get(List<InputLogEvent> events) {
            return this.name;
        }
    }

    public static interface StreamName {
        public String get(List<InputLogEvent> var1);
    }

    private final class CloudWatchIntervalAppender
    implements IntervalEmitter.IntervalAppender<InputLogEvent> {
        private String sequenceToken;
        private boolean initialized = false;
        private boolean switchingStream = false;
        private String currentStreamName = CloudWatchLogbackAppenderV2.access$300(CloudWatchLogbackAppenderV2.this).get(Collections.emptyList());

        private CloudWatchIntervalAppender() {
        }

        @Override
        public boolean append(List<InputLogEvent> events) {
            if (!this.initialized) {
                CloudWatchLogbackAppenderV2.this.ensureLogGroup();
                this.initialized = true;
            }
            if (this.switchingStream) {
                return false;
            }
            String streamName = CloudWatchLogbackAppenderV2.this.logStreamName.get(events);
            if (!streamName.equals(this.currentStreamName)) {
                if (this.switchingStream) {
                    return false;
                }
                this.switchingStream = true;
                this.sequenceToken = CloudWatchLogbackAppenderV2.this.ensureLogStream(streamName);
                this.currentStreamName = streamName;
                this.switchingStream = false;
            }
            try {
                long size = 0L;
                int putIndex = 0;
                int l = events.size();
                for (int i = 0; i < l; ++i) {
                    PutLogEventsRequest.Builder request;
                    InputLogEvent event = events.get(i);
                    String message = event.message();
                    if ((size += (long)(message.length() * 4)) <= 0x100000L && i + 1 != l) continue;
                    if (i + 1 == l) {
                        request = PutLogEventsRequest.builder().logGroupName(CloudWatchLogbackAppenderV2.this.logGroupName).logStreamName(streamName).logEvents(events.subList(putIndex, i + 1));
                    } else {
                        request = PutLogEventsRequest.builder().logGroupName(CloudWatchLogbackAppenderV2.this.logGroupName).logStreamName(streamName).logEvents(events.subList(putIndex, i));
                        putIndex = i--;
                    }
                    size = 0L;
                    if (this.sequenceToken != null) {
                        request.sequenceToken(this.sequenceToken);
                    }
                    PutLogEventsResponse result = CloudWatchLogbackAppenderV2.this.awsLogs.putLogEvents((PutLogEventsRequest)request.build());
                    this.sequenceToken = result.nextSequenceToken();
                }
            }
            catch (RuntimeException e) {
                this.sequenceToken = null;
                CloudWatchLogbackAppenderV2.this.addWarn("Skip sending logs to CloudWatch", e);
            }
            return true;
        }
    }

    private final class CloudWatchEventMapper
    implements IntervalEmitter.EventMapper<E, InputLogEvent> {
        private CloudWatchEventMapper() {
        }

        @Override
        public InputLogEvent map(E event) {
            InputLogEvent.Builder logEvent = InputLogEvent.builder();
            logEvent.timestamp(Long.valueOf(System.currentTimeMillis()));
            byte[] messageBytes = CloudWatchLogbackAppenderV2.this.encoder.encode(event);
            String message = new String(messageBytes);
            if (messageBytes.length >= 1048550) {
                logEvent.message(message.substring(0, 512) + "...(Omitted)");
                CloudWatchLogbackAppenderV2.this.addWarn("Could not send all message to CloudWatch because of the message size limit(<= 1,048,576 bytes). original message = " + message);
            } else {
                logEvent.message(message);
            }
            return (InputLogEvent)logEvent.build();
        }
    }
}

