/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.ThrowingFunction;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowingConsumer<T, E extends Exception> {
    public void accept(T var1) throws E;

    public static <T> Consumer<T> unchecked(ThrowingConsumer<T, ?> consumer) {
        return Objects.requireNonNull(consumer).uncheck();
    }

    public static <T> Consumer<T> sneaky(ThrowingConsumer<T, ?> consumer) {
        Objects.requireNonNull(consumer);
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }

    default public ThrowingConsumer<T, E> andThenConsume(ThrowingConsumer<? super T, ? extends E> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public ThrowingFunction<T, Void, E> asFunction() {
        return arg -> {
            this.accept(arg);
            return null;
        };
    }

    default public Consumer<T> uncheck() {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }
}

