/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.aead.AesCtrHmacAeadKey;
import com.google.crypto.tink.aead.AesCtrHmacAeadParameters;
import com.google.crypto.tink.aead.AesGcmKey;
import com.google.crypto.tink.aead.AesGcmParameters;
import com.google.crypto.tink.daead.AesSivKey;
import com.google.crypto.tink.daead.AesSivParameters;
import com.google.crypto.tink.hybrid.EciesParameters;
import com.google.crypto.tink.hybrid.EciesPublicKey;
import com.google.crypto.tink.hybrid.subtle.AeadOrDaead;
import com.google.crypto.tink.internal.EnumTypeProtoConverter;
import com.google.crypto.tink.subtle.AesGcmJce;
import com.google.crypto.tink.subtle.AesSiv;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EciesAeadHkdfDemHelper;
import com.google.crypto.tink.subtle.EciesHkdfSenderKem;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EncryptThenAuthenticate;
import com.google.crypto.tink.util.SecretBytes;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;

public final class EciesAeadHkdfHybridEncrypt
implements HybridEncrypt {
    private static final byte[] EMPTY_AAD = new byte[0];
    private final EciesHkdfSenderKem senderKem;
    private final String hkdfHmacAlgo;
    private final byte[] hkdfSalt;
    private final EllipticCurves.PointFormatType ecPointFormat;
    private final EciesAeadHkdfDemHelper demHelper;
    private final byte[] outputPrefix;
    static final EnumTypeProtoConverter<EllipticCurves.CurveType, EciesParameters.CurveType> CURVE_TYPE_CONVERTER = EnumTypeProtoConverter.builder().add(EllipticCurves.CurveType.NIST_P256, EciesParameters.CurveType.NIST_P256).add(EllipticCurves.CurveType.NIST_P384, EciesParameters.CurveType.NIST_P384).add(EllipticCurves.CurveType.NIST_P521, EciesParameters.CurveType.NIST_P521).build();
    static final EnumTypeProtoConverter<EllipticCurves.PointFormatType, EciesParameters.PointFormat> POINT_FORMAT_TYPE_CONVERTER = EnumTypeProtoConverter.builder().add(EllipticCurves.PointFormatType.UNCOMPRESSED, EciesParameters.PointFormat.UNCOMPRESSED).add(EllipticCurves.PointFormatType.COMPRESSED, EciesParameters.PointFormat.COMPRESSED).add(EllipticCurves.PointFormatType.DO_NOT_USE_CRUNCHY_UNCOMPRESSED, EciesParameters.PointFormat.LEGACY_UNCOMPRESSED).build();

    private static EciesAeadHkdfDemHelper createHelperAesGcm(final AesGcmParameters parameters) {
        return new EciesAeadHkdfDemHelper(){

            @Override
            public int getSymmetricKeySizeInBytes() {
                return parameters.getKeySizeBytes();
            }

            @Override
            @AccessesPartialKey
            public AeadOrDaead getAeadOrDaead(byte[] symmetricKeyValue) throws GeneralSecurityException {
                return new AeadOrDaead(AesGcmJce.create(AesGcmKey.builder().setParameters(parameters).setKeyBytes(SecretBytes.copyFrom(symmetricKeyValue, InsecureSecretKeyAccess.get())).build()));
            }
        };
    }

    private static EciesAeadHkdfDemHelper createHelperAesCtrHmac(final AesCtrHmacAeadParameters parameters) {
        return new EciesAeadHkdfDemHelper(){

            @Override
            public int getSymmetricKeySizeInBytes() {
                return parameters.getAesKeySizeBytes() + parameters.getHmacKeySizeBytes();
            }

            @Override
            @AccessesPartialKey
            public AeadOrDaead getAeadOrDaead(byte[] symmetricKeyValue) throws GeneralSecurityException {
                byte[] aesCtrKeyValue = Arrays.copyOfRange(symmetricKeyValue, 0, parameters.getAesKeySizeBytes());
                byte[] hmacKeyValue = Arrays.copyOfRange(symmetricKeyValue, parameters.getAesKeySizeBytes(), parameters.getAesKeySizeBytes() + parameters.getHmacKeySizeBytes());
                return new AeadOrDaead(EncryptThenAuthenticate.create(AesCtrHmacAeadKey.builder().setParameters(parameters).setAesKeyBytes(SecretBytes.copyFrom(aesCtrKeyValue, InsecureSecretKeyAccess.get())).setHmacKeyBytes(SecretBytes.copyFrom(hmacKeyValue, InsecureSecretKeyAccess.get())).build()));
            }
        };
    }

    private static EciesAeadHkdfDemHelper createHelperAesSiv(final AesSivParameters parameters) {
        return new EciesAeadHkdfDemHelper(){

            @Override
            public int getSymmetricKeySizeInBytes() {
                return parameters.getKeySizeBytes();
            }

            @Override
            @AccessesPartialKey
            public AeadOrDaead getAeadOrDaead(byte[] symmetricKeyValue) throws GeneralSecurityException {
                return new AeadOrDaead(AesSiv.create(AesSivKey.builder().setParameters(parameters).setKeyBytes(SecretBytes.copyFrom(symmetricKeyValue, InsecureSecretKeyAccess.get())).build()));
            }
        };
    }

    static EciesAeadHkdfDemHelper createHelper(Parameters parameters) throws GeneralSecurityException {
        if (parameters instanceof AesGcmParameters) {
            return EciesAeadHkdfHybridEncrypt.createHelperAesGcm((AesGcmParameters)parameters);
        }
        if (parameters instanceof AesCtrHmacAeadParameters) {
            return EciesAeadHkdfHybridEncrypt.createHelperAesCtrHmac((AesCtrHmacAeadParameters)parameters);
        }
        if (parameters instanceof AesSivParameters) {
            return EciesAeadHkdfHybridEncrypt.createHelperAesSiv((AesSivParameters)parameters);
        }
        throw new GeneralSecurityException("Unsupported parameters for Ecies: " + parameters);
    }

    static final String toHmacAlgo(EciesParameters.HashType hash) throws GeneralSecurityException {
        if (hash.equals(EciesParameters.HashType.SHA1)) {
            return "HmacSha1";
        }
        if (hash.equals(EciesParameters.HashType.SHA224)) {
            return "HmacSha224";
        }
        if (hash.equals(EciesParameters.HashType.SHA256)) {
            return "HmacSha256";
        }
        if (hash.equals(EciesParameters.HashType.SHA384)) {
            return "HmacSha384";
        }
        if (hash.equals(EciesParameters.HashType.SHA512)) {
            return "HmacSha512";
        }
        throw new GeneralSecurityException("hash unsupported for EciesAeadHkdf: " + hash);
    }

    private EciesAeadHkdfHybridEncrypt(ECPublicKey recipientPublicKey, byte[] hkdfSalt, String hkdfHmacAlgo, EllipticCurves.PointFormatType ecPointFormat, EciesAeadHkdfDemHelper demHelper, byte[] outputPrefix) throws GeneralSecurityException {
        EllipticCurves.checkPublicKey(recipientPublicKey);
        this.senderKem = new EciesHkdfSenderKem(recipientPublicKey);
        this.hkdfSalt = hkdfSalt;
        this.hkdfHmacAlgo = hkdfHmacAlgo;
        this.ecPointFormat = ecPointFormat;
        this.demHelper = demHelper;
        this.outputPrefix = outputPrefix;
    }

    @AccessesPartialKey
    public static HybridEncrypt create(EciesPublicKey key) throws GeneralSecurityException {
        EllipticCurves.CurveType curveType = CURVE_TYPE_CONVERTER.toProtoEnum(key.getParameters().getCurveType());
        ECPublicKey recipientPublicKey = EllipticCurves.getEcPublicKey(curveType, key.getNistCurvePoint().getAffineX().toByteArray(), key.getNistCurvePoint().getAffineY().toByteArray());
        byte[] hkdfSalt = new byte[]{};
        if (key.getParameters().getSalt() != null) {
            hkdfSalt = key.getParameters().getSalt().toByteArray();
        }
        return new EciesAeadHkdfHybridEncrypt(recipientPublicKey, hkdfSalt, EciesAeadHkdfHybridEncrypt.toHmacAlgo(key.getParameters().getHashType()), POINT_FORMAT_TYPE_CONVERTER.toProtoEnum(key.getParameters().getNistCurvePointFormat()), EciesAeadHkdfHybridEncrypt.createHelper(key.getParameters().getDemParameters()), key.getOutputPrefix().toByteArray());
    }

    public byte[] noPrefixEncrypt(byte[] plaintext, byte[] contextInfo) throws GeneralSecurityException {
        EciesHkdfSenderKem.KemKey kemKey = this.senderKem.generateKey(this.hkdfHmacAlgo, this.hkdfSalt, contextInfo, this.demHelper.getSymmetricKeySizeInBytes(), this.ecPointFormat);
        AeadOrDaead aead = this.demHelper.getAeadOrDaead(kemKey.getSymmetricKey());
        byte[] ciphertext = aead.encrypt(plaintext, EMPTY_AAD);
        byte[] header = kemKey.getKemBytes();
        return ByteBuffer.allocate(header.length + ciphertext.length).put(header).put(ciphertext).array();
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] contextInfo) throws GeneralSecurityException {
        byte[] ciphertext = this.noPrefixEncrypt(plaintext, contextInfo);
        if (this.outputPrefix.length == 0) {
            return ciphertext;
        }
        return Bytes.concat(this.outputPrefix, ciphertext);
    }
}

