/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.hybrid.EciesPrivateKey;
import com.google.crypto.tink.hybrid.subtle.AeadOrDaead;
import com.google.crypto.tink.internal.BigIntegerEncoding;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.subtle.EciesAeadHkdfDemHelper;
import com.google.crypto.tink.subtle.EciesAeadHkdfHybridEncrypt;
import com.google.crypto.tink.subtle.EciesHkdfRecipientKem;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.EllipticCurve;
import java.util.Arrays;

public final class EciesAeadHkdfHybridDecrypt
implements HybridDecrypt {
    private static final byte[] EMPTY_AAD = new byte[0];
    private final ECPrivateKey recipientPrivateKey;
    private final EciesHkdfRecipientKem recipientKem;
    private final String hkdfHmacAlgo;
    private final byte[] hkdfSalt;
    private final EllipticCurves.PointFormatType ecPointFormat;
    private final EciesAeadHkdfDemHelper demHelper;
    private final byte[] outputPrefix;

    private EciesAeadHkdfHybridDecrypt(ECPrivateKey recipientPrivateKey, byte[] hkdfSalt, String hkdfHmacAlgo, EllipticCurves.PointFormatType ecPointFormat, EciesAeadHkdfDemHelper demHelper, byte[] outputPrefix) throws GeneralSecurityException {
        this.recipientPrivateKey = recipientPrivateKey;
        this.recipientKem = new EciesHkdfRecipientKem(recipientPrivateKey);
        this.hkdfSalt = hkdfSalt;
        this.hkdfHmacAlgo = hkdfHmacAlgo;
        this.ecPointFormat = ecPointFormat;
        this.demHelper = demHelper;
        this.outputPrefix = outputPrefix;
    }

    @AccessesPartialKey
    public static HybridDecrypt create(EciesPrivateKey key) throws GeneralSecurityException {
        EllipticCurves.CurveType curveType = EciesAeadHkdfHybridEncrypt.CURVE_TYPE_CONVERTER.toProtoEnum(key.getParameters().getCurveType());
        ECPrivateKey recipientPrivateKey = EllipticCurves.getEcPrivateKey(curveType, BigIntegerEncoding.toBigEndianBytes(key.getNistPrivateKeyValue().getBigInteger(InsecureSecretKeyAccess.get())));
        byte[] hkdfSalt = new byte[]{};
        if (key.getParameters().getSalt() != null) {
            hkdfSalt = key.getParameters().getSalt().toByteArray();
        }
        return new EciesAeadHkdfHybridDecrypt(recipientPrivateKey, hkdfSalt, EciesAeadHkdfHybridEncrypt.toHmacAlgo(key.getParameters().getHashType()), EciesAeadHkdfHybridEncrypt.POINT_FORMAT_TYPE_CONVERTER.toProtoEnum(key.getParameters().getNistCurvePointFormat()), EciesAeadHkdfHybridEncrypt.createHelper(key.getParameters().getDemParameters()), key.getOutputPrefix().toByteArray());
    }

    private byte[] decryptNoPrefix(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
        EllipticCurve curve = this.recipientPrivateKey.getParams().getCurve();
        int headerSize = EllipticCurves.encodingSizeInBytes(curve, this.ecPointFormat);
        if (ciphertext.length < headerSize) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        byte[] kemBytes = Arrays.copyOfRange(ciphertext, 0, headerSize);
        byte[] symmetricKey = this.recipientKem.generateKey(kemBytes, this.hkdfHmacAlgo, this.hkdfSalt, contextInfo, this.demHelper.getSymmetricKeySizeInBytes(), this.ecPointFormat);
        AeadOrDaead aead = this.demHelper.getAeadOrDaead(symmetricKey);
        return aead.decrypt(Arrays.copyOfRange(ciphertext, headerSize, ciphertext.length), EMPTY_AAD);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
        if (this.outputPrefix.length == 0) {
            return this.decryptNoPrefix(ciphertext, contextInfo);
        }
        if (!Util.isPrefix(this.outputPrefix, ciphertext)) {
            throw new GeneralSecurityException("Invalid ciphertext (output prefix mismatch)");
        }
        byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, this.outputPrefix.length, ciphertext.length);
        return this.decryptNoPrefix(ciphertextNoPrefix, contextInfo);
    }
}

