/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature.internal;

import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.ProtoKeySerialization;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Bytes;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;

@Immutable
public final class LegacyFullVerify
implements PublicKeyVerify {
    private final PublicKeyVerify rawVerifier;
    private final byte[] outputPrefix;
    private final byte[] messageSuffix;

    public static PublicKeyVerify create(LegacyProtoKey key) throws GeneralSecurityException {
        ProtoKeySerialization protoKeySerialization = key.getSerialization(InsecureSecretKeyAccess.get());
        KeyData keyData = (KeyData)KeyData.newBuilder().setTypeUrl(protoKeySerialization.getTypeUrl()).setValue(protoKeySerialization.getValue()).setKeyMaterialType(protoKeySerialization.getKeyMaterialType()).build();
        PublicKeyVerify rawVerifier = Registry.getPrimitive(keyData, PublicKeyVerify.class);
        return new LegacyFullVerify(rawVerifier, LegacyFullVerify.getOutputPrefix(protoKeySerialization), LegacyFullVerify.getMessageSuffix(protoKeySerialization));
    }

    static byte[] getOutputPrefix(ProtoKeySerialization key) throws GeneralSecurityException {
        switch (key.getOutputPrefixType()) {
            case LEGACY: 
            case CRUNCHY: {
                return ByteBuffer.allocate(5).put((byte)0).putInt(key.getIdRequirementOrNull()).array();
            }
            case TINK: {
                return ByteBuffer.allocate(5).put((byte)1).putInt(key.getIdRequirementOrNull()).array();
            }
            case RAW: {
                return new byte[0];
            }
        }
        throw new GeneralSecurityException("unknown output prefix type");
    }

    static byte[] getMessageSuffix(ProtoKeySerialization key) {
        if (key.getOutputPrefixType().equals(OutputPrefixType.LEGACY)) {
            return new byte[]{0};
        }
        return new byte[0];
    }

    private LegacyFullVerify(PublicKeyVerify rawVerifier, byte[] outputPrefix, byte[] messageSuffix) {
        this.rawVerifier = rawVerifier;
        this.outputPrefix = outputPrefix;
        this.messageSuffix = messageSuffix;
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        if (this.outputPrefix.length == 0 && this.messageSuffix.length == 0) {
            this.rawVerifier.verify(signature, data);
            return;
        }
        if (!Util.isPrefix(this.outputPrefix, signature)) {
            throw new GeneralSecurityException("Invalid signature (output prefix mismatch)");
        }
        byte[] dataCopy = data;
        if (this.messageSuffix.length != 0) {
            dataCopy = Bytes.concat(data, this.messageSuffix);
        }
        byte[] signatureNoPrefix = Arrays.copyOfRange(signature, this.outputPrefix.length, signature.length);
        this.rawVerifier.verify(signatureNoPrefix, dataCopy);
    }
}

