/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.jwt.JwtInvalidException;
import com.google.crypto.tink.jwt.JwtMac;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.List;

class JwtMacWrapper
implements PrimitiveWrapper<JwtMac, JwtMac> {
    private static final JwtMacWrapper WRAPPER = new JwtMacWrapper();

    private static void validate(PrimitiveSet<JwtMac> primitiveSet) throws GeneralSecurityException {
        if (primitiveSet.getPrimary() == null) {
            throw new GeneralSecurityException("Primitive set has no primary.");
        }
    }

    JwtMacWrapper() {
    }

    @Override
    public JwtMac wrap(PrimitiveSet<JwtMac> primitives) throws GeneralSecurityException {
        JwtMacWrapper.validate(primitives);
        return new WrappedJwtMac(primitives);
    }

    @Override
    public Class<JwtMac> getPrimitiveClass() {
        return JwtMac.class;
    }

    @Override
    public Class<JwtMac> getInputPrimitiveClass() {
        return JwtMac.class;
    }

    public static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
    }

    @Immutable
    private static class WrappedJwtMac
    implements JwtMac {
        private final PrimitiveSet<JwtMac> primitives;

        private WrappedJwtMac(PrimitiveSet<JwtMac> primitives) {
            this.primitives = primitives;
        }

        @Override
        public String computeMacAndEncode(RawJwt token) throws GeneralSecurityException {
            return this.primitives.getPrimary().getFullPrimitive().computeMacAndEncode(token);
        }

        @Override
        public VerifiedJwt verifyMacAndDecode(String compact, JwtValidator validator) throws GeneralSecurityException {
            GeneralSecurityException interestingException = null;
            for (List<PrimitiveSet.Entry<JwtMac>> entries : this.primitives.getAll()) {
                for (PrimitiveSet.Entry<JwtMac> entry : entries) {
                    try {
                        return entry.getFullPrimitive().verifyMacAndDecode(compact, validator);
                    }
                    catch (GeneralSecurityException e) {
                        if (!(e instanceof JwtInvalidException)) continue;
                        interestingException = e;
                    }
                }
            }
            if (interestingException != null) {
                throw interestingException;
            }
            throw new GeneralSecurityException("invalid MAC");
        }
    }
}

