/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.KeyStatus;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import com.google.crypto.tink.proto.KeyStatusType;
import java.security.GeneralSecurityException;
import java.util.List;

public final class MonitoringUtil {
    public static final MonitoringClient.Logger DO_NOTHING_LOGGER = new DoNothingLogger();
    private static final String TYPE_URL_PREFIX = "type.googleapis.com/google.crypto.";

    private static KeyStatus parseStatus(KeyStatusType in) {
        switch (in) {
            case ENABLED: {
                return KeyStatus.ENABLED;
            }
            case DISABLED: {
                return KeyStatus.DISABLED;
            }
            case DESTROYED: {
                return KeyStatus.DESTROYED;
            }
        }
        throw new IllegalStateException("Unknown key status");
    }

    private static String parseKeyTypeUrl(String keyTypeUrl) {
        if (!keyTypeUrl.startsWith(TYPE_URL_PREFIX)) {
            return keyTypeUrl;
        }
        return keyTypeUrl.substring(TYPE_URL_PREFIX.length());
    }

    public static <P> MonitoringKeysetInfo getMonitoringKeysetInfo(PrimitiveSet<P> primitiveSet) {
        MonitoringKeysetInfo.Builder builder = MonitoringKeysetInfo.newBuilder();
        builder.setAnnotations(primitiveSet.getAnnotations());
        for (List<PrimitiveSet.Entry<P>> entries : primitiveSet.getAll()) {
            for (PrimitiveSet.Entry<P> entry : entries) {
                builder.addEntry(MonitoringUtil.parseStatus(entry.getStatus()), entry.getKeyId(), MonitoringUtil.parseKeyTypeUrl(entry.getKeyTypeUrl()), entry.getOutputPrefixType().name());
            }
        }
        PrimitiveSet.Entry<P> primary = primitiveSet.getPrimary();
        if (primary != null) {
            builder.setPrimaryKeyId(primitiveSet.getPrimary().getKeyId());
        }
        try {
            return builder.build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private MonitoringUtil() {
    }

    private static class DoNothingLogger
    implements MonitoringClient.Logger {
        private DoNothingLogger() {
        }

        @Override
        public void log(int keyId, long numBytesAsInput) {
        }

        @Override
        public void logFailure() {
        }
    }
}

