/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.annotation.Host;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.implementation.http.rest.MissingRequiredAnnotationException;
import com.azure.core.implementation.http.rest.SwaggerMethodParser;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.serializer.SerializerAdapter;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SwaggerInterfaceParser {
    private final String host;
    private final String serviceName;
    private final SerializerAdapter serializer;
    private static final Map<Method, SwaggerMethodParser> METHOD_PARSERS = new ConcurrentHashMap<Method, SwaggerMethodParser>();

    public SwaggerInterfaceParser(Class<?> swaggerInterface, SerializerAdapter serializer) {
        this(swaggerInterface, serializer, null);
    }

    public SwaggerInterfaceParser(Class<?> swaggerInterface, SerializerAdapter serializer, String host) {
        this.serializer = serializer;
        if (!CoreUtils.isNullOrEmpty(host)) {
            this.host = host;
        } else {
            Host hostAnnotation = swaggerInterface.getAnnotation(Host.class);
            if (hostAnnotation != null && !hostAnnotation.value().isEmpty()) {
                this.host = hostAnnotation.value();
            } else {
                throw new MissingRequiredAnnotationException(Host.class, swaggerInterface);
            }
        }
        ServiceInterface serviceAnnotation = swaggerInterface.getAnnotation(ServiceInterface.class);
        if (serviceAnnotation == null || serviceAnnotation.name().isEmpty()) {
            throw new MissingRequiredAnnotationException(ServiceInterface.class, swaggerInterface);
        }
        this.serviceName = serviceAnnotation.name();
    }

    public SwaggerMethodParser getMethodParser(Method swaggerMethod) {
        return METHOD_PARSERS.computeIfAbsent(swaggerMethod, sm -> new SwaggerMethodParser((Method)sm, this.getHost(), this.serializer));
    }

    public String getHost() {
        return this.host;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

