/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.sd;

import com.authlete.sd.Disclosure;
import com.authlete.sd.SDUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DigestListBuilder {
    private final String hashAlgorithm;
    private final Map<String, String> claimNameToDigestMap;
    private final Set<String> decoyDigestSet;

    public DigestListBuilder() {
        this("sha-256");
    }

    public DigestListBuilder(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm != null ? hashAlgorithm : "sha-256";
        this.claimNameToDigestMap = new HashMap<String, String>();
        this.decoyDigestSet = new HashSet<String>();
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String addDisclosureDigest(Disclosure disclosure) {
        String claimName = disclosure.getClaimName();
        String digest = disclosure.digest(this.getHashAlgorithm());
        this.claimNameToDigestMap.put(claimName, digest);
        return digest;
    }

    public String addDecoyDigest() {
        String digest = SDUtility.generateRandomDigest(this.getHashAlgorithm());
        this.decoyDigestSet.add(digest);
        return digest;
    }

    public List<String> addDecoyDigests(int count) {
        ArrayList<String> digestList = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String digest = this.addDecoyDigest();
            digestList.add(digest);
        }
        return digestList;
    }

    public List<String> build() {
        Stream<String> digests = Stream.concat(this.claimNameToDigestMap.values().stream(), this.decoyDigestSet.stream());
        return digests.sorted().collect(Collectors.toList());
    }

    String removeDigestByClaimName(String claimName) {
        return this.claimNameToDigestMap.remove(claimName);
    }
}

