/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeEvaluationClass;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeClassificationSummaryPrecision
implements JsonpSerializable {
    private final List<DataframeEvaluationClass> classes;
    private final double avgPrecision;
    public static final JsonpDeserializer<DataframeClassificationSummaryPrecision> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeClassificationSummaryPrecision::setupDataframeClassificationSummaryPrecisionDeserializer);

    private DataframeClassificationSummaryPrecision(Builder builder) {
        this.classes = ApiTypeHelper.unmodifiableRequired(builder.classes, (Object)this, "classes");
        this.avgPrecision = ApiTypeHelper.requireNonNull(builder.avgPrecision, (Object)this, "avgPrecision", 0.0);
    }

    public static DataframeClassificationSummaryPrecision of(Function<Builder, ObjectBuilder<DataframeClassificationSummaryPrecision>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<DataframeEvaluationClass> classes() {
        return this.classes;
    }

    public final double avgPrecision() {
        return this.avgPrecision;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.classes)) {
            generator.writeKey("classes");
            generator.writeStartArray();
            for (DataframeEvaluationClass item0 : this.classes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("avg_precision");
        generator.write(this.avgPrecision);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataframeClassificationSummaryPrecisionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classes, JsonpDeserializer.arrayDeserializer(DataframeEvaluationClass._DESERIALIZER), "classes");
        op.add(Builder::avgPrecision, JsonpDeserializer.doubleDeserializer(), "avg_precision");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeClassificationSummaryPrecision> {
        private List<DataframeEvaluationClass> classes;
        private Double avgPrecision;

        public final Builder classes(List<DataframeEvaluationClass> list) {
            this.classes = Builder._listAddAll(this.classes, list);
            return this;
        }

        public final Builder classes(DataframeEvaluationClass value, DataframeEvaluationClass ... values) {
            this.classes = Builder._listAdd(this.classes, value, values);
            return this;
        }

        public final Builder classes(Function<DataframeEvaluationClass.Builder, ObjectBuilder<DataframeEvaluationClass>> fn) {
            return this.classes(fn.apply(new DataframeEvaluationClass.Builder()).build(), new DataframeEvaluationClass[0]);
        }

        public final Builder avgPrecision(double value) {
            this.avgPrecision = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeClassificationSummaryPrecision build() {
            this._checkSingleUse();
            return new DataframeClassificationSummaryPrecision(this);
        }
    }
}

