/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch.security.authenticate;

import co.elastic.clients.elasticsearch.security.ApiKeyManagedBy;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: security.authenticate.AuthenticateApiKey

/**
 *
 * @see <a href=
 *      "../../doc-files/api-spec.html#security.authenticate.AuthenticateApiKey">API
 *      specification</a>
 */
@JsonpDeserializable
public class AuthenticateApiKey implements JsonpSerializable {
	private final String id;

	@Nullable
	private final String name;

	private final ApiKeyManagedBy managedBy;

	@Nullable
	private final Boolean internal;

	// ---------------------------------------------------------------------------------------------

	private AuthenticateApiKey(Builder builder) {

		this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
		this.name = builder.name;
		this.managedBy = ApiTypeHelper.requireNonNull(builder.managedBy, this, "managedBy");
		this.internal = builder.internal;

	}

	public static AuthenticateApiKey of(Function<Builder, ObjectBuilder<AuthenticateApiKey>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * Required - API name: {@code id}
	 */
	public final String id() {
		return this.id;
	}

	/**
	 * API name: {@code name}
	 */
	@Nullable
	public final String name() {
		return this.name;
	}

	/**
	 * Required - API name: {@code managed_by}
	 */
	public final ApiKeyManagedBy managedBy() {
		return this.managedBy;
	}

	/**
	 * API name: {@code internal}
	 */
	@Nullable
	public final Boolean internal() {
		return this.internal;
	}

	/**
	 * Serialize this object to JSON.
	 */
	public void serialize(JsonGenerator generator, JsonpMapper mapper) {
		generator.writeStartObject();
		serializeInternal(generator, mapper);
		generator.writeEnd();
	}

	protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

		generator.writeKey("id");
		generator.write(this.id);

		if (this.name != null) {
			generator.writeKey("name");
			generator.write(this.name);

		}
		generator.writeKey("managed_by");
		this.managedBy.serialize(generator, mapper);
		if (this.internal != null) {
			generator.writeKey("internal");
			generator.write(this.internal);

		}

	}

	@Override
	public String toString() {
		return JsonpUtils.toString(this);
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link AuthenticateApiKey}.
	 */

	public static class Builder extends WithJsonObjectBuilderBase<Builder>
			implements
				ObjectBuilder<AuthenticateApiKey> {
		private String id;

		@Nullable
		private String name;

		private ApiKeyManagedBy managedBy;

		@Nullable
		private Boolean internal;

		/**
		 * Required - API name: {@code id}
		 */
		public final Builder id(String value) {
			this.id = value;
			return this;
		}

		/**
		 * API name: {@code name}
		 */
		public final Builder name(@Nullable String value) {
			this.name = value;
			return this;
		}

		/**
		 * Required - API name: {@code managed_by}
		 */
		public final Builder managedBy(ApiKeyManagedBy value) {
			this.managedBy = value;
			return this;
		}

		/**
		 * API name: {@code internal}
		 */
		public final Builder internal(@Nullable Boolean value) {
			this.internal = value;
			return this;
		}

		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link AuthenticateApiKey}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public AuthenticateApiKey build() {
			_checkSingleUse();

			return new AuthenticateApiKey(this);
		}
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Json deserializer for {@link AuthenticateApiKey}
	 */
	public static final JsonpDeserializer<AuthenticateApiKey> _DESERIALIZER = ObjectBuilderDeserializer
			.lazy(Builder::new, AuthenticateApiKey::setupAuthenticateApiKeyDeserializer);

	protected static void setupAuthenticateApiKeyDeserializer(ObjectDeserializer<AuthenticateApiKey.Builder> op) {

		op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
		op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
		op.add(Builder::managedBy, ApiKeyManagedBy._DESERIALIZER, "managed_by");
		op.add(Builder::internal, JsonpDeserializer.booleanDeserializer(), "internal");

	}

}
