/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Variable;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.FixFieldDataType;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.DeepCopy;

public class Varies
implements Variable {
    public static final String DEFAULT_OBX2_TYPE_PROP = "ca.uhn.hl7v2.model.varies.default_obx2_type";
    public static final String INVALID_OBX2_TYPE_PROP = "ca.uhn.hl7v2.model.varies.invalid_obx2_type";
    public static final String ESCAPE_SUBCOMPONENT_DELIM_IN_PRIMITIVE = "ca.uhn.hl7v2.model.varies.escape_subcomponent_delim_in_primitive";
    private Type data;
    private final Message message;

    public Varies(Message message) {
        this.data = new GenericPrimitive(message);
        this.message = message;
    }

    @Override
    public Type getData() {
        return this.data;
    }

    @Override
    public String getName() {
        String name = "*";
        if (this.data != null) {
            name = this.data.getName();
        }
        return name;
    }

    @Override
    public void setData(Type data) throws DataTypeException {
        if (!(this.data == null || this.data instanceof Primitive && ((Primitive)this.data).getValue() == null)) {
            DeepCopy.copy(this.data, data);
        }
        this.data = data;
    }

    @Override
    public ExtraComponents getExtraComponents() {
        return this.data.getExtraComponents();
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    public static void fixOBX5(Segment segment, ModelClassFactory factory) throws HL7Exception {
        FixFieldDataType.fixOBX5(segment, factory, segment.getMessage().getParser().getParserConfiguration());
    }

    public static void fixOBX5(Segment segment, ModelClassFactory factory, ParserConfiguration parserConfiguration) throws HL7Exception {
        FixFieldDataType.fixOBX5(segment, factory, parserConfiguration);
    }

    @Override
    public void parse(String string) throws HL7Exception {
        if (this.data != null) {
            this.data.clear();
        }
        this.getMessage().getParser().parse(this, string, EncodingCharacters.getInstance(this.getMessage()));
    }

    @Override
    public String encode() throws HL7Exception {
        return this.getMessage().getParser().doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean isEmpty() throws HL7Exception {
        return this.data.isEmpty();
    }

    public String toString() {
        return AbstractType.toString(this);
    }

    @Override
    public boolean accept(MessageVisitor visitor, Location currentLocation) throws HL7Exception {
        return this.data.accept(visitor, currentLocation);
    }

    @Override
    public Location provideLocation(Location location, int index, int repetition) {
        return this.data.provideLocation(location, index, repetition);
    }
}

