/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.store;

import ca.uhn.hl7v2.conf.store.ProfileStore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProfileStore
implements ProfileStore {
    private final File root;
    private static final Logger log = LoggerFactory.getLogger(FileProfileStore.class);

    public FileProfileStore(String theFile) {
        this.root = new File(theFile);
        if (this.root.exists()) {
            if (!this.root.isDirectory()) {
                log.warn("Profile store is not a directory (won't be able to retrieve any profiles): {}", (Object)theFile);
            }
        } else {
            log.debug("Profile store directory doesn't exist: {}", (Object)theFile);
        }
    }

    @Override
    public String getProfile(String theID) throws IOException {
        String profile = null;
        String fileName = this.getFileName(theID);
        File source = new File(fileName);
        if (!source.exists()) {
            log.debug("File for profile {} doesn't exist: {}", (Object)theID, (Object)fileName);
        } else if (source.isFile()) {
            BufferedReader in = new BufferedReader(new FileReader(source));
            char[] buf = new char[(int)source.length()];
            int check = in.read(buf, 0, buf.length);
            in.close();
            if (check != buf.length) {
                throw new IOException("Only read " + check + " of " + buf.length + " bytes of file " + source.getAbsolutePath());
            }
            profile = new String(buf);
            log.debug("Got profile {}: \r\n {}", (Object)theID, (Object)profile);
        }
        return profile;
    }

    @Override
    public void persistProfile(String ID2, String profile) throws IOException {
        if (!this.root.exists()) {
            throw new IOException("Can't persist profile. Directory doesn't exist: " + this.root.getAbsolutePath());
        }
        if (!this.root.isDirectory()) {
            throw new IOException("Can't persist profile. Not a directory: " + this.root.getAbsolutePath());
        }
        File dest = new File(this.getFileName(ID2));
        BufferedWriter out = new BufferedWriter(new FileWriter(dest));
        out.write(profile);
        out.flush();
        out.close();
    }

    private String getFileName(String ID2) {
        return this.root.getAbsolutePath() + "/" + ID2 + ".xml";
    }
}

