/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.scoring;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r5.model.Extension;

public class ScoredElement {
    private final String fhirType;
    private String name;
    private int index;
    private double score;
    private double possibleScore;
    private List<String> reasons;
    private List<Extension> rules;
    private List<ScoredElement> children;

    public ScoredElement(String name, int index, String fhirType, double score, double possibleScore, List<String> reasons, List<Extension> rules) {
        this.name = name;
        this.index = index;
        this.fhirType = fhirType;
        this.score = score;
        this.possibleScore = possibleScore;
        this.reasons = reasons;
        this.rules = rules;
    }

    public void addChild(ScoredElement child) {
        if (this.children == null) {
            this.children = new ArrayList<ScoredElement>();
        }
        this.children.add(child);
    }

    public List<ScoredElement> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ScoredElement>();
        }
        return this.children;
    }

    @Generated
    public String getFhirType() {
        return this.fhirType;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public double getScore() {
        return this.score;
    }

    @Generated
    public double getPossibleScore() {
        return this.possibleScore;
    }

    @Generated
    public List<String> getReasons() {
        return this.reasons;
    }

    @Generated
    public List<Extension> getRules() {
        return this.rules;
    }
}

