/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;

public class JavaExtensionsConstantsGenerator
extends JavaBaseGenerator {
    private StringBuilder src;
    private CommaSeparatedStringBuilder mod;

    public JavaExtensionsConstantsGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
    }

    public void start() throws Exception {
        this.src = new StringBuilder();
        this.mod = new CommaSeparatedStringBuilder();
    }

    public void generate(StructureDefinition sd, String name, String constName) throws Exception {
        this.src.append("  public static final String EXT_" + constName + " = \"" + sd.getUrl() + "\"; // " + sd.getTitle() + "\r\n");
    }

    public void finish() throws Exception {
        String template = this.config.getAdornments().get("Extensions.Constants");
        template = template.replace("{{pid}}", this.packageName);
        template = template.replace("{{license}}", this.config.getLicense());
        template = template.replace("{{startMark}}", this.startVMarkValue());
        template = template.replace("{{consts}}", this.src.toString());
        template = template.replace("{{mod}}", this.genMod());
        this.write(template);
        this.flush();
        this.close();
    }

    private CharSequence genMod() {
        if (this.mod.length() == 0) {
            return "  public static boolean isModifier(String url) {\r\n    return false;\r\n  }\r\n\r\n";
        }
        return "  public static boolean isModifier(String url) {\r\n    return Utilities.existsInList(url, " + this.mod.toString() + ");\r\n  }\r\n\r\n";
    }

    public void seeModifier(StructureDefinition sd) {
        this.mod.append("\"" + sd.getUrl() + "\"");
    }
}

