/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.ElementVisitor;
import org.hl7.fhir.utilities.Utilities;

public class TxTesterScrubbers {
    public static void scrubDR(DomainResource dr, boolean tight) {
        dr.setText(null);
        dr.setMeta(null);
        new ElementVisitor((ElementVisitor.IElementVisitor)new TxTesterScrubberVisitor(tight)).visit(null, (Resource)dr);
    }

    public static void scrubVS(ValueSet vs, boolean tight) {
        TxTesterScrubbers.scrubDR((DomainResource)vs, tight);
    }

    public static void scrubParams(Parameters po) {
        po.setMeta(null);
    }

    public static void scrubOO(OperationOutcome po, boolean tight) {
        TxTesterScrubbers.scrubDR((DomainResource)po, tight);
        po.getIssue().removeIf(i -> i.hasDiagnostics() & !i.hasDetails());
        for (OperationOutcome.OperationOutcomeIssueComponent iss : po.getIssue()) {
            if (!iss.hasDiagnostics() || iss.getDiagnostics().toLowerCase().contains("x-request-id")) continue;
            iss.setDiagnostics(null);
        }
    }

    public static void scrubCapStmt(CapabilityStatement cs, boolean tight) {
    }

    public static void scrubTermCaps(TerminologyCapabilities cs, boolean tight) {
    }

    public static class TxTesterScrubberVisitor
    implements ElementVisitor.IElementVisitor {
        private boolean tight;

        protected TxTesterScrubberVisitor(boolean tight) {
            this.tight = tight;
        }

        private boolean isManagedExtension(Extension extension) {
            return this.tight || !Utilities.isAbsoluteUrl((String)extension.getUrl()) || Utilities.existsInList((String)extension.getUrl(), (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/codesystem-alternate", "http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder", "http://hl7.org/fhir/StructureDefinition/codesystem-label", "http://hl7.org/fhir/StructureDefinition/coding-sctdescid", "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status", "http://hl7.org/fhir/StructureDefinition/itemWeight", "http://hl7.org/fhir/StructureDefinition/rendering-style", "http://hl7.org/fhir/StructureDefinition/rendering-xhtml", "http://hl7.org/fhir/StructureDefinition/translation", "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition", "http://hl7.org/fhir/StructureDefinition/valueset-conceptOrder", "http://hl7.org/fhir/StructureDefinition/valueset-deprecated", "http://hl7.org/fhir/StructureDefinition/valueset-label", "http://hl7.org/fhir/StructureDefinition/valueset-supplement", "http://hl7.org/fhir/test/CodeSystem/de-multi", "http://hl7.org/fhir/test/CodeSystem/en-multi", "http://hl7.org/fhir/test/StructureDefinition/unknown-extension-1", "http://hl7.org/fhir/test/StructureDefinition/unknown-extension-3", "http://hl7.org/fhir/test/StructureDefinition/unknown-extension-4", "http://hl7.org/fhir/test/StructureDefinition/unknown-extension-5", "http://hl7.org/fhir/test/ValueSet/extensions-bad-supplement", "http://hl7.org/fhir/test/ValueSet/simple-all", "http://hl7.org/fhir/test/ValueSet/simple-enumerated", "http://hl7.org/fhir/StructureDefinition/alternate-code-use", "http://hl7.org/fhir/StructureDefinition/alternate-code-status", "http://hl7.org/fhir/test/ValueSet/simple-filter-isa"});
        }

        public ElementVisitor.ElementVisitorInstruction visit(Object context, Resource resource) {
            if (resource instanceof DomainResource) {
                DomainResource dr = (DomainResource)resource;
                dr.getExtension().removeIf(ext -> !this.isManagedExtension((Extension)ext));
            }
            return ElementVisitor.ElementVisitorInstruction.VISIT_CHILDREN;
        }

        public ElementVisitor.ElementVisitorInstruction visit(Object context, Element element) {
            element.getExtension().removeIf(ext -> !this.isManagedExtension((Extension)ext));
            if (element.fhirType().equals("ValueSet.compose")) {
                return ElementVisitor.ElementVisitorInstruction.NO_VISIT_CHILDREN;
            }
            return ElementVisitor.ElementVisitorInstruction.VISIT_CHILDREN;
        }
    }
}

