/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.instance.utils.Base64Util;
import org.hl7.fhir.validation.instance.utils.MimeTypeUtil;

public class UrlUtil {
    public static String checkValidUrl(String value, IWorkerContext context) {
        if (value == null) {
            return null;
        }
        if (Utilities.noString((String)value)) {
            return context.formatMessage("XHTML_URL_EMPTY", new Object[0]);
        }
        if (value.startsWith("data:")) {
            String mMsg;
            String mimetype;
            String[] p = value.substring(5).split("\\,");
            if (p.length < 2) {
                return context.formatMessage("XHTML_URL_DATA_NO_DATA", new Object[]{value});
            }
            if (p.length > 2) {
                return context.formatMessage("XHTML_URL_DATA_DATA_INVALID_COMMA", new Object[]{value});
            }
            if (p[0].endsWith(";base64") && !Base64Util.isValidBase64(p[1])) {
                return context.formatMessage("XHTML_URL_DATA_DATA_INVALID", new Object[]{value});
            }
            if (p[0].startsWith(" ")) {
                p[0] = Utilities.trimWS((String)p[0]);
            }
            String string = mimetype = p[0].endsWith(";base64") ? p[0].substring(0, p[0].lastIndexOf(";")) : p[0];
            if (!mimetype.trim().isEmpty() && (mMsg = MimeTypeUtil.checkValidMimeType(mimetype)) != null) {
                return context.formatMessage("XHTML_URL_DATA_MIMETYPE", new Object[]{value, mMsg});
            }
            return null;
        }
        HashSet<Character> invalidChars = new HashSet<Character>();
        int c = 0;
        for (char ch : value.toCharArray()) {
            if (Character.isDigit(ch) || Character.isAlphabetic(ch) || Utilities.existsInList((int)ch, (int[])new int[]{59, 63, 58, 64, 38, 61, 43, 36, 46, 44, 47, 37, 45, 95, 126, 35, 91, 93, 33, 39, 40, 41, 42, 124})) continue;
            ++c;
            invalidChars.add(Character.valueOf(ch));
        }
        if (invalidChars.isEmpty()) {
            return null;
        }
        HashSet<CallSite> ss = new HashSet<CallSite>();
        for (Character ch : invalidChars) {
            ss.add((CallSite)((Object)("'" + ch.toString() + "'")));
        }
        return context.formatMessagePlural(Integer.valueOf(c), "XHTML_URL_INVALID_CHARS", new Object[]{CommaSeparatedStringBuilder.join((String)",", (Collection)Utilities.sorted(ss))});
    }
}

