/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import org.hl7.fhir.r5.context.CanonicalResourceManager;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

public class Definitions {
    private IWorkerContext context;
    private CanonicalResourceManager<CodeSystem> codeSystems = new CanonicalResourceManager(true, false);
    private CanonicalResourceManager<ValueSet> valuesets = new CanonicalResourceManager(true, false);
    private CanonicalResourceManager<ConceptMap> conceptMaps = new CanonicalResourceManager(true, false);
    private CanonicalResourceManager<CapabilityStatement> statements = new CanonicalResourceManager(true, false);
    private CanonicalResourceManager<StructureDefinition> structures = new CanonicalResourceManager(true, false);
    private CanonicalResourceManager<OperationDefinition> operations = new CanonicalResourceManager(true, false);
    private CanonicalResourceManager<SearchParameter> searchParams = new CanonicalResourceManager(true, false);
    private CanonicalResourceManager<CompartmentDefinition> compartments = new CanonicalResourceManager(true, false);

    public Definitions(IWorkerContext context) {
        this.context = context;
    }

    public CanonicalResourceManager<CodeSystem> getCodeSystems() {
        return this.codeSystems;
    }

    public CanonicalResourceManager<ValueSet> getValuesets() {
        return this.valuesets;
    }

    public CanonicalResourceManager<ConceptMap> getConceptMaps() {
        return this.conceptMaps;
    }

    public CanonicalResourceManager<CapabilityStatement> getStatements() {
        return this.statements;
    }

    public CanonicalResourceManager<StructureDefinition> getStructures() {
        return this.structures;
    }

    public CanonicalResourceManager<OperationDefinition> getOperations() {
        return this.operations;
    }

    public CanonicalResourceManager<SearchParameter> getSearchParams() {
        return this.searchParams;
    }

    public CanonicalResourceManager<CompartmentDefinition> getCompartments() {
        return this.compartments;
    }

    public String getCodeDefinition(String system, String code) {
        CodeSystem cs = (CodeSystem)this.codeSystems.get(system);
        if (cs == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent cc = cs.getDefinitionByCode(code);
        return cc == null ? null : cc.getDefinition();
    }

    public boolean hasPrimitiveType(String tn) {
        StructureDefinition sd = (StructureDefinition)this.structures.get("http://hl7.org/fhir/StructureDefinition/" + tn);
        if (sd == null) {
            sd = this.context.fetchTypeDefinition(tn);
        }
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION;
    }

    public boolean hasResource(String tn) {
        StructureDefinition sd = (StructureDefinition)this.structures.get("http://hl7.org/fhir/StructureDefinition/" + tn);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION;
    }

    public StructureDefinition getType(String tn) {
        StructureDefinition sd = (StructureDefinition)this.structures.get("http://hl7.org/fhir/StructureDefinition/" + tn);
        if (sd == null) {
            sd = (StructureDefinition)this.structures.get(tn);
        }
        if (sd == null) {
            sd = this.context.fetchTypeDefinition(tn);
        }
        return sd;
    }

    public void fix() {
        for (StructureDefinition sd : this.structures.getList()) {
            if (!sd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-implements") || Utilities.existsInList((String)sd.getType(), (String[])new String[]{"MedicationKnowledge", "ObservationDefinition", "SpecimenDefinition"})) continue;
            sd.setBaseDefinition(ExtensionUtilities.readStringExtension((DomainResource)sd, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-implements"));
        }
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public boolean isPrimitive(String name) {
        StructureDefinition sd = (StructureDefinition)this.getStructures().get(this.typeNs(name));
        if (sd == null) {
            sd = this.context.fetchTypeDefinition(name);
        }
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private String typeNs(String name) {
        return "http://hl7.org/fhir/StructureDefinition/" + name;
    }
}

