/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.npm.NpmPackageIndexBuilder;

public class SQLiteINpmPackageIndexBuilderDBImpl
implements NpmPackageIndexBuilder.INpmPackageIndexBuilderDBImpl {
    private String dbFilename;
    private Connection conn;
    private PreparedStatement psql;

    public void start(String filename) {
        this.dbFilename = filename;
        try {
            ManagedFileAccess.file((String)filename).delete();
            this.conn = DriverManager.getConnection("jdbc:sqlite:" + filename);
            Statement stmt = this.conn.createStatement();
            stmt.execute("CREATE TABLE ResourceList (\r\nFileName       nvarchar NOT NULL,\r\nResourceType   nvarchar NOT NULL,\r\nId             nvarchar NULL,\r\nUrl            nvarchar NULL,\r\nVersion        nvarchar NULL,\r\nKind           nvarchar NULL,\r\nType           nvarchar NULL,\r\nSupplements    nvarchar NULL,\r\nContent        nvarchar NULL,\r\nValueSet       nvarchar NULL,\r\nDerivation     nvarchar NULL,\r\nPRIMARY KEY (FileName))\r\n");
            this.psql = this.conn.prepareStatement("Insert into ResourceList (FileName, ResourceType, Id, Url, Version, Kind, Type, Supplements, Content, ValueSet) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (Exception e) {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.conn = null;
        }
    }

    public void seeFile(String name, JsonObject fi) throws Exception {
        if (this.psql != null) {
            this.psql.setString(1, name);
            this.psql.setString(2, fi.asString("resourceType"));
            this.psql.setString(3, fi.asString("id"));
            this.psql.setString(4, fi.asString("url"));
            this.psql.setString(5, fi.asString("version"));
            this.psql.setString(6, fi.asString("kind"));
            this.psql.setString(7, fi.asString("type"));
            this.psql.setString(8, fi.asString("supplements"));
            this.psql.setString(9, fi.asString("content"));
            this.psql.setString(10, fi.asString("valueSet"));
            this.psql.setString(10, fi.asString("derivation"));
            this.psql.execute();
        }
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class SQLiteINpmPackageIndexBuilderDBImplFactory
    implements NpmPackageIndexBuilder.INpmPackageIndexBuilderDBImplFactory {
        public NpmPackageIndexBuilder.INpmPackageIndexBuilderDBImpl create() {
            return new SQLiteINpmPackageIndexBuilderDBImpl();
        }
    }
}

