/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.SHCParser;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.validation.ValidatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceChecker.class);

    public static Manager.FhirFormat checkIsResource(SimpleWorkerContext context, byte[] cnt, String filename, boolean guessFromExtension) {
        if (cnt.length == 0) {
            log.info("Loader: " + filename + " is empty");
            return null;
        }
        if (guessFromExtension) {
            String ext = Utilities.getFileExtension((String)filename).toLowerCase();
            if (Utilities.existsInList((String)ext, (String[])new String[]{"xml"})) {
                return Manager.FhirFormat.XML;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"ttl"})) {
                return Manager.FhirFormat.TURTLE;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"map", "fml"})) {
                return Manager.FhirFormat.FML;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"jwt", "jws"})) {
                return Manager.FhirFormat.SHC;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"ndjson"})) {
                return Manager.FhirFormat.NDJSON;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"json"})) {
                if (cnt.length > 2048) {
                    return Manager.FhirFormat.JSON;
                }
                try {
                    JsonObject json = JsonParser.parseObject((byte[])cnt);
                    if (json.has("verifiableCredential")) {
                        return Manager.FhirFormat.SHC;
                    }
                }
                catch (Exception json) {
                    // empty catch block
                }
                return Manager.FhirFormat.JSON;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"txt"})) {
                try {
                    String src = FileUtilities.bytesToString((byte[])cnt);
                    if (src.startsWith("shc:/")) {
                        return Manager.FhirFormat.SHC;
                    }
                    if (src.startsWith("shlink:/") || src.contains("#shlink:/")) {
                        return Manager.FhirFormat.SHL;
                    }
                }
                catch (Exception src) {
                    // empty catch block
                }
                return Manager.FhirFormat.TEXT;
            }
        }
        try {
            Manager.parse((IWorkerContext)context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.JSON);
            return Manager.FhirFormat.JSON;
        }
        catch (Exception e) {
            log.debug("Not JSON: " + e.getMessage());
            try {
                Manager.parse((IWorkerContext)context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.NDJSON);
                return Manager.FhirFormat.NDJSON;
            }
            catch (Exception e2) {
                log.debug("Not NDJSON: " + e2.getMessage());
                try {
                    ValidatorUtils.parseXml(cnt);
                    return Manager.FhirFormat.XML;
                }
                catch (Exception e3) {
                    log.debug("Not XML: " + e3.getMessage());
                    try {
                        Manager.parse((IWorkerContext)context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.TURTLE);
                        return Manager.FhirFormat.TURTLE;
                    }
                    catch (Exception e4) {
                        log.debug("Not Turtle: " + e4.getMessage());
                        try {
                            String s = new String(cnt, StandardCharsets.UTF_8);
                            if (s.startsWith("shlink:/") || s.contains("#shlink:/")) {
                                return Manager.FhirFormat.SHL;
                            }
                            if (s.startsWith("shc:/")) {
                                s = SHCParser.decodeQRCode((String)s);
                            }
                            SHCParser.JWT jwt = new SHCParser((IWorkerContext)context).decodeJWT(null, s);
                            return Manager.FhirFormat.SHC;
                        }
                        catch (Exception e5) {
                            log.debug("Not a smart health card: " + e5.getMessage());
                            try {
                                new StructureMapUtilities((IWorkerContext)context, null, null).parse(FileUtilities.bytesToString((byte[])cnt), null);
                                return Manager.FhirFormat.TEXT;
                            }
                            catch (Exception e6) {
                                log.debug("Not Text: " + e6.getMessage());
                                log.debug("     .. not a resource: " + filename);
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }
}

