/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.tasks;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.SystemExitManager;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.tasks.StandaloneTask;
import org.hl7.fhir.validation.cli.utils.Params;
import org.hl7.fhir.validation.special.TxTester;

public class TxTestsTask
extends StandaloneTask {
    @Override
    public String getName() {
        return "txTests";
    }

    @Override
    public String getDisplayName() {
        return "Terminology Tests";
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean shouldExecuteTask(CliContext cliContext, String[] args) {
        return Params.hasParam(args, "-txTests");
    }

    @Override
    public void printHelp(PrintStream out) {
    }

    @Override
    public void executeTask(CliContext cliContext, String[] args, TimeTracker tt, TimeTracker.Session tts) throws Exception {
        String output = Params.getParam(args, "-output");
        String version = Params.getParam(args, "-version");
        String tx = Params.getParam(args, "-tx");
        String filter = Params.getParam(args, "-filter");
        String externals = Params.getParam(args, "-externals");
        if (output == null) {
            output = Utilities.path((String[])new String[]{"[tmp]"});
        }
        if (version == null) {
            version = "current";
        }
        TxTester txTester = new TxTester(new TxTester.InternalTxLoader(version), tx, false, this.loadExternals(externals));
        for (String input : cliContext.getInputs()) {
            txTester.addLoader(new TxTester.InternalTxLoader(input, true));
        }
        boolean ok = txTester.setOutput(output).execute(cliContext.getModeParams(), filter);
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{output, "report.json"})), (Resource)txTester.getTestReport());
        SystemExitManager.setError((int)(ok ? 0 : 1));
        SystemExitManager.finish();
    }

    private JsonObject loadExternals(String externals) throws JsonException, IOException {
        if (externals == null) {
            return null;
        }
        return org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromFile((String)externals);
    }
}

