/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests.execution.junit4;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hl7.fhir.utilities.tests.execution.CliTestSummary;
import org.hl7.fhir.utilities.tests.execution.ModuleTestExecutor;
import org.hl7.fhir.utilities.tests.execution.junit4.JUnit4TestSummaryAdapter;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;

public class JUnit4TestExecutor
extends ModuleTestExecutor {
    private final String moduleName;
    private final List<String> classNames;

    public JUnit4TestExecutor(String moduleName, List<String> classNames) {
        this.moduleName = moduleName + " (JUnit4)";
        this.classNames = Collections.unmodifiableList(new ArrayList<String>(classNames));
    }

    @Override
    public CliTestSummary executeTests(Logger log, String classNameFilter) {
        JUnitCore junit = new JUnitCore();
        junit.addListener((RunListener)new JUnit4RunListener(log));
        Pattern pattern = classNameFilter != null ? Pattern.compile(classNameFilter) : null;
        List<Class> classes = this.classNames.stream().filter(className -> pattern == null ? true : pattern.matcher((CharSequence)className).matches()).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        Class[] classArray = new Class[classes.size()];
        classes.toArray(classArray);
        Result result = junit.run(classArray);
        return new JUnit4TestSummaryAdapter(result);
    }

    @Override
    @Generated
    public String getModuleName() {
        return this.moduleName;
    }

    private class JUnit4RunListener
    extends RunListener {
        Logger log;

        public JUnit4RunListener(Logger log) {
            this.log = log;
        }

        public void testStarted(Description description) {
            ModuleTestExecutor.printTestStarted(this.log, description.getDisplayName());
        }

        public void testFinished(Description description) {
            ModuleTestExecutor.printTestFinished(this.log, description.getDisplayName(), "FINISHED");
        }

        public void testFailure(Failure failure) {
            ModuleTestExecutor.printTestFailed(this.log, failure.getDescription().getDisplayName(), failure.getException());
        }
    }
}

