/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.hl7.fhir.utilities.http.HTTPAuthenticationMode;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.utilities.settings.ServerDetailsPOJO;

public class PackageServer {
    private String url;
    private HTTPAuthenticationMode authenticationMode;
    private PackageServerType serverType;
    private String username;
    private String password;
    private String token;
    private String apiKey;
    public static final String SECONDARY_SERVER = "https://packages.fhir.org";
    public static final String PRIMARY_SERVER = "https://packages2.fhir.org/packages";

    public PackageServer(String url) {
        this.url = url;
        this.authenticationMode = HTTPAuthenticationMode.NONE;
        this.serverType = PackageServerType.FHIR;
    }

    public static PackageServer primaryServer() {
        return new PackageServer(PRIMARY_SERVER);
    }

    public static PackageServer secondaryServer() {
        return new PackageServer(SECONDARY_SERVER);
    }

    public static List<PackageServer> defaultServers() {
        ArrayList<PackageServer> servers = new ArrayList<PackageServer>();
        servers.add(PackageServer.primaryServer());
        servers.add(PackageServer.secondaryServer());
        return servers;
    }

    public static PackageServer getPackageServerFromPOJO(ServerDetailsPOJO pojo) {
        return new PackageServer(pojo.getUrl()).withAuthenticationMode(PackageServer.getModeFromPOJO(pojo)).withServerType(PackageServer.getPackageServerType(pojo.getType())).withUsername(pojo.getUsername()).withPassword(pojo.getPassword()).withToken(pojo.getToken()).withApiKey(pojo.getApikey());
    }

    private static boolean isPackageServer(String serverType) {
        if (serverType == null) {
            return false;
        }
        if (serverType.equals("fhir-package")) {
            return true;
        }
        return serverType.equals("npm-package");
    }

    private static PackageServerType getPackageServerType(String serverType) {
        if (serverType == null) {
            return null;
        }
        if (serverType.equals("fhir-package")) {
            return PackageServerType.FHIR;
        }
        if (serverType.equals("npm-package")) {
            return PackageServerType.NPM;
        }
        return null;
    }

    @Nullable
    private static HTTPAuthenticationMode getModeFromPOJO(ServerDetailsPOJO pojo) {
        if (pojo.getAuthenticationType().equalsIgnoreCase("basic")) {
            return HTTPAuthenticationMode.BASIC;
        }
        if (pojo.getAuthenticationType().equalsIgnoreCase("token")) {
            return HTTPAuthenticationMode.TOKEN;
        }
        if (pojo.getAuthenticationType().equalsIgnoreCase("apikey")) {
            return HTTPAuthenticationMode.APIKEY;
        }
        return null;
    }

    public static List<PackageServer> getConfiguredServers() {
        return FhirSettings.getServers().stream().filter(serverDetailsPOJO -> PackageServer.isPackageServer(serverDetailsPOJO.getType())).map(PackageServer::getPackageServerFromPOJO).collect(Collectors.toList());
    }

    public String toString() {
        return this.url;
    }

    public PackageServer copy() {
        PackageServer packageServer = new PackageServer(this.url);
        packageServer.authenticationMode = this.authenticationMode;
        packageServer.serverType = this.serverType;
        packageServer.username = this.username;
        packageServer.password = this.password;
        packageServer.token = this.token;
        packageServer.apiKey = this.apiKey;
        return packageServer;
    }

    public PackageServer withAuthenticationMode(HTTPAuthenticationMode mode) {
        PackageServer packageServer = this.copy();
        packageServer.authenticationMode = mode;
        return packageServer;
    }

    public PackageServer withServerType(PackageServerType serverType) {
        PackageServer packageServer = this.copy();
        packageServer.serverType = serverType;
        return packageServer;
    }

    public PackageServer withPassword(String password) {
        PackageServer packageServer = this.copy();
        packageServer.password = password;
        return packageServer;
    }

    public PackageServer withUsername(String username) {
        PackageServer packageServer = this.copy();
        packageServer.username = username;
        return packageServer;
    }

    public PackageServer withToken(String token) {
        PackageServer packageServer = this.copy();
        packageServer.token = token;
        return packageServer;
    }

    public PackageServer withApiKey(String apiKey) {
        PackageServer packageServer = this.copy();
        packageServer.apiKey = apiKey;
        return packageServer;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public HTTPAuthenticationMode getAuthenticationMode() {
        return this.authenticationMode;
    }

    @Generated
    public PackageServerType getServerType() {
        return this.serverType;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    public static enum PackageServerType {
        FHIR,
        NPM;

    }
}

