/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmPackageIndexBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NpmPackageIndexBuilder.class);
    private static INpmPackageIndexBuilderDBImplFactory extensionFactory;
    public static final Integer CURRENT_INDEX_VERSION;
    private JsonObject index;
    private JsonArray files;
    private String dbFilename;
    private static INpmPackageIndexBuilderDBImpl extension;

    public void start(String filename) {
        this.index = new JsonObject();
        this.index.add("index-version", CURRENT_INDEX_VERSION);
        this.files = new JsonArray();
        this.index.add("files", this.files);
        if (filename != null) {
            this.dbFilename = filename;
            try {
                if (extensionFactory != null) {
                    extension = extensionFactory.create();
                    extension.start(filename);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean seeFile(String name, byte[] content) {
        if (!name.endsWith(".json")) return true;
        try (JsonParser parser = new JsonFactory().createParser(content);){
            JsonObject fi = new JsonObject();
            int level = 0;
            while (parser.nextToken() != null) {
                if (parser.currentToken() == JsonToken.START_OBJECT || parser.currentToken() == JsonToken.START_ARRAY) {
                    ++level;
                } else if (parser.currentToken() == JsonToken.END_OBJECT || parser.currentToken() == JsonToken.END_ARRAY) {
                    --level;
                }
                if (level != 1) continue;
                String fieldName = parser.currentName();
                if ("resourceType".equals(fieldName)) {
                    parser.nextToken();
                    this.files.add(fi);
                    fi.add("filename", name);
                    fi.add(fieldName, parser.getText());
                }
                if (!"id".equals(fieldName) && !"url".equals(fieldName) && !"version".equals(fieldName) && !"kind".equals(fieldName) && !"type".equals(fieldName) && !"supplements".equals(fieldName) && !"content".equals(fieldName) && !"valueSet".equals(fieldName) && !"derivation".equals(fieldName)) continue;
                parser.nextToken();
                fi.add(fieldName, parser.getText());
            }
            if (!fi.has("resourceType")) {
                boolean bl = true;
                return bl;
            }
            if (extension == null) return true;
            extension.seeFile(name, fi);
            return true;
        }
        catch (Exception e) {
            if (!name.contains("openapi")) return true;
            return false;
        }
    }

    public String build() {
        if (extension != null) {
            extension.close();
        }
        String res = org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)this.index, true);
        this.index = null;
        this.files = null;
        return res;
    }

    public void executeWithStatus(String folder) throws IOException {
        log.info("Indexing Package " + folder + " ... ");
        this.execute(folder);
        log.info("Indexing Package " + folder + " done");
    }

    public void execute(String folder) throws IOException {
        if (this.existsFolder(folder, "package")) {
            folder = Utilities.path(folder, "package");
        }
        if (!this.existsFile(folder, "package.json")) {
            throw new FHIRException("Not a proper package? (can't find package.json)");
        }
        this.start(Utilities.path(folder, ".index.db"));
        File dir = ManagedFileAccess.file(folder);
        for (File f : dir.listFiles()) {
            this.seeFile(f.getName(), FileUtilities.fileToBytes(f));
        }
        FileUtilities.stringToFile(this.build(), Utilities.path(folder, ".index.json"));
    }

    private boolean existsFolder(String ... args) throws IOException {
        File f = ManagedFileAccess.file(Utilities.path(args));
        return f.exists() && f.isDirectory();
    }

    private boolean existsFile(String ... args) throws IOException {
        File f = ManagedFileAccess.file(Utilities.path(args));
        return f.exists() && !f.isDirectory();
    }

    public static void main(String[] args) throws IOException {
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.4.0");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#3.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#4.0.1");
    }

    public String getDbFilename() {
        return this.dbFilename;
    }

    public static INpmPackageIndexBuilderDBImplFactory getExtensionFactory() {
        return extensionFactory;
    }

    public static void setExtensionFactory(INpmPackageIndexBuilderDBImplFactory extensionFactory) {
        NpmPackageIndexBuilder.extensionFactory = extensionFactory;
    }

    static {
        CURRENT_INDEX_VERSION = 2;
    }

    public static interface INpmPackageIndexBuilderDBImplFactory {
        public INpmPackageIndexBuilderDBImpl create();
    }

    public static interface INpmPackageIndexBuilderDBImpl {
        public void start(String var1);

        public void seeFile(String var1, JsonObject var2) throws Exception;

        public void close();
    }
}

