/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.ByteProvider;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.NpmPackageIndexBuilder;
import org.hl7.fhir.utilities.npm.NpmPackageReadLogger;
import org.hl7.fhir.utilities.npm.PackageGenerator;
import org.hl7.fhir.utilities.npm.PackageHacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmPackage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NpmPackage.class);
    private String path;
    private JsonObject npm;
    private final Map<String, NpmPackageFolder> folders = new HashMap<String, NpmPackageFolder>();
    private boolean changedByLoader;
    private Map<String, Object> userData;
    private boolean minimalMemory;
    private int size;
    private boolean warned = false;
    private static boolean loadCustomResources;
    private static final int BUFFER_SIZE = 1024;

    public static boolean isValidName(String pid) {
        return pid.matches("^[a-z][a-zA-Z0-9]*(\\.[a-z][a-zA-Z0-9\\-]*)+$");
    }

    public static boolean isValidVersion(String ver) {
        return ver.matches("^[0-9]+\\.[0-9]+\\.[0-9]+$");
    }

    private NpmPackage() {
    }

    public static NpmPackage fromFolder(String path) throws IOException {
        return NpmPackage.fromFolder(path, true);
    }

    public static NpmPackage fromFolder(String path, boolean checkIndexed) throws IOException {
        NpmPackage res = new NpmPackage();
        res.loadFiles(path, ManagedFileAccess.file(path), new String[0]);
        if (checkIndexed) {
            res.checkIndexed(path);
        }
        return res;
    }

    public static NpmPackage fromFolderMinimal(String path) throws IOException {
        return NpmPackage.fromFolderMinimal(path, true);
    }

    public static NpmPackage fromFolderMinimal(String path, boolean checkIndexed) throws IOException {
        NpmPackage res = new NpmPackage();
        res.minimalMemory = true;
        res.loadFiles(path, ManagedFileAccess.file(path), new String[0]);
        if (checkIndexed) {
            res.checkIndexed(path);
        }
        return res;
    }

    public static NpmPackage empty(PackageGenerator thePackageGenerator) {
        NpmPackage retVal = new NpmPackage();
        retVal.npm = PackageHacker.fixPackageOnLoad(thePackageGenerator.getRootJsonObject());
        return retVal;
    }

    public static NpmPackage empty() {
        NpmPackage retVal = new NpmPackage();
        return retVal;
    }

    public Map<String, Object> getUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        return this.userData;
    }

    public void loadFiles(String path, File source, String ... exemptions) throws IOException {
        this.npm = PackageHacker.fixPackageOnLoad(JsonParser.parseObject(FileUtilities.fileToString(Utilities.path(path, "package", "package.json"))));
        this.path = path;
        File dir = ManagedFileAccess.file(path);
        for (File f : dir.listFiles()) {
            if (NpmPackage.isInternalExemptFile(f) || Utilities.existsInList(f.getName(), exemptions)) continue;
            if (f.isDirectory()) {
                String d = f.getName();
                if (!d.equals("package")) {
                    d = Utilities.path("package", d);
                }
                File ij = ManagedFileAccess.file(Utilities.path(f.getAbsolutePath(), ".index.json"));
                NpmPackageFolder folder = new NpmPackageFolder(d);
                folder.folder = f;
                this.folders.put(d, folder);
                if (!(!ij.exists() && this.minimalMemory || this.minimalMemory)) {
                    try {
                        if (!ij.exists() || !folder.readIndex(JsonParser.parseObject(ij), folder.getTypes())) {
                            this.indexFolder(folder.getFolderName(), folder);
                        }
                    }
                    catch (Exception e) {
                        throw new IOException("Error parsing " + ij.getAbsolutePath() + ": " + e.getMessage(), e);
                    }
                }
                this.loadSubFolders(dir.getAbsolutePath(), f);
                continue;
            }
            NpmPackageFolder folder = new NpmPackageFolder(Utilities.path("package", "$root"));
            folder.folder = dir;
            this.folders.put(Utilities.path("package", "$root"), folder);
        }
    }

    public static boolean isInternalExemptFile(File f) {
        return Utilities.existsInList(f.getName(), ".git", ".svn", ".DS_Store") || Utilities.existsInList(f.getName(), "package-list.json") || Utilities.endsWithInList(f.getName(), ".tgz");
    }

    private void loadSubFolders(String rootPath, File dir) throws IOException {
        for (File f : dir.listFiles()) {
            if (!f.isDirectory() || "custom".equals(f.getName()) && !loadCustomResources) continue;
            String d = f.getAbsolutePath().substring(rootPath.length() + 1);
            if (!d.startsWith("package")) {
                d = Utilities.path("package", d);
            }
            NpmPackageFolder folder = new NpmPackageFolder(d);
            folder.folder = f;
            this.folders.put(d, folder);
            File ij = ManagedFileAccess.file(Utilities.path(f.getAbsolutePath(), ".index.json"));
            if (ij.exists() || !this.minimalMemory) {
                try {
                    if (!ij.exists() || !folder.readIndex(JsonParser.parseObject(ij), folder.getTypes())) {
                        this.indexFolder(folder.getFolderName(), folder);
                    }
                }
                catch (Exception e) {
                    throw new IOException("Error parsing " + ij.getAbsolutePath() + ": " + e.getMessage(), e);
                }
            }
            this.loadSubFolders(rootPath, f);
        }
    }

    public static NpmPackage fromFolder(String folder, PackageGenerator.PackageType defType, String ... exemptions) throws IOException {
        NpmPackage res = new NpmPackage();
        res.loadFiles(folder, ManagedFileAccess.file(folder), exemptions);
        if (!res.folders.containsKey("package")) {
            Map<String, NpmPackageFolder> map = res.folders;
            NpmPackage npmPackage = res;
            Objects.requireNonNull(npmPackage);
            map.put("package", npmPackage.new NpmPackageFolder("package"));
        }
        if (!res.folders.get("package").hasFile("package.json") && defType != null) {
            FileUtilities.stringToFile("{ \"type\" : \"" + defType.getCode() + "\"}", Utilities.path(res.folders.get((Object)"package").folder.getAbsolutePath(), "package.json"));
        }
        res.npm = PackageHacker.fixPackageOnLoad(JsonParser.parseObject(new String(res.folders.get("package").fetchFile("package.json"))));
        return res;
    }

    @Nonnull
    public static NpmPackage fromPackage(InputStream tgz) throws IOException {
        return NpmPackage.fromPackage(tgz, null, false);
    }

    public static NpmPackage fromPackage(InputStream tgz, String desc) throws IOException {
        return NpmPackage.fromPackage(tgz, desc, false);
    }

    public static NpmPackage fromPackage(InputStream tgz, String desc, boolean progress) throws IOException {
        NpmPackage res = new NpmPackage();
        res.readStream(tgz, desc, progress);
        return res;
    }

    public static NpmPackage extractFromTgz(InputStream tgz, String desc, String tempDir, boolean minimal) throws IOException {
        GzipCompressorInputStream gzipIn;
        FileUtilities.createDirectory(tempDir);
        int size = 0;
        try {
            gzipIn = new GzipCompressorInputStream(tgz);
        }
        catch (Exception e) {
            throw new IOException("Error reading " + (desc == null ? "package" : desc) + ": " + e.getMessage(), e);
        }
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextEntry()) != null) {
                String n = entry.getName();
                if (n.contains("/..") || n.contains("../")) {
                    throw new RuntimeException("Entry with an illegal name: " + n);
                }
                if (entry.isDirectory()) {
                    if (Utilities.noString(n)) continue;
                    String dir = n.substring(0, n.length() - 1);
                    FileUtilities.createDirectory(Utilities.path(tempDir, dir));
                    continue;
                }
                byte[] data = new byte[1024];
                String filename = Utilities.path(tempDir, n);
                String folder = FileUtilities.getDirectoryForFile(filename);
                FileUtilities.createDirectory(folder);
                FileOutputStream fos = ManagedFileAccess.outStream(filename);
                try (BufferedOutputStream dst = new BufferedOutputStream(fos, 1024);){
                    int count;
                    while ((count = tarIn.read(data, 0, 1024)) != -1) {
                        dst.write(data, 0, count);
                        size += count;
                    }
                }
                fos.close();
            }
        }
        try {
            NpmPackage npm = NpmPackage.fromFolderMinimal(tempDir);
            npm.setSize(size);
            if (!minimal) {
                npm.checkIndexed(desc);
            }
            return npm;
        }
        catch (Exception e) {
            throw new IOException("Error parsing " + (String)(desc == null ? "" : desc + "#") + "package/package.json: " + e.getMessage(), e);
        }
    }

    public void readStream(InputStream tgz, String desc, boolean progress) throws IOException {
        GzipCompressorInputStream gzipIn;
        try {
            gzipIn = new GzipCompressorInputStream(tgz);
        }
        catch (Exception e) {
            throw new IOException("Error reading " + (desc == null ? "package" : desc) + ": " + e.getMessage(), e);
        }
        boolean haveLoggedDotSlashPrefixWarning = false;
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            TarArchiveEntry entry;
            NpmPackageReadLogger readLogger = new NpmPackageReadLogger(progress);
            while ((entry = tarIn.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName.contains("..")) {
                    throw new RuntimeException("Entry with an illegal name: " + entryName);
                }
                if (entry.isDirectory()) {
                    String dir = entryName.substring(0, entryName.length() - 1);
                    if (dir.startsWith("./")) {
                        if (!haveLoggedDotSlashPrefixWarning) {
                            log.warn("The NPM file contains resource paths that are prefixed with \"./\". This is invalid and should be corrected in the source package.");
                            haveLoggedDotSlashPrefixWarning = true;
                        }
                        dir = dir.substring(2);
                    }
                    if (dir.startsWith("package/")) {
                        dir = dir.substring(8);
                    }
                    this.folders.put(dir, new NpmPackageFolder(dir));
                } else {
                    byte[] data = new byte[1024];
                    ByteArrayOutputStream fos = new ByteArrayOutputStream();
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, 1024);){
                        int count;
                        while ((count = tarIn.read(data, 0, 1024)) != -1) {
                            dest.write(data, 0, count);
                        }
                    }
                    fos.close();
                    this.loadFile(entryName, fos.toByteArray());
                }
                readLogger.entry(entryName);
            }
        }
        NpmPackageFolder packageFolder = this.folders.get("package");
        Validate.notNull((Object)packageFolder, (String)"Package folder not found in NPM file", (Object[])new Object[0]);
        byte[] packageJsonBytes = packageFolder.fetchFile("package.json");
        Validate.notNull((Object)packageJsonBytes, (String)"package/package.json not found in NPM file", (Object[])new Object[0]);
        try {
            this.npm = PackageHacker.fixPackageOnLoad(JsonParser.parseObject(packageJsonBytes));
        }
        catch (Exception e) {
            throw new IOException("Error parsing " + (String)(desc == null ? "" : desc + "#") + "package/package.json: " + e.getMessage(), e);
        }
        this.checkIndexed(desc);
    }

    public void loadFile(String n, byte[] data) throws IOException {
        String dir;
        if (n.startsWith("./")) {
            n = n.substring(2);
        }
        String string = dir = (n = n.replace("//", "/")).contains("/") ? n.substring(0, n.lastIndexOf("/")) : "$root";
        if (dir.startsWith("package/")) {
            dir = dir.substring(8);
        }
        n = n.substring(n.lastIndexOf("/") + 1);
        NpmPackageFolder index = this.folders.get(dir);
        if (index == null) {
            index = new NpmPackageFolder(dir);
            this.folders.put(dir, index);
        }
        index.content.put(n, data);
    }

    public boolean isIndexed() throws IOException {
        for (NpmPackageFolder folder : this.folders.values()) {
            JsonObject index = folder.index();
            if (folder.index() != null && index.forceArray("files").size() != 0) continue;
            return false;
        }
        return true;
    }

    public void checkIndexed(String path) throws IOException {
        for (NpmPackageFolder folder : this.folders.values()) {
            JsonObject index = folder.index();
            if (index != null && index.forceArray("files").size() != 0) continue;
            this.indexFolder(path, folder);
        }
    }

    public void indexFolder(String path, NpmPackageFolder folder) throws FileNotFoundException, IOException {
        ArrayList<String> remove = new ArrayList<String>();
        NpmPackageIndexBuilder indexer = new NpmPackageIndexBuilder();
        indexer.start(folder.folder != null ? Utilities.path(folder.folder.getAbsolutePath(), ".index.db") : null);
        for (String file : folder.listFiles()) {
            if (indexer.seeFile(file, folder.fetchFile(file))) continue;
            remove.add(file);
        }
        for (String n : remove) {
            folder.removeFile(n);
        }
        String json = indexer.build();
        try {
            if (!this.minimalMemory) {
                folder.readIndex(JsonParser.parseObject(json), folder.getTypes());
            }
            if (folder.folder != null) {
                FileUtilities.stringToFile(json, Utilities.path(folder.folder.getAbsolutePath(), ".index.json"));
            }
        }
        catch (Exception e) {
            FileUtilities.stringToFile(json, Utilities.path("[tmp]", ".index.json"));
            throw new IOException("Error parsing " + (String)(path == null ? "" : path + "#") + "package/" + folder.folderName + "/.index.json: " + e.getMessage(), e);
        }
    }

    public static NpmPackage fromZip(InputStream stream, boolean dropRootFolder, String desc) throws IOException {
        ZipEntry ze;
        NpmPackage res = new NpmPackage();
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            int size;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bytes, buffer.length);
            while ((size = zip.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
            if (bytes.size() > 0) {
                if (dropRootFolder) {
                    res.loadFile(ze.getName().substring(ze.getName().indexOf("/") + 1), bytes.toByteArray());
                } else {
                    res.loadFile(ze.getName(), bytes.toByteArray());
                }
            }
            zip.closeEntry();
        }
        zip.close();
        try {
            res.npm = PackageHacker.fixPackageOnLoad(JsonParser.parseObject(res.folders.get("package").fetchFile("package.json")));
        }
        catch (Exception e) {
            throw new IOException("Error parsing " + (String)(desc == null ? "" : desc + "#") + "package/package.json: " + e.getMessage(), e);
        }
        res.checkIndexed(desc);
        return res;
    }

    public List<String> list(String folder) throws IOException {
        ArrayList<String> res;
        block3: {
            block2: {
                res = new ArrayList<String>();
                if (!this.folders.containsKey(folder)) break block2;
                for (String s : this.folders.get(folder).listFiles()) {
                    if (s.startsWith(".")) continue;
                    res.add(s);
                }
                break block3;
            }
            if (!this.folders.containsKey(Utilities.path("package", folder))) break block3;
            for (String s : this.folders.get(Utilities.path("package", folder)).listFiles()) {
                if (s.startsWith(".")) continue;
                res.add(s);
            }
        }
        return res;
    }

    public List<String> listResources(String ... types) throws IOException {
        return this.listResources(Utilities.stringSet(types));
    }

    public List<String> listResourcesinFolder(String folder, String ... types) throws IOException {
        return this.listResourcesInFolder(folder, Utilities.stringSet(types));
    }

    public List<String> listResources(Set<String> types) throws IOException {
        return this.listResourcesInFolder("package", types);
    }

    public List<String> listResourcesInFolder(String folderName, Set<String> types) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        NpmPackageFolder folder = this.folders.get(folderName);
        if (types.size() == 0) {
            for (String s : folder.types.keySet()) {
                if (!folder.types.containsKey(s)) continue;
                res.addAll((Collection<String>)folder.types.get(s));
            }
        } else {
            for (String s : types) {
                if (!folder.types.containsKey(s)) continue;
                res.addAll((Collection<String>)folder.types.get(s));
            }
        }
        Collections.sort(res);
        return res;
    }

    public List<PackagedResourceFile> listAllResources(Collection<String> types) throws IOException {
        ArrayList<PackagedResourceFile> res = new ArrayList<PackagedResourceFile>();
        for (NpmPackageFolder folder : this.folders.values()) {
            if (types.size() == 0) {
                for (String s : folder.types.keySet()) {
                    if (!folder.types.containsKey(s)) continue;
                    for (String n : folder.types.get(s)) {
                        res.add(new PackagedResourceFile(folder.folderName, n, s));
                    }
                }
                continue;
            }
            for (String s : types) {
                if (!folder.types.containsKey(s)) continue;
                for (String n : folder.types.get(s)) {
                    res.add(new PackagedResourceFile(folder.folderName, n, s));
                }
            }
        }
        Collections.sort(res, new PackagedResourceFile.Sorter());
        return res;
    }

    public List<PackageResourceInformation> listIndexedResources(String ... types) throws IOException {
        return this.listIndexedResources(Utilities.stringSet(types));
    }

    public List<PackageResourceInformation> listIndexedResources(Set<String> types) throws IOException {
        ArrayList<PackageResourceInformation> res = new ArrayList<PackageResourceInformation>();
        for (NpmPackageFolder folder : this.folders.values()) {
            JsonObject index = folder.index();
            if (index == null) continue;
            for (JsonObject fi : index.getJsonObjects("files")) {
                if (!types.contains(fi.asString("resourceType")) && !types.isEmpty()) continue;
                res.add(new PackageResourceInformation((String)(folder.folder == null ? "@" + folder.getFolderName() : folder.folder.getAbsolutePath()), fi));
            }
        }
        return res;
    }

    public InputStream loadResource(String file) throws IOException {
        NpmPackageFolder folder = this.folders.get("package");
        return new ByteArrayInputStream(folder.fetchFile(file));
    }

    public InputStream loadByCanonical(String canonical) throws IOException {
        return this.loadByCanonicalVersion("package", canonical, null);
    }

    public InputStream loadByCanonical(String folder, String canonical) throws IOException {
        return this.loadByCanonicalVersion(folder, canonical, null);
    }

    public InputStream loadByCanonicalVersion(String canonical, String version) throws IOException {
        return this.loadByCanonicalVersion("package", canonical, version);
    }

    public InputStream loadByCanonicalVersion(String folder, String canonical, String version) throws IOException {
        NpmPackageFolder f = this.folders.get(folder);
        ArrayList<JsonObject> matches = new ArrayList<JsonObject>();
        for (JsonObject file : f.index().getJsonObjects("files")) {
            if (canonical.equals(file.asString("url"))) {
                if (version != null && version.equals(file.asString("version"))) {
                    return this.load("package", file.asString("filename"));
                }
                if (version == null) {
                    matches.add(file);
                }
            }
            if (matches.size() <= 0) continue;
            if (matches.size() == 1) {
                return this.load("package", ((JsonObject)matches.get(0)).asString("filename"));
            }
            Collections.sort(matches, new IndexVersionSorter());
            return this.load("package", ((JsonObject)matches.get(matches.size() - 1)).asString("filename"));
        }
        return null;
    }

    public InputStream load(String file) throws IOException {
        return this.load("package", file);
    }

    public InputStream load(String folder, String file) throws IOException {
        NpmPackageFolder f = this.folders.get(folder);
        if (f == null) {
            f = this.folders.get(Utilities.path("package", folder));
        }
        if (f != null && f.hasFile(file)) {
            return new ByteArrayInputStream(f.fetchFile(file));
        }
        throw new IOException("Unable to find the file " + folder + "/" + file + " in the package " + this.name());
    }

    public ByteProvider getProvider(String folder, String file) throws IOException {
        NpmPackageFolder f = this.folders.get(folder);
        if (f == null) {
            f = this.folders.get(Utilities.path("package", folder));
        }
        if (f != null && f.hasFile(file)) {
            return f.getProvider(file);
        }
        throw new IOException("Unable to find the file " + folder + "/" + file + " in the package " + this.name());
    }

    public boolean hasFile(String folder, String file) throws IOException {
        NpmPackageFolder f = this.folders.get(folder);
        if (f == null) {
            f = this.folders.get(Utilities.path("package", folder));
        }
        return f != null && f.hasFile(file);
    }

    public JsonObject getNpm() {
        return this.npm;
    }

    public void setNpm(JsonObject npm) {
        this.npm = PackageHacker.fixPackageOnLoad(npm);
    }

    public String name() {
        return this.npm.asString("name");
    }

    public String id() {
        return this.npm.asString("name");
    }

    public String date() {
        return this.npm.asString("date");
    }

    public String canonical() {
        return this.npm.asString("canonical");
    }

    public String version() {
        return this.npm.asString("version");
    }

    public String fhirVersion() {
        JsonArray e;
        if ("hl7.fhir.core".equals(this.npm.asString("name"))) {
            return this.npm.asString("version");
        }
        if (Utilities.existsInList(this.npm.asString("type"), "fhir.core", "fhir.examples") && Utilities.startsWithInList(this.npm.asString("name"), "hl7.fhir.r2.", "hl7.fhir.r2b.", "hl7.fhir.r3.", "hl7.fhir.r4.", "hl7.fhir.r4b.", "hl7.fhir.r5.")) {
            return this.npm.asString("version");
        }
        JsonObject dep = null;
        if (this.npm.hasObject("dependencies") && (dep = this.npm.getJsonObject("dependencies")) != null) {
            for (JsonProperty e2 : dep.getProperties()) {
                if (Utilities.existsInList(e2.getName(), "hl7.fhir.r2.core", "hl7.fhir.r2b.core", "hl7.fhir.r3.core", "hl7.fhir.r4.core")) {
                    return e2.getValue().asString();
                }
                if (!Utilities.existsInList(e2.getName(), "hl7.fhir.core")) continue;
                return e2.getValue().asString();
            }
        }
        if (this.npm.hasArray("fhirVersions") && (e = this.npm.getJsonArray("fhirVersions")).size() > 0) {
            return e.getItems().get(0).asString();
        }
        if (dep != null) {
            if (dep.has("simplifier.core.r4")) {
                return "4.0";
            }
            if (dep.has("simplifier.core.r3")) {
                return "3.0";
            }
            if (dep.has("simplifier.core.r2")) {
                return "2.0";
            }
        }
        throw new FHIRException("no core dependency or FHIR Version found in the Package definition");
    }

    public String summary() {
        if (this.path != null) {
            return this.path;
        }
        return "memory";
    }

    public boolean isType(PackageGenerator.PackageType template) {
        return template.getCode().equals(this.type()) || template.getOldCode().equals(this.type());
    }

    public String type() {
        return this.npm.asString("type");
    }

    public String description() {
        return this.npm.asString("description");
    }

    public String getPath() {
        return this.path;
    }

    public List<String> dependencies() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.npm.has("dependencies")) {
            for (JsonProperty e : this.npm.getJsonObject("dependencies").getProperties()) {
                res.add(e.getName() + "#" + e.getValue().asString());
            }
        }
        return res;
    }

    public String homepage() {
        return this.npm.asString("homepage");
    }

    public String url() {
        return this.npm.asString("url");
    }

    public String title() {
        return this.npm.asString("title");
    }

    public String toolsVersion() {
        return this.npm.asString("tools-version");
    }

    public String license() {
        return this.npm.asString("license");
    }

    public String getWebLocation() {
        if (this.npm.hasPrimitive("url")) {
            return PackageHacker.fixPackageUrl(this.npm.asString("url"));
        }
        return this.npm.asString("canonical");
    }

    public InputStream loadResource(String type, String id) throws IOException {
        NpmPackageFolder f = this.folders.get("package");
        JsonArray files = f.index().getJsonArray("files");
        for (JsonElement e : files.getItems()) {
            JsonObject i = (JsonObject)e;
            if (!type.equals(i.asString("resourceType")) || !id.equals(i.asString("id"))) continue;
            return this.load("package", i.asString("filename"));
        }
        return null;
    }

    public InputStream loadExampleResource(String type, String id) throws IOException {
        NpmPackageFolder f = this.folders.get("example");
        if (f == null) {
            f = this.folders.get("package/example");
        }
        if (f == null) {
            f = this.folders.get("package\\example");
        }
        if (f != null) {
            JsonArray files = f.index().getJsonArray("files");
            for (JsonElement e : files.getItems()) {
                JsonObject i = (JsonObject)e;
                if (!type.equals(i.asString("resourceType")) || !id.equals(i.asString("id"))) continue;
                return this.load("example", i.asString("filename"));
            }
        }
        return null;
    }

    public Map<String, NpmPackageFolder> getFolders() {
        return this.folders;
    }

    public void save(File directory) throws IOException {
        assert (!this.minimalMemory);
        File dir = ManagedFileAccess.file(Utilities.path(directory.getAbsolutePath(), this.name()));
        if (!dir.exists()) {
            FileUtilities.createDirectory(dir.getAbsolutePath());
        } else {
            FileUtilities.clearDirectory(dir.getAbsolutePath(), new String[0]);
        }
        for (NpmPackageFolder folder : this.folders.values()) {
            String n = folder.folderName;
            File pd = ManagedFileAccess.file(Utilities.path(dir.getAbsolutePath(), n));
            if (!pd.exists()) {
                FileUtilities.createDirectory(pd.getAbsolutePath());
            }
            NpmPackageIndexBuilder indexer = new NpmPackageIndexBuilder();
            indexer.start(Utilities.path(dir.getAbsolutePath(), n, ".index.db"));
            for (String s : folder.content.keySet()) {
                byte[] b = folder.content.get(s);
                indexer.seeFile(s, b);
                if (s.equals(".index.json") || s.equals("package.json")) continue;
                FileUtilities.bytesToFile(b, Utilities.path(dir.getAbsolutePath(), n, s));
            }
            byte[] cnt = indexer.build().getBytes(StandardCharsets.UTF_8);
            FileUtilities.bytesToFile(cnt, Utilities.path(dir.getAbsolutePath(), n, ".index.json"));
        }
        byte[] cnt = FileUtilities.stringToBytes(JsonParser.compose((JsonElement)this.npm, true));
        FileUtilities.bytesToFile(cnt, Utilities.path(dir.getAbsolutePath(), "package", "package.json"));
    }

    public void save(OutputStream stream) throws IOException {
        assert (!this.minimalMemory);
        GzipParameters gp = new GzipParameters();
        gp.setCompressionLevel(9);
        GzipCompressorOutputStream gzipOutputStream = new GzipCompressorOutputStream(stream, gp);
        TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)gzipOutputStream);
        for (NpmPackageFolder folder : this.folders.values()) {
            Object n = folder.folderName;
            if (!("package".equals(n) || ((String)n).startsWith("package/") || ((String)n).startsWith("package\\"))) {
                n = "package/" + (String)n;
            }
            NpmPackageIndexBuilder indexer = new NpmPackageIndexBuilder();
            String filename = Utilities.path("[tmp]", "tmp-" + String.valueOf(UUID.randomUUID()) + ".db");
            indexer.start(filename);
            for (String s : folder.content.keySet()) {
                byte[] b = folder.content.get(s);
                String name = (String)n + "/" + s;
                if (b == null) {
                    log.warn(name + " is null");
                    continue;
                }
                indexer.seeFile(s, b);
                if (s.equals(".index.json") || s.equals(".index.db") || s.equals("package.json")) continue;
                TarArchiveEntry entry = new TarArchiveEntry(name);
                entry.setSize((long)b.length);
                tar.putArchiveEntry(entry);
                tar.write(b);
                tar.closeArchiveEntry();
            }
            byte[] cnt = indexer.build().getBytes(StandardCharsets.UTF_8);
            TarArchiveEntry entry = new TarArchiveEntry((String)n + "/.index.json");
            entry.setSize((long)cnt.length);
            tar.putArchiveEntry(entry);
            tar.write(cnt);
            tar.closeArchiveEntry();
            File file = ManagedFileAccess.file(filename);
            if (!file.exists()) continue;
            cnt = FileUtilities.fileToBytes(file);
            file.delete();
            entry = new TarArchiveEntry((String)n + "/.index.db");
            entry.setSize((long)cnt.length);
            tar.putArchiveEntry(entry);
            tar.write(cnt);
            tar.closeArchiveEntry();
        }
        byte[] cnt = FileUtilities.stringToBytes(JsonParser.compose((JsonElement)this.npm, true));
        TarArchiveEntry entry = new TarArchiveEntry("package/package.json");
        entry.setSize((long)cnt.length);
        tar.putArchiveEntry(entry);
        tar.write(cnt);
        tar.closeArchiveEntry();
        tar.finish();
        tar.close();
        gzipOutputStream.close();
    }

    public Map<String, List<String>> getTypes() {
        return this.folders.get((Object)"package").types;
    }

    public String fhirVersionList() {
        if (this.npm.has("fhirVersions")) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            if (this.npm.hasArray("fhirVersions")) {
                for (String n : this.npm.getJsonArray("fhirVersions").asStrings()) {
                    b.append(n);
                }
            }
            if (this.npm.hasPrimitive("fhirVersions")) {
                b.append(this.npm.asString("fhirVersions"));
            }
            return b.toString();
        }
        return "";
    }

    public String dependencySummary() {
        if (this.npm.has("dependencies")) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (JsonProperty e : this.npm.getJsonObject("dependencies").getProperties()) {
                b.append(e.getName() + "#" + e.getValue().asString());
            }
            return b.toString();
        }
        return "";
    }

    public void unPack(String dir) throws IOException {
        this.unPack(dir, false, new ArrayList<String>());
    }

    public void unPackWithAppend(String dir, List<String> files) throws IOException {
        this.unPack(dir, true, files);
    }

    public void unPack(String dir, boolean withAppend) throws IOException {
        this.unPack(dir, withAppend, new ArrayList<String>());
    }

    public void unPack(String dir, boolean withAppend, List<String> files) throws IOException {
        assert (!this.minimalMemory);
        for (NpmPackageFolder folder : this.folders.values()) {
            String dn = folder.getFolderName();
            if (!dn.equals("package") && (dn.startsWith("package/") || dn.startsWith("package\\"))) {
                dn = dn.substring(8);
            }
            dn = dn.equals("$root") ? dir : Utilities.path(dir, dn);
            FileUtilities.createDirectory(dn);
            for (String s : folder.listFiles()) {
                String fn = Utilities.path(dn, s);
                File f = ManagedFileAccess.file(fn);
                if (withAppend && f.getName().startsWith("_append.")) {
                    String appendFn = Utilities.path(dn, s.substring(8));
                    f = ManagedFileAccess.file(appendFn);
                    files.add(f.getAbsolutePath());
                    if (f.exists()) {
                        FileUtilities.appendBytesToFile(folder.fetchFile(s), appendFn);
                    } else {
                        FileUtilities.bytesToFile(folder.fetchFile(s), appendFn);
                    }
                } else {
                    files.add(f.getAbsolutePath());
                }
                FileUtilities.bytesToFile(folder.fetchFile(s), fn);
            }
        }
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(keys);
        Collections.sort(res);
        return res;
    }

    public void clearFolder(String folderName) {
        NpmPackageFolder folder = this.folders.get(folderName);
        folder.content.clear();
        folder.types.clear();
    }

    public void deleteFolder(String folderName) {
        this.folders.remove(folderName);
    }

    public void addFile(String folderName, String name, byte[] cnt, String type) {
        assert (!this.minimalMemory);
        if (!this.folders.containsKey(folderName)) {
            this.folders.put(folderName, new NpmPackageFolder(folderName));
        }
        NpmPackageFolder folder = this.folders.get(folderName);
        folder.content.put(name, cnt);
        if (!folder.types.containsKey(type)) {
            folder.types.put(type, new ArrayList());
        }
        folder.types.get(type).add(name);
        if ("package".equals(folderName) && "package.json".equals(name)) {
            try {
                this.npm = PackageHacker.fixPackageOnLoad(JsonParser.parseObject(cnt));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void loadAllFiles() throws IOException {
        for (String folder : this.folders.keySet()) {
            NpmPackageFolder pf = this.folders.get(folder);
            String p = folder.contains("$") ? this.path : Utilities.path(this.path, folder);
            File file = ManagedFileAccess.file(p);
            if (!file.exists()) continue;
            for (File f : file.listFiles()) {
                if (f.isDirectory() || NpmPackage.isInternalExemptFile(f)) continue;
                pf.getContent().put(f.getName(), FileUtilities.fileToBytes(f));
            }
        }
    }

    public void loadAllFiles(ITransformingLoader loader) throws IOException {
        for (String folder : this.folders.keySet()) {
            NpmPackageFolder pf = this.folders.get(folder);
            String p = folder.contains("$") ? this.path : Utilities.path(this.path, folder);
            for (File f : ManagedFileAccess.file(p).listFiles()) {
                if (f.isDirectory() || NpmPackage.isInternalExemptFile(f)) continue;
                pf.getContent().put(f.getName(), loader.load(f));
            }
        }
    }

    public boolean isChangedByLoader() {
        return this.changedByLoader;
    }

    public boolean isCore() {
        return Utilities.existsInList(this.npm.asString("type"), "fhir.core", "Core");
    }

    public boolean isCoreExamples() {
        return this.name().startsWith("hl7.fhir.r") && this.name().endsWith(".examples");
    }

    public boolean isTx() {
        return this.npm.asString("name").startsWith("hl7.terminology");
    }

    public boolean hasCanonical(String url) throws IOException {
        if (url == null) {
            return false;
        }
        String u = url.contains("|") ? url.substring(0, url.indexOf("|")) : url;
        String v = url.contains("|") ? url.substring(url.indexOf("|") + 1) : null;
        NpmPackageFolder folder = this.folders.get("package");
        if (folder != null) {
            for (JsonObject o : folder.index().getJsonObjects("files")) {
                if (!u.equals(o.asString("url")) || v != null && !v.equals(o.asString("version"))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canLazyLoad() throws IOException {
        for (NpmPackageFolder folder : this.folders.values()) {
            if (folder.folder != null) continue;
            return false;
        }
        if (Utilities.existsInList(this.name(), "fhir.test.data.r2", "fhir.test.data.r3", "fhir.test.data.r4", "fhir.tx.support.r2", "fhir.tx.support.r3", "fhir.tx.support.r4", "us.nlm.vsac")) {
            return true;
        }
        if (this.npm.asBoolean("lazy-load")) {
            return true;
        }
        return this.hasFile("other", "spec.internals") || this.folders.get((Object)"package").cachedIndex != null;
    }

    public boolean isNotForPublication() {
        return this.npm.asBoolean("notForPublication");
    }

    public InputStream load(PackageResourceInformation p) throws IOException {
        if (p.filename.startsWith("@")) {
            String[] pl = p.filename.substring(1).split("\\/");
            return new ByteArrayInputStream(this.folders.get((Object)pl[0]).content.get(pl[1]));
        }
        return ManagedFileAccess.inStream(p.filename);
    }

    public Date dateAsDate() {
        try {
            String d = this.date();
            if (d == null) {
                switch (this.name()) {
                    case "hl7.fhir.r2.core": {
                        d = "20151024000000";
                        break;
                    }
                    case "hl7.fhir.r2b.core": {
                        d = "20160330000000";
                        break;
                    }
                    case "hl7.fhir.r3.core": {
                        d = "20191024000000";
                        break;
                    }
                    case "hl7.fhir.r4.core": {
                        d = "20191030000000";
                        break;
                    }
                    case "hl7.fhir.r4b.core": {
                        d = "202112200000000";
                        break;
                    }
                    case "hl7.fhir.r5.core": {
                        d = "20211219000000";
                        break;
                    }
                    default: {
                        return new Date();
                    }
                }
            }
            return new SimpleDateFormat("yyyyMMddHHmmss").parse(d);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static NpmPackage fromUrl(String source) throws IOException {
        HTTPResult res = ManagedWebAccess.get(Arrays.asList("npm-package", "fhir-package"), source + "?nocache=" + System.currentTimeMillis());
        res.checkThrowException();
        return NpmPackage.fromPackage(new ByteArrayInputStream(res.getContent()));
    }

    public String toString() {
        return "NpmPackage " + this.name() + "#" + this.version() + " [path=" + this.path + "]";
    }

    public String getFilePath(String d) throws IOException {
        return Utilities.path(this.path, "package", d);
    }

    public boolean isMinimalMemory() {
        return this.minimalMemory;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isWarned() {
        return this.warned;
    }

    public void setWarned(boolean warned) {
        this.warned = warned;
    }

    public String vid() {
        return this.id() + "#" + this.version();
    }

    public static boolean isLoadCustomResources() {
        return loadCustomResources;
    }

    public static void setLoadCustomResources(boolean loadCustomResources) {
        NpmPackage.loadCustomResources = loadCustomResources;
    }

    public LocalDate dateAsLocalDate() {
        String date = this.date();
        String d = date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
        return LocalDate.parse(d);
    }

    public class NpmPackageFolder {
        private final String folderName;
        private Map<String, List<String>> types;
        private Map<String, byte[]> content;
        private JsonObject cachedIndex;
        private File folder;

        public NpmPackageFolder(String folderName) {
            this.folderName = folderName;
            if (!NpmPackage.this.minimalMemory) {
                this.types = new HashMap<String, List<String>>();
                this.content = new HashMap<String, byte[]>();
            }
        }

        private String fn(String name) throws IOException {
            return Utilities.path(this.folder.getAbsolutePath(), name);
        }

        public Map<String, List<String>> getTypes() throws JsonException, IOException {
            if (NpmPackage.this.minimalMemory) {
                HashMap<String, List<String>> typeMap = new HashMap<String, List<String>>();
                this.readIndex(JsonParser.parseObjectFromFile(this.fn(".index.json")), typeMap);
                return typeMap;
            }
            return this.types;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public String getFolderPath() {
            return this.folder == null ? null : this.folder.getAbsolutePath();
        }

        public boolean readIndex(JsonObject index, Map<String, List<String>> typeMap) {
            if (!index.has("index-version") || index.asInteger("index-version") != NpmPackageIndexBuilder.CURRENT_INDEX_VERSION) {
                return false;
            }
            if (!NpmPackage.this.minimalMemory) {
                this.cachedIndex = index;
            }
            for (JsonObject file : index.getJsonObjects("files")) {
                String type = file.asString("resourceType");
                String name = file.asString("filename");
                if (!typeMap.containsKey(type)) {
                    typeMap.put(type, new ArrayList());
                }
                typeMap.get(type).add(name);
            }
            return true;
        }

        public List<String> listFiles() {
            ArrayList<String> res = new ArrayList<String>();
            if (this.folder != null) {
                if (this.folder.exists()) {
                    for (File f : this.folder.listFiles()) {
                        if (f.isDirectory() || Utilities.existsInList(f.getName(), "package.json", ".index.json", ".index.db", ".oids.json", ".oids.db")) continue;
                        res.add(f.getName());
                    }
                }
            } else {
                for (String s : this.content.keySet()) {
                    if (Utilities.existsInList(s, "package.json", ".index.json", ".index.db", ".oids.json", ".oids.db")) continue;
                    res.add(s);
                }
            }
            Collections.sort(res);
            return res;
        }

        public Map<String, byte[]> getContent() {
            assert (!NpmPackage.this.minimalMemory);
            return this.content;
        }

        public byte[] fetchFile(String file) throws IOException {
            if (this.folder != null) {
                File f = ManagedFileAccess.file(Utilities.path(this.folder.getAbsolutePath(), file));
                if (f.exists()) {
                    return FileUtilities.fileToBytes(f);
                }
                return null;
            }
            return this.content.get(file);
        }

        public ByteProvider getProvider(String file) throws IOException {
            if (this.folder != null) {
                File f = ManagedFileAccess.file(Utilities.path(this.folder.getAbsolutePath(), file));
                if (f.exists()) {
                    return ByteProvider.forFile(f);
                }
                return null;
            }
            return ByteProvider.forBytes(this.content.get(file));
        }

        public boolean hasFile(String file) throws IOException {
            if (this.folder != null) {
                return ManagedFileAccess.file(Utilities.path(this.folder.getAbsolutePath(), file)).exists();
            }
            return this.content.containsKey(file);
        }

        public String dump() {
            return this.folderName + " (" + (this.folder == null ? "null" : this.folder.toString()) + ")" + (String)(NpmPackage.this.minimalMemory ? "" : " | " + (this.cachedIndex != null) + " | " + this.content.size() + " | " + this.types.size());
        }

        public void removeFile(String n) throws IOException {
            if (this.folder != null) {
                ManagedFileAccess.file(Utilities.path(this.folder.getAbsolutePath(), n)).delete();
            } else {
                this.content.remove(n);
            }
            NpmPackage.this.changedByLoader = true;
        }

        public JsonObject index() throws IOException {
            if (this.cachedIndex != null) {
                return this.cachedIndex;
            }
            if (this.folder == null) {
                return null;
            }
            File ij = ManagedFileAccess.file(this.fn(".index.json"));
            if (ij.exists()) {
                return JsonParser.parseObject(ij);
            }
            return null;
        }

        public JsonObject oidIndex() throws IOException {
            if (this.folder == null) {
                return null;
            }
            File ij = ManagedFileAccess.file(this.fn(".oids.json"));
            if (ij.exists()) {
                return JsonParser.parseObject(ij);
            }
            return null;
        }
    }

    public static class PackagedResourceFile {
        private final String folder;
        private final String filename;
        private final String resourceType;

        protected PackagedResourceFile(String folder, String filename, String resourceType) {
            this.folder = folder;
            this.filename = filename;
            this.resourceType = resourceType;
        }

        public String getFolder() {
            return this.folder;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public static class Sorter
        implements Comparator<PackagedResourceFile> {
            @Override
            public int compare(PackagedResourceFile o1, PackagedResourceFile o2) {
                int res = o1.folder.compareTo(o2.folder);
                if (res == 0) {
                    res = o1.filename.compareTo(o2.filename);
                }
                return res;
            }
        }
    }

    public class PackageResourceInformation {
        private final String id;
        private final String resourceType;
        private final String url;
        private final String version;
        private final String filename;
        private final String supplements;
        private final String stype;
        private final String derivation;
        private final String content;

        public PackageResourceInformation(String root, JsonObject fi) throws IOException {
            this.id = fi.asString("id");
            this.resourceType = fi.asString("resourceType");
            this.url = fi.asString("url");
            this.version = fi.asString("version");
            this.filename = Utilities.path(root, fi.asString("filename"));
            this.supplements = fi.asString("supplements");
            this.stype = fi.asString("type");
            this.derivation = fi.asString("derivation");
            this.content = fi.asString("content");
        }

        public String getId() {
            return this.id;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getStatedType() {
            return this.stype;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getSupplements() {
            return this.supplements;
        }

        public boolean hasId() {
            return !Utilities.noString(this.id);
        }

        public String getDerivation() {
            return this.derivation;
        }

        public String getContent() {
            return this.content;
        }
    }

    public class IndexVersionSorter
    implements Comparator<JsonObject> {
        @Override
        public int compare(JsonObject o0, JsonObject o1) {
            String v0 = o0.asString("version");
            String v1 = o1.asString("version");
            return v0.compareTo(v1);
        }
    }

    public static interface ITransformingLoader {
        public byte[] load(File var1);
    }

    public class PackageResourceInformationSorter
    implements Comparator<PackageResourceInformation> {
        @Override
        public int compare(PackageResourceInformation o1, PackageResourceInformation o2) {
            return o1.filename.compareTo(o2.filename);
        }
    }
}

