/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CIBuildClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CIBuildClient.class);
    private static final String DEFAULT_ROOT_URL = "https://build.fhir.org";
    private static final long DEFAULT_CI_QUERY_INTERVAL = 3600000L;
    private final long ciQueryInterval;
    private long ciLastQueriedTimeStamp = 0L;
    private JsonArray ciBuildInfo;
    private final String rootUrl;
    private final Map<String, String> ciPackageUrls = new HashMap<String, String>();

    public CIBuildClient() {
        this(DEFAULT_ROOT_URL, 3600000L, false);
    }

    public CIBuildClient(String rootUrl, long ciQueryInterval, boolean silent) {
        this.rootUrl = rootUrl;
        this.ciQueryInterval = ciQueryInterval;
    }

    String getPackageId(String canonical) {
        if (canonical == null) {
            return null;
        }
        this.checkCIServerQueried();
        if (this.ciBuildInfo != null) {
            JsonObject o;
            for (JsonElement n : this.ciBuildInfo) {
                o = (JsonObject)n;
                if (!canonical.equals(o.asString("url"))) continue;
                return o.asString("package-id");
            }
            for (JsonElement n : this.ciBuildInfo) {
                o = (JsonObject)n;
                if (!o.asString("url").startsWith(canonical + "/ImplementationGuide/")) continue;
                return o.asString("package-id");
            }
        }
        return null;
    }

    String getPackageUrl(String packageId) {
        this.checkCIServerQueried();
        for (JsonObject o : this.ciBuildInfo.asJsonObjects()) {
            if (!packageId.equals(o.asString("package-id"))) continue;
            return o.asString("url");
        }
        return null;
    }

    public boolean isCurrent(String id, NpmPackage npmPackage) throws IOException {
        this.checkCIServerQueried();
        String packageManifestUrl = this.ciPackageUrls.get(id);
        JsonObject packageManifestJson = JsonParser.parseObjectFromUrl(Utilities.pathURL(packageManifestUrl, "package.manifest.json"));
        String currentDate = packageManifestJson.asString("date");
        String packageDate = npmPackage.date();
        return currentDate.equals(packageDate);
    }

    BasePackageCacheManager.InputStreamWithSrc loadFromCIBuild(String id, String branch) {
        this.checkCIServerQueried();
        if (this.ciPackageUrls.containsKey(id)) {
            String packageBaseUrl = this.ciPackageUrls.get(id);
            if (branch == null) {
                InputStream stream;
                try {
                    stream = this.fetchFromUrlSpecific(Utilities.pathURL(packageBaseUrl, "package.tgz"));
                }
                catch (Exception e) {
                    stream = this.fetchFromUrlSpecific(Utilities.pathURL(packageBaseUrl, "branches", "main", "package.tgz"));
                }
                return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL(packageBaseUrl, "package.tgz"), "current");
            }
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL(packageBaseUrl, "branches", branch, "package.tgz"));
            return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL(packageBaseUrl, "branches", branch, "package.tgz"), "current$" + branch);
        }
        if (id.startsWith("hl7.fhir.r6")) {
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL(this.rootUrl, id + ".tgz"));
            return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL(this.rootUrl, id + ".tgz"), "current");
        }
        if (Utilities.endsWithInList(id, ".r3", ".r4", ".r4b", ".r5", ".r6")) {
            String npid = id.substring(0, id.lastIndexOf("."));
            String url = this.ciPackageUrls.get(npid);
            if (url == null) {
                throw new FHIRException("The package '" + id + "' has no entry on the current build server (" + String.valueOf(this.ciPackageUrls) + ")");
            }
            url = Utilities.pathURL(url, id + ".tgz");
            InputStream stream = this.fetchFromUrlSpecific(url);
            return new BasePackageCacheManager.InputStreamWithSrc(stream, url, "current");
        }
        throw new FHIRException("The package '" + id + "' has no entry on the current build server (" + String.valueOf(this.ciPackageUrls) + ")");
    }

    private InputStream fetchFromUrlSpecific(String source) throws FHIRException {
        try {
            HTTPResult res = ManagedWebAccess.get(Arrays.asList("web"), source);
            res.checkThrowException();
            return new ByteArrayInputStream(res.getContent());
        }
        catch (Exception e) {
            throw new FHIRException("Unable to fetch: " + e.getMessage(), e);
        }
    }

    private void checkCIServerQueried() {
        if (System.currentTimeMillis() - this.ciLastQueriedTimeStamp > this.ciQueryInterval) {
            try {
                this.updateFromCIServer();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    this.updateFromCIServer();
                }
                catch (Exception e2) {
                    log.debug("Error connecting to build server - running without build (" + e2.getMessage() + ")");
                }
            }
        }
    }

    private void updateFromCIServer() throws IOException {
        HTTPResult res = ManagedWebAccess.get(Arrays.asList("web"), this.rootUrl + "/ig/qas.json?nocache=" + System.currentTimeMillis());
        res.checkThrowException();
        this.ciBuildInfo = (JsonArray)JsonParser.parse(FileUtilities.bytesToString(res.getContent()));
        ArrayList<BuildRecord> builds = new ArrayList<BuildRecord>();
        for (JsonElement n : this.ciBuildInfo) {
            JsonObject j = (JsonObject)n;
            if (!j.has("url") || !j.has("package-id") || !j.asString("package-id").contains(".")) continue;
            String packageUrl = j.asString("url");
            if (packageUrl.contains("/ImplementationGuide/")) {
                packageUrl = packageUrl.substring(0, packageUrl.indexOf("/ImplementationGuide/"));
            }
            builds.add(new BuildRecord(packageUrl, j.asString("package-id"), this.getRepo(j.asString("repo")), this.readDate(j.asString("date"))));
        }
        Collections.sort(builds, new BuildRecordSorter());
        for (BuildRecord build : builds) {
            if (this.ciPackageUrls.containsKey(build.getPackageId())) continue;
            this.ciPackageUrls.put(build.getPackageId(), this.rootUrl + "/ig/" + build.getRepo());
        }
        this.ciLastQueriedTimeStamp = System.currentTimeMillis();
    }

    private String getRepo(String path) {
        String[] p = path.split("/");
        return p[0] + "/" + p[1];
    }

    private Date readDate(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM, yyyy HH:mm:ss Z", new Locale("en", "US"));
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    @Generated
    public long getCiLastQueriedTimeStamp() {
        return this.ciLastQueriedTimeStamp;
    }

    @Generated
    public JsonArray getCiBuildInfo() {
        return this.ciBuildInfo;
    }

    @Generated
    public String getRootUrl() {
        return this.rootUrl;
    }

    public static class BuildRecord {
        private final String url;
        private final String packageId;
        private final String repo;
        private final Date date;

        public BuildRecord(String url, String packageId, String repo, Date date) {
            this.url = url;
            this.packageId = packageId;
            this.repo = repo;
            this.date = date;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPackageId() {
            return this.packageId;
        }

        public String getRepo() {
            return this.repo;
        }

        public Date getDate() {
            return this.date;
        }
    }

    public static class BuildRecordSorter
    implements Comparator<BuildRecord> {
        @Override
        public int compare(BuildRecord arg0, BuildRecord arg1) {
            return arg1.date.compareTo(arg0.date);
        }
    }
}

