/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.IPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.PackageClient;
import org.hl7.fhir.utilities.npm.PackageInfo;
import org.hl7.fhir.utilities.npm.PackageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePackageCacheManager
implements IPackageCacheManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasePackageCacheManager.class);
    protected final List<PackageServer> myPackageServers;
    private Function<PackageServer, PackageClient> myClientFactory = server -> new PackageClient((PackageServer)server);

    public BasePackageCacheManager() {
        this.myPackageServers = new ArrayList<PackageServer>();
    }

    protected BasePackageCacheManager(@Nonnull List<PackageServer> thePackageServers) {
        this.myPackageServers = thePackageServers;
    }

    public void setClientFactory(Function<PackageServer, PackageClient> theClientFactory) {
        Validate.notNull(theClientFactory, (String)"theClientFactory must not be null", (Object[])new Object[0]);
        this.myClientFactory = theClientFactory;
    }

    public List<PackageServer> getPackageServers() {
        return this.myPackageServers;
    }

    public void addPackageServer(@Nonnull PackageServer thePackageServer) {
        Validate.notNull((Object)thePackageServer, (String)"thePackageServer must not be null or empty", (Object[])new Object[0]);
        if (!this.myPackageServers.contains(thePackageServer)) {
            this.myPackageServers.add(thePackageServer);
        }
    }

    public NpmPackage loadPackageFromCacheOnly(String id) throws IOException {
        return this.loadPackageFromCacheOnly(id, null);
    }

    @Nullable
    protected InputStreamWithSrc loadFromPackageServer(String id, String version) {
        for (PackageServer nextPackageServer : this.getPackageServers()) {
            if (!this.okToUsePackageServer(nextPackageServer.getUrl(), id)) continue;
            PackageClient packageClient = this.myClientFactory.apply(nextPackageServer);
            try {
                if (Utilities.noString(version)) {
                    version = packageClient.getLatestVersion(id, false);
                }
                if (VersionUtilities.versionHasWildcards(version) && (version = packageClient.getLatestVersion(id, version)) == null) {
                    return null;
                }
                InputStream stream = packageClient.fetch(id, version);
                String url = packageClient.url(id, version);
                return new InputStreamWithSrc(stream, url, version);
            }
            catch (IOException e) {
                log.debug("Failed to resolve package {}#{} from server: {} ({})", new Object[]{id, version, nextPackageServer, e.getMessage()});
            }
        }
        return null;
    }

    private boolean okToUsePackageServer(String server, String id) {
        return !"https://packages2.fhir.org/packages".equals(server) || !"hl7.fhir.r2b.core".equals(id);
    }

    public abstract NpmPackage loadPackageFromCacheOnly(String var1, @Nullable String var2) throws IOException;

    @Override
    public String getPackageUrl(String packageId) throws IOException {
        packageId = this.stripAlias(packageId);
        String result = null;
        NpmPackage npm = this.loadPackageFromCacheOnly(packageId);
        if (npm != null) {
            return npm.canonical();
        }
        for (PackageServer nextPackageServer : this.getPackageServers()) {
            result = this.getPackageUrl(packageId, nextPackageServer);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private String getPackageUrl(String packageId, PackageServer server) throws IOException {
        PackageClient pc = this.myClientFactory.apply(server);
        List<PackageInfo> res = pc.search(packageId, null, null, false);
        if (res.size() == 0) {
            return null;
        }
        return res.get(0).getUrl();
    }

    @Override
    public String getPackageId(String canonicalUrl) throws IOException {
        PackageServer nextPackageServer;
        String result = null;
        Iterator<PackageServer> iterator = this.getPackageServers().iterator();
        while (iterator.hasNext() && (result = this.getPackageId(canonicalUrl, nextPackageServer = iterator.next())) == null) {
        }
        return result;
    }

    private String getPackageId(String canonical, PackageServer server) throws IOException {
        if (canonical == null) {
            return null;
        }
        PackageClient pc = this.myClientFactory.apply(server);
        List<PackageInfo> res = pc.search(null, canonical, null, false);
        if (res.size() == 0) {
            return null;
        }
        for (PackageInfo pi : res) {
            if (!canonical.equals(pi.getCanonical())) continue;
            return pi.getId();
        }
        return res.get(0).getId();
    }

    @Override
    public NpmPackage loadPackage(String idAndVer) throws FHIRException, IOException {
        idAndVer = this.stripAlias(idAndVer);
        return this.loadPackage(idAndVer, null);
    }

    protected String stripAlias(String id) {
        if (id != null && id.contains("@npm:")) {
            return id.substring(id.indexOf("@npm:") + 5);
        }
        return id;
    }

    public static class InputStreamWithSrc {
        public InputStream stream;
        public String url;
        public String version;

        public InputStreamWithSrc(InputStream stream, String url, String version) {
            this.stream = stream;
            this.url = url;
            this.version = version;
        }
    }
}

