/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import com.ibm.icu.text.PluralRules;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class I18nBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(I18nBase.class);
    public static final String KEY_DELIMITER = "_";
    public static final Map<Locale, Set<String>> uncontainedKeys = new HashMap<Locale, Set<String>>();
    private Locale locale = null;
    private ResourceBundle messages = null;
    private PluralRules pluralRules = null;
    private boolean warnAboutMissingMessages = true;
    private static Set<String> warnedLocales;

    public Locale getLocale() {
        if (Objects.nonNull(this.locale)) {
            return this.locale;
        }
        this.setLocale(Locale.getDefault());
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.messages = null;
        this.pluralRules = null;
    }

    private void checkResourceBundleIsLoaded() {
        if (this.messages == null) {
            Locale locale = this.getLocale();
            this.messages = ResourceBundle.getBundle(this.getMessagesSourceFileName(), locale);
            this.warnIfUnknownLocale(locale);
        }
    }

    private void warnIfUnknownLocale(@Nonnull Locale locale) {
        if (Locale.ROOT == this.messages.getLocale() && !locale.getLanguage().equals("en")) {
            if (warnedLocales == null) {
                warnedLocales = new HashSet<String>();
            }
            if (!warnedLocales.contains(locale.toLanguageTag())) {
                this.logUncontainedMessage("The locale " + locale.toLanguageTag() + " is not supported. Messages will default to en-US.");
                warnedLocales.add(locale.toLanguageTag());
            }
        }
    }

    protected ResourceBundle getMessages() {
        this.checkResourceBundleIsLoaded();
        return this.messages;
    }

    private void checkPluralRulesAreLoaded() {
        if (this.pluralRules == null) {
            this.setPluralRules(this.getMessages().getLocale());
        }
    }

    protected PluralRules getPluralRules() {
        this.checkPluralRulesAreLoaded();
        return this.pluralRules;
    }

    private boolean messageExistsForLocale(String message, boolean hasArgs) {
        Set uncontainedKeys;
        this.checkResourceBundleIsLoaded();
        if (!(this.messageKeyExistsForLocale(message) || message.contains(" ") || !this.warnAboutMissingMessages || !hasArgs && message.contains(" ") || (uncontainedKeys = I18nBase.uncontainedKeys.computeIfAbsent(this.getLocale(), k -> new HashSet())).contains(message))) {
            this.logUncontainedMessage("Attempting to localize " + this.typeOfString() + " " + message + ", but no such equivalent message exists for the locale " + String.valueOf(this.getLocale()));
            uncontainedKeys.add(message);
        }
        return this.messageKeyExistsForLocale(message);
    }

    protected void logUncontainedMessage(String message) {
        log.warn(message);
    }

    protected String typeOfString() {
        return "message";
    }

    protected boolean messageKeyExistsForLocale(String message) {
        return this.messages.containsKey(message);
    }

    public String formatMessage(String theMessage, Object ... theMessageArguments) {
        return this.formatMessageForLocale(theMessage, theMessageArguments);
    }

    protected String getPluralKey(Integer number, String baseKey) {
        return baseKey + KEY_DELIMITER + this.pluralRules.select((double)number.intValue());
    }

    protected Set<String> getPluralKeys(String baseKey) {
        return this.pluralRules.getKeywords().stream().map(entry -> baseKey + KEY_DELIMITER + entry).collect(Collectors.toSet());
    }

    protected Set<String> getPluralSuffixes() {
        return Collections.unmodifiableSet(this.getPluralRules().getKeywords());
    }

    protected String getRootKeyFromPlural(@Nonnull String pluralKey) {
        this.checkPluralRulesAreLoaded();
        for (String keyword : this.pluralRules.getKeywords()) {
            String suffix = KEY_DELIMITER + keyword;
            if (!pluralKey.endsWith(suffix)) continue;
            return pluralKey.substring(0, pluralKey.length() - suffix.length());
        }
        return null;
    }

    private String formatMessageForLocale(String theMessage, Object ... theMessageArguments) {
        String message = theMessage;
        if (this.messageExistsForLocale(theMessage, theMessageArguments != null && theMessageArguments.length > 0)) {
            message = Objects.nonNull(theMessageArguments) && theMessageArguments.length > 0 ? MessageFormat.format(this.messages.getString(theMessage).trim(), theMessageArguments) : MessageFormat.format(this.messages.getString(theMessage).trim(), new Object[]{null});
        }
        return message;
    }

    public String formatMessagePlural(Integer plural, String theMessage, Object ... theMessageArguments) {
        Object[] args = new Object[theMessageArguments.length + 1];
        args[0] = plural;
        for (int i = 0; i < theMessageArguments.length; ++i) {
            args[i + 1] = theMessageArguments[i];
        }
        this.checkPluralRulesAreLoaded();
        String pluralKey = this.getPluralKey(plural, theMessage);
        return this.formatMessageForLocale(pluralKey, args);
    }

    @Deprecated
    public void setValidationMessageLanguage(Locale locale) {
        this.messages = ResourceBundle.getBundle(this.getMessagesSourceFileName(), locale);
        this.pluralRules = null;
    }

    protected String getMessagesSourceFileName() {
        return "Messages";
    }

    private void setPluralRules(Locale locale) {
        this.pluralRules = Locale.ROOT == locale ? PluralRules.forLocale((Locale)Locale.US) : PluralRules.forLocale((Locale)locale);
    }

    public boolean isWarnAboutMissingMessages() {
        return this.warnAboutMissingMessages;
    }

    public void setWarnAboutMissingMessages(boolean warnAboutMissingMessages) {
        this.warnAboutMissingMessages = warnAboutMissingMessages;
    }
}

