/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.http.HTTPAuthenticationMode;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.settings.FhirSettings;

public class SimpleHTTPClient {
    private static final int MAX_REDIRECTS = 5;
    private static int counter = 1;
    private List<HTTPHeader> headers = new ArrayList<HTTPHeader>();
    private HTTPAuthenticationMode authenticationMode;
    private String username;
    private String password;
    private String token;
    private String apiKey;

    public void addHeader(String name, String value) {
        this.headers.add(new HTTPHeader(name, value));
    }

    public HTTPResult get(String url) throws IOException {
        return this.get(url, null);
    }

    public HTTPResult get(String url, String accept) throws IOException {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        URL u = new URL(url);
        HashMap<String, Integer> visited = new HashMap<String, Integer>();
        HttpURLConnection c = null;
        boolean done = false;
        block3: while (!done) {
            int times = visited.compute(url, (key, count) -> count == null ? 1 : count + 1);
            if (times > 5) {
                throw new IOException("Stuck in redirect loop");
            }
            u = new URL(url);
            c = (HttpURLConnection)u.openConnection();
            c.setRequestMethod("GET");
            if (accept != null) {
                c.setRequestProperty("Accept", accept);
            }
            this.setHeaders(c);
            c.setInstanceFollowRedirects(false);
            switch (c.getResponseCode()) {
                case 301: 
                case 302: 
                case 307: 
                case 308: {
                    String location = c.getHeaderField("Location");
                    location = URLDecoder.decode(location, "UTF-8");
                    URL base = new URL(url);
                    URL next = new URL(base, location);
                    url = next.toExternalForm();
                    continue block3;
                }
            }
            done = true;
        }
        return new HTTPResult(url, c.getResponseCode(), c.getResponseMessage(), c.getRequestProperty("Content-Type"), FileUtilities.streamToBytes(c.getResponseCode() >= 400 ? c.getErrorStream() : c.getInputStream()));
    }

    private void setHeaders(HttpURLConnection c) {
        if (this.headers != null) {
            for (HTTPHeader header : this.headers) {
                c.setRequestProperty(header.getName(), header.getValue());
            }
        }
        c.setConnectTimeout(15000);
        c.setReadTimeout(15000);
        this.setAuthenticationHeader(c);
    }

    private void setAuthenticationHeader(HttpURLConnection c) {
        String authHeaderValue = null;
        if (this.authenticationMode == HTTPAuthenticationMode.TOKEN) {
            authHeaderValue = "Bearer " + this.token;
        } else if (this.authenticationMode == HTTPAuthenticationMode.BASIC) {
            String auth = this.username + ":" + this.password;
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            authHeaderValue = "Basic " + new String(encodedAuth);
        } else if (this.authenticationMode == HTTPAuthenticationMode.APIKEY) {
            c.setRequestProperty("Api-Key", this.apiKey);
        }
        if (authHeaderValue != null) {
            c.setRequestProperty("Authorization", authHeaderValue);
        }
    }

    public HTTPResult post(String url, String contentType, byte[] content, String accept) throws IOException {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        URL u = new URL(url);
        HttpURLConnection c = (HttpURLConnection)u.openConnection();
        c.setDoOutput(true);
        c.setDoInput(true);
        c.setRequestMethod("POST");
        c.setRequestProperty("Content-Type", contentType);
        if (accept != null) {
            c.setRequestProperty("Accept", accept);
        }
        this.setHeaders(c);
        c.getOutputStream().write(content);
        c.getOutputStream().close();
        return new HTTPResult(url, c.getResponseCode(), c.getResponseMessage(), c.getRequestProperty("Content-Type"), FileUtilities.streamToBytes(c.getResponseCode() >= 400 ? c.getErrorStream() : c.getInputStream()));
    }

    public HTTPResult put(String url, String contentType, byte[] content, String accept) throws IOException {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        URL u = new URL(url);
        HttpURLConnection c = (HttpURLConnection)u.openConnection();
        c.setDoOutput(true);
        c.setDoInput(true);
        c.setRequestMethod("PUT");
        c.setRequestProperty("Content-type", contentType);
        if (accept != null) {
            c.setRequestProperty("Accept", accept);
        }
        this.setHeaders(c);
        c.getOutputStream().write(content);
        c.getOutputStream().close();
        return new HTTPResult(url, c.getResponseCode(), c.getResponseMessage(), c.getRequestProperty("Content-Type"), FileUtilities.streamToBytes(c.getResponseCode() >= 400 ? c.getErrorStream() : c.getInputStream()));
    }

    public static int nextCounter() {
        return ++counter;
    }

    @Generated
    public HTTPAuthenticationMode getAuthenticationMode() {
        return this.authenticationMode;
    }

    @Generated
    public void setAuthenticationMode(HTTPAuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }
}

