/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import lombok.Generated;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.http.HTTPResultException;
import org.hl7.fhir.utilities.http.SimpleHTTPClient;

public class HTTPResult {
    private final int code;
    private final String contentType;
    private final byte[] content;
    private final String source;
    private final String message;
    private final Iterable<HTTPHeader> headers;

    public HTTPResult(String source, int code, String message, String contentType, byte[] content) {
        this(source, code, message, contentType, content, Collections.emptyList());
    }

    public HTTPResult(String source, int code, String message, String contentType, byte[] content, Iterable<HTTPHeader> headers) {
        this.source = source;
        this.code = code;
        this.contentType = contentType;
        this.content = content;
        this.message = message;
        this.headers = headers;
    }

    public void checkThrowException() throws IOException {
        if (this.code >= 300) {
            if (this.content == null || this.content.length == 0) {
                HTTPResultException exception = new HTTPResultException(this.code, this.message, this.source, null);
                throw new IOException(exception.message, exception);
            }
            String filename = Utilities.path("[tmp]", "http-log", "fhir-http-" + SimpleHTTPClient.nextCounter() + ".log");
            FileUtilities.createDirectory(Utilities.path("[tmp]", "http-log"));
            FileUtilities.bytesToFile(this.content, filename);
            HTTPResultException exception = new HTTPResultException(this.code, this.message, this.source, filename);
            throw new IOException(exception.message, exception);
        }
    }

    public String getContentAsString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public String getMessagefromCode() {
        switch (this.getCode()) {
            case 100: {
                return this.getCode() + " Continue";
            }
            case 101: {
                return this.getCode() + " Switching Protocols";
            }
            case 102: {
                return this.getCode() + " Processing Deprecated";
            }
            case 103: {
                return this.getCode() + " Early Hints";
            }
            case 200: {
                return this.getCode() + " OK";
            }
            case 201: {
                return this.getCode() + " Created";
            }
            case 202: {
                return this.getCode() + " Accepted";
            }
            case 203: {
                return this.getCode() + " Non-Authoritative Information";
            }
            case 204: {
                return this.getCode() + " No Content";
            }
            case 205: {
                return this.getCode() + " Reset Content";
            }
            case 206: {
                return this.getCode() + " Partial Content";
            }
            case 207: {
                return this.getCode() + " Multi-Status";
            }
            case 208: {
                return this.getCode() + " Already Reported";
            }
            case 226: {
                return this.getCode() + " IM Used";
            }
            case 300: {
                return this.getCode() + " Multiple Choices";
            }
            case 301: {
                return this.getCode() + " Moved Permanently";
            }
            case 302: {
                return this.getCode() + " Found";
            }
            case 303: {
                return this.getCode() + " See Other";
            }
            case 304: {
                return this.getCode() + " Not Modified";
            }
            case 305: {
                return this.getCode() + " Use Proxy Deprecated";
            }
            case 306: {
                return this.getCode() + " unused";
            }
            case 307: {
                return this.getCode() + " Temporary Redirect";
            }
            case 308: {
                return this.getCode() + " Permanent Redirect";
            }
            case 400: {
                return this.getCode() + " Bad Request";
            }
            case 401: {
                return this.getCode() + " Unauthorized";
            }
            case 402: {
                return this.getCode() + " Payment Required";
            }
            case 403: {
                return this.getCode() + " Forbidden";
            }
            case 404: {
                return this.getCode() + " Not Found";
            }
            case 405: {
                return this.getCode() + " Method Not Allowed";
            }
            case 406: {
                return this.getCode() + " Not Acceptable";
            }
            case 407: {
                return this.getCode() + " Proxy Authentication Required";
            }
            case 408: {
                return this.getCode() + " Request Timeout";
            }
            case 409: {
                return this.getCode() + " Conflict";
            }
            case 410: {
                return this.getCode() + " Gone";
            }
            case 411: {
                return this.getCode() + " Length Required";
            }
            case 412: {
                return this.getCode() + " Precondition Failed";
            }
            case 413: {
                return this.getCode() + " Content Too Large";
            }
            case 414: {
                return this.getCode() + " URI Too Long";
            }
            case 415: {
                return this.getCode() + " Unsupported Media Type";
            }
            case 416: {
                return this.getCode() + " Range Not Satisfiable";
            }
            case 417: {
                return this.getCode() + " Expectation Failed";
            }
            case 418: {
                return this.getCode() + " I'm a teapot";
            }
            case 421: {
                return this.getCode() + " Misdirected Request";
            }
            case 422: {
                return this.getCode() + " Unprocessable Content";
            }
            case 423: {
                return this.getCode() + " Locked";
            }
            case 424: {
                return this.getCode() + " Failed Dependency";
            }
            case 425: {
                return this.getCode() + " Too Early Experimental";
            }
            case 426: {
                return this.getCode() + " Upgrade Required";
            }
            case 428: {
                return this.getCode() + " Precondition Required";
            }
            case 429: {
                return this.getCode() + " Too Many Requests";
            }
            case 431: {
                return this.getCode() + " Request Header Fields Too Large";
            }
            case 451: {
                return this.getCode() + " Unavailable For Legal Reasons";
            }
            case 500: {
                return this.getCode() + " Internal Server Error";
            }
            case 501: {
                return this.getCode() + " Not Implemented";
            }
            case 502: {
                return this.getCode() + " Bad Gateway";
            }
            case 503: {
                return this.getCode() + " Service Unavailable";
            }
            case 504: {
                return this.getCode() + " Gateway Timeout";
            }
            case 505: {
                return this.getCode() + " HTTP Version Not Supported";
            }
            case 506: {
                return this.getCode() + " Variant Also Negotiates";
            }
            case 507: {
                return this.getCode() + " Insufficient Storage";
            }
            case 508: {
                return this.getCode() + " Loop Detected";
            }
            case 510: {
                return this.getCode() + " Not Extended";
            }
            case 511: {
                return this.getCode() + " Network Authentication Required";
            }
        }
        return "HTTP code " + this.code;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public byte[] getContent() {
        return this.content;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Iterable<HTTPHeader> getHeaders() {
        return this.headers;
    }
}

