/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.List;

public class MergedList<T>
extends ArrayList<MergeNode<T>> {
    private static final long serialVersionUID = 1L;

    public MergedList(List<T> left, List<T> right, IMatcher<T> matcher) {
        ArrayList<T> m = new ArrayList<T>();
        for (T l : left) {
            Object t = null;
            for (T r : right) {
                if (!matcher.match(l, r)) continue;
                t = r;
                m.add(r);
                break;
            }
            this.add(new MergeNode<Object>(l, t));
        }
        for (T r : right) {
            if (m.contains(r)) continue;
            this.add(new MergeNode<Object>(null, r));
        }
    }

    public MergedList(List<T> left, List<T> right) {
        for (int i = 0; i < Integer.max(left.size(), right.size()); ++i) {
            Object l = i < left.size() ? (Object)left.get(i) : null;
            Object r = i < right.size() ? (Object)right.get(i) : null;
            this.add(new MergeNode<Object>(l, r));
        }
    }

    public static interface IMatcher<T1> {
        public boolean match(T1 var1, T1 var2);
    }

    public static class MergeNode<T1> {
        private T1 left;
        private T1 right;

        public MergeNode(T1 left, T1 right) {
            this.left = left;
            this.right = right;
        }

        public T1 getLeft() {
            return this.left;
        }

        public T1 getRight() {
            return this.right;
        }

        public boolean hasLeft() {
            return this.left != null;
        }

        public boolean hasRight() {
            return this.right != null;
        }

        public String toString() {
            return (this.hasLeft() ? this.left.toString() : "null") + " :: " + (this.hasRight() ? this.right.toString() : "null");
        }
    }
}

