/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QicoreCommunicationMedium {
    UNSPECIFIED,
    TELEPHONE,
    FAX,
    DEVICE,
    VIDEO,
    VOICEMAIL,
    TEXT,
    SOCIALMEDIA,
    INPERSON,
    MAIL,
    EMAIL,
    PORTAL,
    NULL;


    public static QicoreCommunicationMedium fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unspecified".equals(codeString)) {
            return UNSPECIFIED;
        }
        if ("telephone".equals(codeString)) {
            return TELEPHONE;
        }
        if ("fax".equals(codeString)) {
            return FAX;
        }
        if ("device".equals(codeString)) {
            return DEVICE;
        }
        if ("video".equals(codeString)) {
            return VIDEO;
        }
        if ("voicemail".equals(codeString)) {
            return VOICEMAIL;
        }
        if ("text".equals(codeString)) {
            return TEXT;
        }
        if ("social-media".equals(codeString)) {
            return SOCIALMEDIA;
        }
        if ("in-person".equals(codeString)) {
            return INPERSON;
        }
        if ("mail".equals(codeString)) {
            return MAIL;
        }
        if ("email".equals(codeString)) {
            return EMAIL;
        }
        if ("portal".equals(codeString)) {
            return PORTAL;
        }
        throw new FHIRException("Unknown QicoreCommunicationMedium code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNSPECIFIED: {
                return "unspecified";
            }
            case TELEPHONE: {
                return "telephone";
            }
            case FAX: {
                return "fax";
            }
            case DEVICE: {
                return "device";
            }
            case VIDEO: {
                return "video";
            }
            case VOICEMAIL: {
                return "voicemail";
            }
            case TEXT: {
                return "text";
            }
            case SOCIALMEDIA: {
                return "social-media";
            }
            case INPERSON: {
                return "in-person";
            }
            case MAIL: {
                return "mail";
            }
            case EMAIL: {
                return "email";
            }
            case PORTAL: {
                return "portal";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/qicore-communication-medium";
    }

    public String getDefinition() {
        switch (this) {
            case UNSPECIFIED: {
                return "The communication medium has not been specified";
            }
            case TELEPHONE: {
                return "The message was communicated via telephone";
            }
            case FAX: {
                return "The message was sent via a fax transmission";
            }
            case DEVICE: {
                return "The message was communicated via a medical device";
            }
            case VIDEO: {
                return "The message was communicated via a video call";
            }
            case VOICEMAIL: {
                return "The message was left on the recipient's voicemail system";
            }
            case TEXT: {
                return "The message was sent via text message (SMS)";
            }
            case SOCIALMEDIA: {
                return "The message was communicated via a social media platform";
            }
            case INPERSON: {
                return "The message was communicated in person";
            }
            case MAIL: {
                return "The message was posted via conventional mail";
            }
            case EMAIL: {
                return "The message was sent as an email";
            }
            case PORTAL: {
                return "The message was communicated via a patient portal";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNSPECIFIED: {
                return "Not Specified";
            }
            case TELEPHONE: {
                return "Telephone";
            }
            case FAX: {
                return "Facsimile (fax)";
            }
            case DEVICE: {
                return "Via medical device";
            }
            case VIDEO: {
                return "Video call";
            }
            case VOICEMAIL: {
                return "Voice message (voicemail)";
            }
            case TEXT: {
                return "Text message (SMS)";
            }
            case SOCIALMEDIA: {
                return "Social media";
            }
            case INPERSON: {
                return "In person";
            }
            case MAIL: {
                return "Mail (conventional)";
            }
            case EMAIL: {
                return "Electronic mail (email)";
            }
            case PORTAL: {
                return "Patient portal";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

