/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaMutatedWildtype {
    MUTATED,
    WILDTYPE,
    NOTTESTED,
    NULL;


    public static NehtaNehtaMutatedWildtype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("mutated".equals(codeString)) {
            return MUTATED;
        }
        if ("wild_type".equals(codeString)) {
            return WILDTYPE;
        }
        if ("not_tested".equals(codeString)) {
            return NOTTESTED;
        }
        throw new FHIRException("Unknown NehtaNehtaMutatedWildtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MUTATED: {
                return "mutated";
            }
            case WILDTYPE: {
                return "wild_type";
            }
            case NOTTESTED: {
                return "not_tested";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta-mutated-wildtype";
    }

    public String getDefinition() {
        switch (this) {
            case MUTATED: {
                return "The gene mutation type is mutated";
            }
            case WILDTYPE: {
                return "The gene mutation type is wild type";
            }
            case NOTTESTED: {
                return "The gene mutation was not tested";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MUTATED: {
                return "Mutated";
            }
            case WILDTYPE: {
                return "Wild type";
            }
            case NOTTESTED: {
                return "Not tested";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

