/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.HealthcareService;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PractitionerRole", profile="http://hl7.org/fhir/Profile/PractitionerRole")
public class PractitionerRole
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifiers that are specific to a role/location", formalDefinition="Business Identifiers that are specific to a role/location.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this practitioner's record is in active use", formalDefinition="Whether this practitioner's record is in active use.")
    protected BooleanType active;
    @Child(name="practitioner", type={Practitioner.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Practitioner that is able to provide the defined services for the organation", formalDefinition="Practitioner that is able to provide the defined services for the organation.")
    protected Reference practitioner;
    protected Practitioner practitionerTarget;
    @Child(name="organization", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization where the roles are available", formalDefinition="The organization where the Practitioner performs the roles associated.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="role", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Roles which this practitioner may perform", formalDefinition="Roles which this practitioner is authorized to perform for the organization.")
    protected List<CodeableConcept> role;
    @Child(name="specialty", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific specialty of the practitioner", formalDefinition="Specific specialty of the practitioner.")
    protected List<CodeableConcept> specialty;
    @Child(name="location", type={Location.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The location(s) at which this practitioner provides care", formalDefinition="The location(s) at which this practitioner provides care.")
    protected List<Reference> location;
    protected List<Location> locationTarget;
    @Child(name="healthcareService", type={HealthcareService.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s)", formalDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s).")
    protected List<Reference> healthcareService;
    protected List<HealthcareService> healthcareServiceTarget;
    @Child(name="telecom", type={ContactPoint.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details that are specific to the role/location/service", formalDefinition="Contact details that are specific to the role/location/service.")
    protected List<ContactPoint> telecom;
    @Child(name="period", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The period during which the practitioner is authorized to perform in these role(s)", formalDefinition="The period during which the person is authorized to act as a practitioner in these role(s) for the organization.")
    protected Period period;
    @Child(name="availableTime", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Times the Service Site is available", formalDefinition="A collection of times that the Service Site is available.")
    protected List<PractitionerRoleAvailableTimeComponent> availableTime;
    @Child(name="notAvailable", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Not available during this time due to provided reason", formalDefinition="The HealthcareService is not available during this period of time due to the provided reason.")
    protected List<PractitionerRoleNotAvailableComponent> notAvailable;
    @Child(name="availabilityExceptions", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of availability exceptions", formalDefinition="A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.")
    protected StringType availabilityExceptions;
    private static final long serialVersionUID = -408504135L;
    @SearchParamDefinition(name="organization", path="PractitionerRole.organization", description="The identity of the organization the practitioner represents / acts on behalf of", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("PractitionerRole:organization").toLocked();
    @SearchParamDefinition(name="phone", path="PractitionerRole.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="practitioner", path="PractitionerRole.practitioner", description="Practitioner that is able to provide the defined services for the organation", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("PractitionerRole:practitioner").toLocked();
    @SearchParamDefinition(name="location", path="PractitionerRole.location", description="One of the locations at which this practitioner provides care", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("PractitionerRole:location").toLocked();
    @SearchParamDefinition(name="email", path="PractitionerRole.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="telecom", path="PractitionerRole.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="role", path="PractitionerRole.role", description="The practitioner can perform this role at for the organization", type="token")
    public static final String SP_ROLE = "role";
    public static final TokenClientParam ROLE = new TokenClientParam("role");
    @SearchParamDefinition(name="specialty", path="PractitionerRole.specialty", description="The practitioner has this specialty at an organization", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="identifier", path="PractitionerRole.identifier", description="A practitioner's Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PractitionerRole addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public PractitionerRole setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public PractitionerRole setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Reference getPractitioner() {
        if (this.practitioner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.practitioner");
            }
            if (Configuration.doAutoCreate()) {
                this.practitioner = new Reference();
            }
        }
        return this.practitioner;
    }

    public boolean hasPractitioner() {
        return this.practitioner != null && !this.practitioner.isEmpty();
    }

    public PractitionerRole setPractitioner(Reference value) {
        this.practitioner = value;
        return this;
    }

    public Practitioner getPractitionerTarget() {
        if (this.practitionerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.practitioner");
            }
            if (Configuration.doAutoCreate()) {
                this.practitionerTarget = new Practitioner();
            }
        }
        return this.practitionerTarget;
    }

    public PractitionerRole setPractitionerTarget(Practitioner value) {
        this.practitionerTarget = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public PractitionerRole setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public PractitionerRole setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public List<CodeableConcept> getRole() {
        if (this.role == null) {
            this.role = new ArrayList<CodeableConcept>();
        }
        return this.role;
    }

    public boolean hasRole() {
        if (this.role == null) {
            return false;
        }
        for (CodeableConcept item : this.role) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addRole() {
        CodeableConcept t = new CodeableConcept();
        if (this.role == null) {
            this.role = new ArrayList<CodeableConcept>();
        }
        this.role.add(t);
        return t;
    }

    public PractitionerRole addRole(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.role == null) {
            this.role = new ArrayList<CodeableConcept>();
        }
        this.role.add(t);
        return this;
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public PractitionerRole addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public List<Reference> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        return this.location;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (Reference item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLocation() {
        Reference t = new Reference();
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return t;
    }

    public PractitionerRole addLocation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return this;
    }

    public List<Location> getLocationTarget() {
        if (this.locationTarget == null) {
            this.locationTarget = new ArrayList<Location>();
        }
        return this.locationTarget;
    }

    public Location addLocationTarget() {
        Location r = new Location();
        if (this.locationTarget == null) {
            this.locationTarget = new ArrayList<Location>();
        }
        this.locationTarget.add(r);
        return r;
    }

    public List<Reference> getHealthcareService() {
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        return this.healthcareService;
    }

    public boolean hasHealthcareService() {
        if (this.healthcareService == null) {
            return false;
        }
        for (Reference item : this.healthcareService) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addHealthcareService() {
        Reference t = new Reference();
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        this.healthcareService.add(t);
        return t;
    }

    public PractitionerRole addHealthcareService(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        this.healthcareService.add(t);
        return this;
    }

    public List<HealthcareService> getHealthcareServiceTarget() {
        if (this.healthcareServiceTarget == null) {
            this.healthcareServiceTarget = new ArrayList<HealthcareService>();
        }
        return this.healthcareServiceTarget;
    }

    public HealthcareService addHealthcareServiceTarget() {
        HealthcareService r = new HealthcareService();
        if (this.healthcareServiceTarget == null) {
            this.healthcareServiceTarget = new ArrayList<HealthcareService>();
        }
        this.healthcareServiceTarget.add(r);
        return r;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public PractitionerRole addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public PractitionerRole setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<PractitionerRoleAvailableTimeComponent> getAvailableTime() {
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<PractitionerRoleAvailableTimeComponent>();
        }
        return this.availableTime;
    }

    public boolean hasAvailableTime() {
        if (this.availableTime == null) {
            return false;
        }
        for (PractitionerRoleAvailableTimeComponent item : this.availableTime) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PractitionerRoleAvailableTimeComponent addAvailableTime() {
        PractitionerRoleAvailableTimeComponent t = new PractitionerRoleAvailableTimeComponent();
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<PractitionerRoleAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return t;
    }

    public PractitionerRole addAvailableTime(PractitionerRoleAvailableTimeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<PractitionerRoleAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return this;
    }

    public List<PractitionerRoleNotAvailableComponent> getNotAvailable() {
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<PractitionerRoleNotAvailableComponent>();
        }
        return this.notAvailable;
    }

    public boolean hasNotAvailable() {
        if (this.notAvailable == null) {
            return false;
        }
        for (PractitionerRoleNotAvailableComponent item : this.notAvailable) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PractitionerRoleNotAvailableComponent addNotAvailable() {
        PractitionerRoleNotAvailableComponent t = new PractitionerRoleNotAvailableComponent();
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<PractitionerRoleNotAvailableComponent>();
        }
        this.notAvailable.add(t);
        return t;
    }

    public PractitionerRole addNotAvailable(PractitionerRoleNotAvailableComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<PractitionerRoleNotAvailableComponent>();
        }
        this.notAvailable.add(t);
        return this;
    }

    public StringType getAvailabilityExceptionsElement() {
        if (this.availabilityExceptions == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.availabilityExceptions");
            }
            if (Configuration.doAutoCreate()) {
                this.availabilityExceptions = new StringType();
            }
        }
        return this.availabilityExceptions;
    }

    public boolean hasAvailabilityExceptionsElement() {
        return this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty();
    }

    public boolean hasAvailabilityExceptions() {
        return this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty();
    }

    public PractitionerRole setAvailabilityExceptionsElement(StringType value) {
        this.availabilityExceptions = value;
        return this;
    }

    public String getAvailabilityExceptions() {
        return this.availabilityExceptions == null ? null : (String)this.availabilityExceptions.getValue();
    }

    public PractitionerRole setAvailabilityExceptions(String value) {
        if (Utilities.noString((String)value)) {
            this.availabilityExceptions = null;
        } else {
            if (this.availabilityExceptions == null) {
                this.availabilityExceptions = new StringType();
            }
            this.availabilityExceptions.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Business Identifiers that are specific to a role/location.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("active", "boolean", "Whether this practitioner's record is in active use.", 0, Integer.MAX_VALUE, this.active));
        childrenList.add(new Property(SP_PRACTITIONER, "Reference(Practitioner)", "Practitioner that is able to provide the defined services for the organation.", 0, Integer.MAX_VALUE, this.practitioner));
        childrenList.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization where the Practitioner performs the roles associated.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property(SP_ROLE, "CodeableConcept", "Roles which this practitioner is authorized to perform for the organization.", 0, Integer.MAX_VALUE, this.role));
        childrenList.add(new Property(SP_SPECIALTY, "CodeableConcept", "Specific specialty of the practitioner.", 0, Integer.MAX_VALUE, this.specialty));
        childrenList.add(new Property(SP_LOCATION, "Reference(Location)", "The location(s) at which this practitioner provides care.", 0, Integer.MAX_VALUE, this.location));
        childrenList.add(new Property("healthcareService", "Reference(HealthcareService)", "The list of healthcare services that this worker provides for this role's Organization/Location(s).", 0, Integer.MAX_VALUE, this.healthcareService));
        childrenList.add(new Property(SP_TELECOM, "ContactPoint", "Contact details that are specific to the role/location/service.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property("period", "Period", "The period during which the person is authorized to act as a practitioner in these role(s) for the organization.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("availableTime", "", "A collection of times that the Service Site is available.", 0, Integer.MAX_VALUE, this.availableTime));
        childrenList.add(new Property("notAvailable", "", "The HealthcareService is not available during this period of time due to the provided reason.", 0, Integer.MAX_VALUE, this.notAvailable));
        childrenList.add(new Property("availabilityExceptions", "string", "A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.", 0, Integer.MAX_VALUE, this.availabilityExceptions));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 574573338: {
                Base[] baseArray;
                if (this.practitioner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.practitioner;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.organization;
                }
                return baseArray;
            }
            case 3506294: {
                return this.role == null ? new Base[]{} : this.role.toArray(new Base[this.role.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 1289661064: {
                return this.healthcareService == null ? new Base[]{} : this.healthcareService.toArray(new Base[this.healthcareService.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case 1873069366: {
                return this.availableTime == null ? new Base[]{} : this.availableTime.toArray(new Base[this.availableTime.size()]);
            }
            case -629572298: {
                return this.notAvailable == null ? new Base[]{} : this.notAvailable.toArray(new Base[this.notAvailable.size()]);
            }
            case -1149143617: {
                Base[] baseArray;
                if (this.availabilityExceptions == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.availabilityExceptions;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                break;
            }
            case 574573338: {
                this.practitioner = this.castToReference(value);
                break;
            }
            case 1178922291: {
                this.organization = this.castToReference(value);
                break;
            }
            case 3506294: {
                this.getRole().add(this.castToCodeableConcept(value));
                break;
            }
            case -1694759682: {
                this.getSpecialty().add(this.castToCodeableConcept(value));
                break;
            }
            case 1901043637: {
                this.getLocation().add(this.castToReference(value));
                break;
            }
            case 1289661064: {
                this.getHealthcareService().add(this.castToReference(value));
                break;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case 1873069366: {
                this.getAvailableTime().add((PractitionerRoleAvailableTimeComponent)value);
                break;
            }
            case -629572298: {
                this.getNotAvailable().add((PractitionerRoleNotAvailableComponent)value);
                break;
            }
            case -1149143617: {
                this.availabilityExceptions = this.castToString(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("active")) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_PRACTITIONER)) {
            this.practitioner = this.castToReference(value);
        } else if (name.equals(SP_ORGANIZATION)) {
            this.organization = this.castToReference(value);
        } else if (name.equals(SP_ROLE)) {
            this.getRole().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add(this.castToReference(value));
        } else if (name.equals("healthcareService")) {
            this.getHealthcareService().add(this.castToReference(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("availableTime")) {
            this.getAvailableTime().add((PractitionerRoleAvailableTimeComponent)value);
        } else if (name.equals("notAvailable")) {
            this.getNotAvailable().add((PractitionerRoleNotAvailableComponent)value);
        } else if (name.equals("availabilityExceptions")) {
            this.availabilityExceptions = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                throw new FHIRException("Cannot make property active as it is not a complex type");
            }
            case 574573338: {
                return this.getPractitioner();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 3506294: {
                return this.addRole();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 1289661064: {
                return this.addHealthcareService();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1873069366: {
                return this.addAvailableTime();
            }
            case -629572298: {
                return this.addNotAvailable();
            }
            case -1149143617: {
                throw new FHIRException("Cannot make property availabilityExceptions as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("active")) {
            throw new FHIRException("Cannot call addChild on a singleton property PractitionerRole.active");
        }
        if (name.equals(SP_PRACTITIONER)) {
            this.practitioner = new Reference();
            return this.practitioner;
        }
        if (name.equals(SP_ORGANIZATION)) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals(SP_ROLE)) {
            return this.addRole();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals("healthcareService")) {
            return this.addHealthcareService();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("availableTime")) {
            return this.addAvailableTime();
        }
        if (name.equals("notAvailable")) {
            return this.addNotAvailable();
        }
        if (name.equals("availabilityExceptions")) {
            throw new FHIRException("Cannot call addChild on a singleton property PractitionerRole.availabilityExceptions");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PractitionerRole";
    }

    @Override
    public PractitionerRole copy() {
        PractitionerRole dst = new PractitionerRole();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        dst.practitioner = this.practitioner == null ? null : this.practitioner.copy();
        Reference reference = dst.organization = this.organization == null ? null : this.organization.copy();
        if (this.role != null) {
            dst.role = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.role) {
                dst.role.add(codeableConcept.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialty) {
                dst.specialty.add(codeableConcept.copy());
            }
        }
        if (this.location != null) {
            dst.location = new ArrayList<Reference>();
            for (Reference reference2 : this.location) {
                dst.location.add(reference2.copy());
            }
        }
        if (this.healthcareService != null) {
            dst.healthcareService = new ArrayList<Reference>();
            for (Reference reference3 : this.healthcareService) {
                dst.healthcareService.add(reference3.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.availableTime != null) {
            dst.availableTime = new ArrayList<PractitionerRoleAvailableTimeComponent>();
            for (PractitionerRoleAvailableTimeComponent practitionerRoleAvailableTimeComponent : this.availableTime) {
                dst.availableTime.add(practitionerRoleAvailableTimeComponent.copy());
            }
        }
        if (this.notAvailable != null) {
            dst.notAvailable = new ArrayList<PractitionerRoleNotAvailableComponent>();
            for (PractitionerRoleNotAvailableComponent practitionerRoleNotAvailableComponent : this.notAvailable) {
                dst.notAvailable.add(practitionerRoleNotAvailableComponent.copy());
            }
        }
        dst.availabilityExceptions = this.availabilityExceptions == null ? null : this.availabilityExceptions.copy();
        return dst;
    }

    protected PractitionerRole typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof PractitionerRole)) {
            return false;
        }
        PractitionerRole o = (PractitionerRole)other;
        return PractitionerRole.compareDeep(this.identifier, o.identifier, true) && PractitionerRole.compareDeep(this.active, o.active, true) && PractitionerRole.compareDeep(this.practitioner, o.practitioner, true) && PractitionerRole.compareDeep(this.organization, o.organization, true) && PractitionerRole.compareDeep(this.role, o.role, true) && PractitionerRole.compareDeep(this.specialty, o.specialty, true) && PractitionerRole.compareDeep(this.location, o.location, true) && PractitionerRole.compareDeep(this.healthcareService, o.healthcareService, true) && PractitionerRole.compareDeep(this.telecom, o.telecom, true) && PractitionerRole.compareDeep(this.period, o.period, true) && PractitionerRole.compareDeep(this.availableTime, o.availableTime, true) && PractitionerRole.compareDeep(this.notAvailable, o.notAvailable, true) && PractitionerRole.compareDeep(this.availabilityExceptions, o.availabilityExceptions, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof PractitionerRole)) {
            return false;
        }
        PractitionerRole o = (PractitionerRole)other;
        return PractitionerRole.compareValues(this.active, o.active, true) && PractitionerRole.compareValues(this.availabilityExceptions, o.availabilityExceptions, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.active != null && !this.active.isEmpty() || this.practitioner != null && !this.practitioner.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.role != null && !this.role.isEmpty() || this.specialty != null && !this.specialty.isEmpty() || this.location != null && !this.location.isEmpty() || this.healthcareService != null && !this.healthcareService.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.period != null && !this.period.isEmpty() || this.availableTime != null && !this.availableTime.isEmpty() || this.notAvailable != null && !this.notAvailable.isEmpty() || this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PractitionerRole;
    }

    @Block
    public static class PractitionerRoleAvailableTimeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="daysOfWeek", type={CodeType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="mon | tue | wed | thu | fri | sat | sun", formalDefinition="Indicates which days of the week are available between the start and end Times.")
        protected List<CodeType> daysOfWeek;
        @Child(name="allDay", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Always available? e.g. 24 hour service", formalDefinition="Is this always available? (hence times are irrelevant) e.g. 24 hour service.")
        protected BooleanType allDay;
        @Child(name="availableStartTime", type={TimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Opening time of day (ignored if allDay = true)", formalDefinition="The opening time of day. Note: If the AllDay flag is set, then this time is ignored.")
        protected TimeType availableStartTime;
        @Child(name="availableEndTime", type={TimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Closing time of day (ignored if allDay = true)", formalDefinition="The closing time of day. Note: If the AllDay flag is set, then this time is ignored.")
        protected TimeType availableEndTime;
        private static final long serialVersionUID = 2079379177L;

        public List<CodeType> getDaysOfWeek() {
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<CodeType>();
            }
            return this.daysOfWeek;
        }

        public boolean hasDaysOfWeek() {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (CodeType item : this.daysOfWeek) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addDaysOfWeekElement() {
            CodeType t = new CodeType();
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<CodeType>();
            }
            this.daysOfWeek.add(t);
            return t;
        }

        public PractitionerRoleAvailableTimeComponent addDaysOfWeek(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<CodeType>();
            }
            this.daysOfWeek.add(t);
            return this;
        }

        public boolean hasDaysOfWeek(String value) {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (CodeType v : this.daysOfWeek) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public BooleanType getAllDayElement() {
            if (this.allDay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerRoleAvailableTimeComponent.allDay");
                }
                if (Configuration.doAutoCreate()) {
                    this.allDay = new BooleanType();
                }
            }
            return this.allDay;
        }

        public boolean hasAllDayElement() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public boolean hasAllDay() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public PractitionerRoleAvailableTimeComponent setAllDayElement(BooleanType value) {
            this.allDay = value;
            return this;
        }

        public boolean getAllDay() {
            return this.allDay == null || this.allDay.isEmpty() ? false : (Boolean)this.allDay.getValue();
        }

        public PractitionerRoleAvailableTimeComponent setAllDay(boolean value) {
            if (this.allDay == null) {
                this.allDay = new BooleanType();
            }
            this.allDay.setValue((Object)value);
            return this;
        }

        public TimeType getAvailableStartTimeElement() {
            if (this.availableStartTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerRoleAvailableTimeComponent.availableStartTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableStartTime = new TimeType();
                }
            }
            return this.availableStartTime;
        }

        public boolean hasAvailableStartTimeElement() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public boolean hasAvailableStartTime() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public PractitionerRoleAvailableTimeComponent setAvailableStartTimeElement(TimeType value) {
            this.availableStartTime = value;
            return this;
        }

        public String getAvailableStartTime() {
            return this.availableStartTime == null ? null : (String)this.availableStartTime.getValue();
        }

        public PractitionerRoleAvailableTimeComponent setAvailableStartTime(String value) {
            if (value == null) {
                this.availableStartTime = null;
            } else {
                if (this.availableStartTime == null) {
                    this.availableStartTime = new TimeType();
                }
                this.availableStartTime.setValue(value);
            }
            return this;
        }

        public TimeType getAvailableEndTimeElement() {
            if (this.availableEndTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerRoleAvailableTimeComponent.availableEndTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableEndTime = new TimeType();
                }
            }
            return this.availableEndTime;
        }

        public boolean hasAvailableEndTimeElement() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public boolean hasAvailableEndTime() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public PractitionerRoleAvailableTimeComponent setAvailableEndTimeElement(TimeType value) {
            this.availableEndTime = value;
            return this;
        }

        public String getAvailableEndTime() {
            return this.availableEndTime == null ? null : (String)this.availableEndTime.getValue();
        }

        public PractitionerRoleAvailableTimeComponent setAvailableEndTime(String value) {
            if (value == null) {
                this.availableEndTime = null;
            } else {
                if (this.availableEndTime == null) {
                    this.availableEndTime = new TimeType();
                }
                this.availableEndTime.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("daysOfWeek", "code", "Indicates which days of the week are available between the start and end Times.", 0, Integer.MAX_VALUE, this.daysOfWeek));
            childrenList.add(new Property("allDay", "boolean", "Is this always available? (hence times are irrelevant) e.g. 24 hour service.", 0, Integer.MAX_VALUE, this.allDay));
            childrenList.add(new Property("availableStartTime", "time", "The opening time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, Integer.MAX_VALUE, this.availableStartTime));
            childrenList.add(new Property("availableEndTime", "time", "The closing time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, Integer.MAX_VALUE, this.availableEndTime));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return this.daysOfWeek == null ? new Base[]{} : this.daysOfWeek.toArray(new Base[this.daysOfWeek.size()]);
                }
                case -1414913477: {
                    Base[] baseArray;
                    if (this.allDay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.allDay;
                    }
                    return baseArray;
                }
                case -1039453818: {
                    Base[] baseArray;
                    if (this.availableStartTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.availableStartTime;
                    }
                    return baseArray;
                }
                case 101151551: {
                    Base[] baseArray;
                    if (this.availableEndTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.availableEndTime;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    this.getDaysOfWeek().add(this.castToCode(value));
                    break;
                }
                case -1414913477: {
                    this.allDay = this.castToBoolean(value);
                    break;
                }
                case -1039453818: {
                    this.availableStartTime = this.castToTime(value);
                    break;
                }
                case 101151551: {
                    this.availableEndTime = this.castToTime(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                this.getDaysOfWeek().add(this.castToCode(value));
            } else if (name.equals("allDay")) {
                this.allDay = this.castToBoolean(value);
            } else if (name.equals("availableStartTime")) {
                this.availableStartTime = this.castToTime(value);
            } else if (name.equals("availableEndTime")) {
                this.availableEndTime = this.castToTime(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    throw new FHIRException("Cannot make property daysOfWeek as it is not a complex type");
                }
                case -1414913477: {
                    throw new FHIRException("Cannot make property allDay as it is not a complex type");
                }
                case -1039453818: {
                    throw new FHIRException("Cannot make property availableStartTime as it is not a complex type");
                }
                case 101151551: {
                    throw new FHIRException("Cannot make property availableEndTime as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                throw new FHIRException("Cannot call addChild on a singleton property PractitionerRole.daysOfWeek");
            }
            if (name.equals("allDay")) {
                throw new FHIRException("Cannot call addChild on a singleton property PractitionerRole.allDay");
            }
            if (name.equals("availableStartTime")) {
                throw new FHIRException("Cannot call addChild on a singleton property PractitionerRole.availableStartTime");
            }
            if (name.equals("availableEndTime")) {
                throw new FHIRException("Cannot call addChild on a singleton property PractitionerRole.availableEndTime");
            }
            return super.addChild(name);
        }

        @Override
        public PractitionerRoleAvailableTimeComponent copy() {
            PractitionerRoleAvailableTimeComponent dst = new PractitionerRoleAvailableTimeComponent();
            this.copyValues(dst);
            if (this.daysOfWeek != null) {
                dst.daysOfWeek = new ArrayList<CodeType>();
                for (CodeType i : this.daysOfWeek) {
                    dst.daysOfWeek.add(i.copy());
                }
            }
            dst.allDay = this.allDay == null ? null : this.allDay.copy();
            dst.availableStartTime = this.availableStartTime == null ? null : this.availableStartTime.copy();
            dst.availableEndTime = this.availableEndTime == null ? null : this.availableEndTime.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PractitionerRoleAvailableTimeComponent)) {
                return false;
            }
            PractitionerRoleAvailableTimeComponent o = (PractitionerRoleAvailableTimeComponent)other;
            return PractitionerRoleAvailableTimeComponent.compareDeep(this.daysOfWeek, o.daysOfWeek, true) && PractitionerRoleAvailableTimeComponent.compareDeep(this.allDay, o.allDay, true) && PractitionerRoleAvailableTimeComponent.compareDeep(this.availableStartTime, o.availableStartTime, true) && PractitionerRoleAvailableTimeComponent.compareDeep(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PractitionerRoleAvailableTimeComponent)) {
                return false;
            }
            PractitionerRoleAvailableTimeComponent o = (PractitionerRoleAvailableTimeComponent)other;
            return PractitionerRoleAvailableTimeComponent.compareValues(this.daysOfWeek, o.daysOfWeek, true) && PractitionerRoleAvailableTimeComponent.compareValues(this.allDay, o.allDay, true) && PractitionerRoleAvailableTimeComponent.compareValues(this.availableStartTime, o.availableStartTime, true) && PractitionerRoleAvailableTimeComponent.compareValues(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.daysOfWeek != null && !this.daysOfWeek.isEmpty() || this.allDay != null && !this.allDay.isEmpty() || this.availableStartTime != null && !this.availableStartTime.isEmpty() || this.availableEndTime != null && !this.availableEndTime.isEmpty());
        }

        @Override
        public String fhirType() {
            return "PractitionerRole.availableTime";
        }
    }

    @Block
    public static class PractitionerRoleNotAvailableComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason presented to the user explaining why time not available", formalDefinition="The reason that can be presented to the user as to why this time is not available.")
        protected StringType description;
        @Child(name="during", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service not availablefrom this date", formalDefinition="Service is not available (seasonally or for a public holiday) from this date.")
        protected Period during;
        private static final long serialVersionUID = 310849929L;

        public PractitionerRoleNotAvailableComponent() {
        }

        public PractitionerRoleNotAvailableComponent(StringType description) {
            this.description = description;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerRoleNotAvailableComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PractitionerRoleNotAvailableComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public PractitionerRoleNotAvailableComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public Period getDuring() {
            if (this.during == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerRoleNotAvailableComponent.during");
                }
                if (Configuration.doAutoCreate()) {
                    this.during = new Period();
                }
            }
            return this.during;
        }

        public boolean hasDuring() {
            return this.during != null && !this.during.isEmpty();
        }

        public PractitionerRoleNotAvailableComponent setDuring(Period value) {
            this.during = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("description", "string", "The reason that can be presented to the user as to why this time is not available.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("during", "Period", "Service is not available (seasonally or for a public holiday) from this date.", 0, Integer.MAX_VALUE, this.during));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1320499647: {
                    Base[] baseArray;
                    if (this.during == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.during;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -1320499647: {
                    this.during = this.castToPeriod(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("during")) {
                this.during = this.castToPeriod(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -1320499647: {
                    return this.getDuring();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property PractitionerRole.description");
            }
            if (name.equals("during")) {
                this.during = new Period();
                return this.during;
            }
            return super.addChild(name);
        }

        @Override
        public PractitionerRoleNotAvailableComponent copy() {
            PractitionerRoleNotAvailableComponent dst = new PractitionerRoleNotAvailableComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.during = this.during == null ? null : this.during.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PractitionerRoleNotAvailableComponent)) {
                return false;
            }
            PractitionerRoleNotAvailableComponent o = (PractitionerRoleNotAvailableComponent)other;
            return PractitionerRoleNotAvailableComponent.compareDeep(this.description, o.description, true) && PractitionerRoleNotAvailableComponent.compareDeep(this.during, o.during, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PractitionerRoleNotAvailableComponent)) {
                return false;
            }
            PractitionerRoleNotAvailableComponent o = (PractitionerRoleNotAvailableComponent)other;
            return PractitionerRoleNotAvailableComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.description != null && !this.description.isEmpty() || this.during != null && !this.during.isEmpty());
        }

        @Override
        public String fhirType() {
            return "PractitionerRole.notAvailable";
        }
    }
}

