/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3ActRelationshipCheckpoint {
    B,
    E,
    S,
    T,
    X,
    NULL;


    public static V3ActRelationshipCheckpoint fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("B".equals(codeString)) {
            return B;
        }
        if ("E".equals(codeString)) {
            return E;
        }
        if ("S".equals(codeString)) {
            return S;
        }
        if ("T".equals(codeString)) {
            return T;
        }
        if ("X".equals(codeString)) {
            return X;
        }
        throw new FHIRException("Unknown V3ActRelationshipCheckpoint code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case B: {
                return "B";
            }
            case E: {
                return "E";
            }
            case S: {
                return "S";
            }
            case T: {
                return "T";
            }
            case X: {
                return "X";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/ActRelationshipCheckpoint";
    }

    public String getDefinition() {
        switch (this) {
            case B: {
                return "Condition is tested every time before execution of the service (WHILE condition DO service).";
            }
            case E: {
                return "Condition is tested at the end of a repeated service execution.  The service is repeated only if the condition is true (DO service WHILE condition).";
            }
            case S: {
                return "Condition is tested once before the service is executed (IF condition THEN service).";
            }
            case T: {
                return "Condition must be true throughout the execution and the service is interrupted (asynchronously) as soon as the condition turns false (asynchronous WHILE loop).  The service must be interruptible.";
            }
            case X: {
                return "Condition is a loop checkpoint, i.e. it is a step of an activity plan and, if negative causes the containing loop to exit.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case B: {
                return "beginning";
            }
            case E: {
                return "end";
            }
            case S: {
                return "entry";
            }
            case T: {
                return "through";
            }
            case X: {
                return "exit";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

